package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "succeededUserCount", 
    "failedUserCount"})
@JsonInclude(Include.NON_NULL)
public class OfficeUserCheckinSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("succeededUserCount")
    protected Integer succeededUserCount;

    @JsonProperty("failedUserCount")
    protected Integer failedUserCount;

    protected OfficeUserCheckinSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.officeUserCheckinSummary";
    }

    @Property(name="succeededUserCount")
    @JsonIgnore
    public Optional<Integer> getSucceededUserCount() {
        return Optional.ofNullable(succeededUserCount);
    }

    public OfficeUserCheckinSummary withSucceededUserCount(Integer succeededUserCount) {
        OfficeUserCheckinSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeUserCheckinSummary");
        _x.succeededUserCount = succeededUserCount;
        return _x;
    }

    @Property(name="failedUserCount")
    @JsonIgnore
    public Optional<Integer> getFailedUserCount() {
        return Optional.ofNullable(failedUserCount);
    }

    public OfficeUserCheckinSummary withFailedUserCount(Integer failedUserCount) {
        OfficeUserCheckinSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeUserCheckinSummary");
        _x.failedUserCount = failedUserCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer succeededUserCount;
        private Integer failedUserCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder succeededUserCount(Integer succeededUserCount) {
            this.succeededUserCount = succeededUserCount;
            this.changedFields = changedFields.add("succeededUserCount");
            return this;
        }

        public Builder failedUserCount(Integer failedUserCount) {
            this.failedUserCount = failedUserCount;
            this.changedFields = changedFields.add("failedUserCount");
            return this;
        }

        public OfficeUserCheckinSummary build() {
            OfficeUserCheckinSummary _x = new OfficeUserCheckinSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.officeUserCheckinSummary";
            _x.succeededUserCount = succeededUserCount;
            _x.failedUserCount = failedUserCount;
            return _x;
        }
    }

    private OfficeUserCheckinSummary _copy() {
        OfficeUserCheckinSummary _x = new OfficeUserCheckinSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.succeededUserCount = succeededUserCount;
        _x.failedUserCount = failedUserCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OfficeUserCheckinSummary[");
        b.append("succeededUserCount=");
        b.append(this.succeededUserCount);
        b.append(", ");
        b.append("failedUserCount=");
        b.append(this.failedUserCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
