package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ObjectFlowTypes;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "attributeMappings", 
    "enabled", 
    "flowTypes", 
    "metadata", 
    "name", 
    "scope", 
    "sourceObjectName", 
    "targetObjectName"})
@JsonInclude(Include.NON_NULL)
public class ObjectMapping implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("attributeMappings")
    protected List<AttributeMapping> attributeMappings;

    @JsonProperty("attributeMappings@nextLink")
    protected String attributeMappingsNextLink;

    @JsonProperty("enabled")
    protected Boolean enabled;

    @JsonProperty("flowTypes")
    protected ObjectFlowTypes flowTypes;

    @JsonProperty("metadata")
    protected List<MetadataEntry> metadata;

    @JsonProperty("metadata@nextLink")
    protected String metadataNextLink;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("scope")
    protected Filter scope;

    @JsonProperty("sourceObjectName")
    protected String sourceObjectName;

    @JsonProperty("targetObjectName")
    protected String targetObjectName;

    protected ObjectMapping() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.objectMapping";
    }

    @Property(name="attributeMappings")
    @JsonIgnore
    public CollectionPage<AttributeMapping> getAttributeMappings() {
        return new CollectionPage<AttributeMapping>(contextPath, AttributeMapping.class, attributeMappings, Optional.ofNullable(attributeMappingsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="attributeMappings")
    @JsonIgnore
    public CollectionPage<AttributeMapping> getAttributeMappings(HttpRequestOptions options) {
        return new CollectionPage<AttributeMapping>(contextPath, AttributeMapping.class, attributeMappings, Optional.ofNullable(attributeMappingsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="enabled")
    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        return Optional.ofNullable(enabled);
    }

    public ObjectMapping withEnabled(Boolean enabled) {
        ObjectMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.objectMapping");
        _x.enabled = enabled;
        return _x;
    }

    @Property(name="flowTypes")
    @JsonIgnore
    public Optional<ObjectFlowTypes> getFlowTypes() {
        return Optional.ofNullable(flowTypes);
    }

    public ObjectMapping withFlowTypes(ObjectFlowTypes flowTypes) {
        ObjectMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.objectMapping");
        _x.flowTypes = flowTypes;
        return _x;
    }

    @Property(name="metadata")
    @JsonIgnore
    public CollectionPage<MetadataEntry> getMetadata() {
        return new CollectionPage<MetadataEntry>(contextPath, MetadataEntry.class, metadata, Optional.ofNullable(metadataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="metadata")
    @JsonIgnore
    public CollectionPage<MetadataEntry> getMetadata(HttpRequestOptions options) {
        return new CollectionPage<MetadataEntry>(contextPath, MetadataEntry.class, metadata, Optional.ofNullable(metadataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ObjectMapping withName(String name) {
        ObjectMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.objectMapping");
        _x.name = name;
        return _x;
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<Filter> getScope() {
        return Optional.ofNullable(scope);
    }

    public ObjectMapping withScope(Filter scope) {
        ObjectMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.objectMapping");
        _x.scope = scope;
        return _x;
    }

    @Property(name="sourceObjectName")
    @JsonIgnore
    public Optional<String> getSourceObjectName() {
        return Optional.ofNullable(sourceObjectName);
    }

    public ObjectMapping withSourceObjectName(String sourceObjectName) {
        ObjectMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.objectMapping");
        _x.sourceObjectName = sourceObjectName;
        return _x;
    }

    @Property(name="targetObjectName")
    @JsonIgnore
    public Optional<String> getTargetObjectName() {
        return Optional.ofNullable(targetObjectName);
    }

    public ObjectMapping withTargetObjectName(String targetObjectName) {
        ObjectMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.objectMapping");
        _x.targetObjectName = targetObjectName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AttributeMapping> attributeMappings;
        private String attributeMappingsNextLink;
        private Boolean enabled;
        private ObjectFlowTypes flowTypes;
        private List<MetadataEntry> metadata;
        private String metadataNextLink;
        private String name;
        private Filter scope;
        private String sourceObjectName;
        private String targetObjectName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder attributeMappings(List<AttributeMapping> attributeMappings) {
            this.attributeMappings = attributeMappings;
            this.changedFields = changedFields.add("attributeMappings");
            return this;
        }

        public Builder attributeMappings(AttributeMapping... attributeMappings) {
            return attributeMappings(Arrays.asList(attributeMappings));
        }

        public Builder attributeMappingsNextLink(String attributeMappingsNextLink) {
            this.attributeMappingsNextLink = attributeMappingsNextLink;
            this.changedFields = changedFields.add("attributeMappings");
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            this.changedFields = changedFields.add("enabled");
            return this;
        }

        public Builder flowTypes(ObjectFlowTypes flowTypes) {
            this.flowTypes = flowTypes;
            this.changedFields = changedFields.add("flowTypes");
            return this;
        }

        public Builder metadata(List<MetadataEntry> metadata) {
            this.metadata = metadata;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public Builder metadata(MetadataEntry... metadata) {
            return metadata(Arrays.asList(metadata));
        }

        public Builder metadataNextLink(String metadataNextLink) {
            this.metadataNextLink = metadataNextLink;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder scope(Filter scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public Builder sourceObjectName(String sourceObjectName) {
            this.sourceObjectName = sourceObjectName;
            this.changedFields = changedFields.add("sourceObjectName");
            return this;
        }

        public Builder targetObjectName(String targetObjectName) {
            this.targetObjectName = targetObjectName;
            this.changedFields = changedFields.add("targetObjectName");
            return this;
        }

        public ObjectMapping build() {
            ObjectMapping _x = new ObjectMapping();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.objectMapping";
            _x.attributeMappings = attributeMappings;
            _x.attributeMappingsNextLink = attributeMappingsNextLink;
            _x.enabled = enabled;
            _x.flowTypes = flowTypes;
            _x.metadata = metadata;
            _x.metadataNextLink = metadataNextLink;
            _x.name = name;
            _x.scope = scope;
            _x.sourceObjectName = sourceObjectName;
            _x.targetObjectName = targetObjectName;
            return _x;
        }
    }

    private ObjectMapping _copy() {
        ObjectMapping _x = new ObjectMapping();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.attributeMappings = attributeMappings;
        _x.enabled = enabled;
        _x.flowTypes = flowTypes;
        _x.metadata = metadata;
        _x.name = name;
        _x.scope = scope;
        _x.sourceObjectName = sourceObjectName;
        _x.targetObjectName = targetObjectName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ObjectMapping[");
        b.append("attributeMappings=");
        b.append(this.attributeMappings);
        b.append(", ");
        b.append("enabled=");
        b.append(this.enabled);
        b.append(", ");
        b.append("flowTypes=");
        b.append(this.flowTypes);
        b.append(", ");
        b.append("metadata=");
        b.append(this.metadata);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append(", ");
        b.append("sourceObjectName=");
        b.append(this.sourceObjectName);
        b.append(", ");
        b.append("targetObjectName=");
        b.append(this.targetObjectName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
