package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "attributes", 
    "metadata", 
    "name", 
    "supportedApis"})
@JsonInclude(Include.NON_NULL)
public class ObjectDefinition implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("attributes")
    protected List<AttributeDefinition> attributes;

    @JsonProperty("attributes@nextLink")
    protected String attributesNextLink;

    @JsonProperty("metadata")
    protected List<MetadataEntry> metadata;

    @JsonProperty("metadata@nextLink")
    protected String metadataNextLink;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("supportedApis")
    protected List<String> supportedApis;

    @JsonProperty("supportedApis@nextLink")
    protected String supportedApisNextLink;

    protected ObjectDefinition() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.objectDefinition";
    }

    @Property(name="attributes")
    @JsonIgnore
    public CollectionPage<AttributeDefinition> getAttributes() {
        return new CollectionPage<AttributeDefinition>(contextPath, AttributeDefinition.class, attributes, Optional.ofNullable(attributesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="attributes")
    @JsonIgnore
    public CollectionPage<AttributeDefinition> getAttributes(HttpRequestOptions options) {
        return new CollectionPage<AttributeDefinition>(contextPath, AttributeDefinition.class, attributes, Optional.ofNullable(attributesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="metadata")
    @JsonIgnore
    public CollectionPage<MetadataEntry> getMetadata() {
        return new CollectionPage<MetadataEntry>(contextPath, MetadataEntry.class, metadata, Optional.ofNullable(metadataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="metadata")
    @JsonIgnore
    public CollectionPage<MetadataEntry> getMetadata(HttpRequestOptions options) {
        return new CollectionPage<MetadataEntry>(contextPath, MetadataEntry.class, metadata, Optional.ofNullable(metadataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ObjectDefinition withName(String name) {
        ObjectDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.objectDefinition");
        _x.name = name;
        return _x;
    }

    @Property(name="supportedApis")
    @JsonIgnore
    public CollectionPage<String> getSupportedApis() {
        return new CollectionPage<String>(contextPath, String.class, supportedApis, Optional.ofNullable(supportedApisNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedApis")
    @JsonIgnore
    public CollectionPage<String> getSupportedApis(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, supportedApis, Optional.ofNullable(supportedApisNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AttributeDefinition> attributes;
        private String attributesNextLink;
        private List<MetadataEntry> metadata;
        private String metadataNextLink;
        private String name;
        private List<String> supportedApis;
        private String supportedApisNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder attributes(List<AttributeDefinition> attributes) {
            this.attributes = attributes;
            this.changedFields = changedFields.add("attributes");
            return this;
        }

        public Builder attributes(AttributeDefinition... attributes) {
            return attributes(Arrays.asList(attributes));
        }

        public Builder attributesNextLink(String attributesNextLink) {
            this.attributesNextLink = attributesNextLink;
            this.changedFields = changedFields.add("attributes");
            return this;
        }

        public Builder metadata(List<MetadataEntry> metadata) {
            this.metadata = metadata;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public Builder metadata(MetadataEntry... metadata) {
            return metadata(Arrays.asList(metadata));
        }

        public Builder metadataNextLink(String metadataNextLink) {
            this.metadataNextLink = metadataNextLink;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder supportedApis(List<String> supportedApis) {
            this.supportedApis = supportedApis;
            this.changedFields = changedFields.add("supportedApis");
            return this;
        }

        public Builder supportedApis(String... supportedApis) {
            return supportedApis(Arrays.asList(supportedApis));
        }

        public Builder supportedApisNextLink(String supportedApisNextLink) {
            this.supportedApisNextLink = supportedApisNextLink;
            this.changedFields = changedFields.add("supportedApis");
            return this;
        }

        public ObjectDefinition build() {
            ObjectDefinition _x = new ObjectDefinition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.objectDefinition";
            _x.attributes = attributes;
            _x.attributesNextLink = attributesNextLink;
            _x.metadata = metadata;
            _x.metadataNextLink = metadataNextLink;
            _x.name = name;
            _x.supportedApis = supportedApis;
            _x.supportedApisNextLink = supportedApisNextLink;
            return _x;
        }
    }

    private ObjectDefinition _copy() {
        ObjectDefinition _x = new ObjectDefinition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.attributes = attributes;
        _x.metadata = metadata;
        _x.name = name;
        _x.supportedApis = supportedApis;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ObjectDefinition[");
        b.append("attributes=");
        b.append(this.attributes);
        b.append(", ");
        b.append("metadata=");
        b.append(this.metadata);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("supportedApis=");
        b.append(this.supportedApis);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
