package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "decimalPlaces", 
    "displayAs", 
    "maximum", 
    "minimum"})
@JsonInclude(Include.NON_NULL)
public class NumberColumn implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("decimalPlaces")
    protected String decimalPlaces;

    @JsonProperty("displayAs")
    protected String displayAs;

    @JsonProperty("maximum")
    protected Double maximum;

    @JsonProperty("minimum")
    protected Double minimum;

    protected NumberColumn() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.numberColumn";
    }

    @Property(name="decimalPlaces")
    @JsonIgnore
    public Optional<String> getDecimalPlaces() {
        return Optional.ofNullable(decimalPlaces);
    }

    public NumberColumn withDecimalPlaces(String decimalPlaces) {
        NumberColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.numberColumn");
        _x.decimalPlaces = decimalPlaces;
        return _x;
    }

    @Property(name="displayAs")
    @JsonIgnore
    public Optional<String> getDisplayAs() {
        return Optional.ofNullable(displayAs);
    }

    public NumberColumn withDisplayAs(String displayAs) {
        NumberColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.numberColumn");
        _x.displayAs = displayAs;
        return _x;
    }

    @Property(name="maximum")
    @JsonIgnore
    public Optional<Double> getMaximum() {
        return Optional.ofNullable(maximum);
    }

    public NumberColumn withMaximum(Double maximum) {
        NumberColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.numberColumn");
        _x.maximum = maximum;
        return _x;
    }

    @Property(name="minimum")
    @JsonIgnore
    public Optional<Double> getMinimum() {
        return Optional.ofNullable(minimum);
    }

    public NumberColumn withMinimum(Double minimum) {
        NumberColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.numberColumn");
        _x.minimum = minimum;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String decimalPlaces;
        private String displayAs;
        private Double maximum;
        private Double minimum;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder decimalPlaces(String decimalPlaces) {
            this.decimalPlaces = decimalPlaces;
            this.changedFields = changedFields.add("decimalPlaces");
            return this;
        }

        public Builder displayAs(String displayAs) {
            this.displayAs = displayAs;
            this.changedFields = changedFields.add("displayAs");
            return this;
        }

        public Builder maximum(Double maximum) {
            this.maximum = maximum;
            this.changedFields = changedFields.add("maximum");
            return this;
        }

        public Builder minimum(Double minimum) {
            this.minimum = minimum;
            this.changedFields = changedFields.add("minimum");
            return this;
        }

        public NumberColumn build() {
            NumberColumn _x = new NumberColumn();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.numberColumn";
            _x.decimalPlaces = decimalPlaces;
            _x.displayAs = displayAs;
            _x.maximum = maximum;
            _x.minimum = minimum;
            return _x;
        }
    }

    private NumberColumn _copy() {
        NumberColumn _x = new NumberColumn();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.decimalPlaces = decimalPlaces;
        _x.displayAs = displayAs;
        _x.maximum = maximum;
        _x.minimum = minimum;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NumberColumn[");
        b.append("decimalPlaces=");
        b.append(this.decimalPlaces);
        b.append(", ");
        b.append("displayAs=");
        b.append(this.displayAs);
        b.append(", ");
        b.append("maximum=");
        b.append(this.maximum);
        b.append(", ");
        b.append("minimum=");
        b.append(this.minimum);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
