package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DlpAction;
import odata.msgraph.client.beta.enums.OverrideOption;

@JsonPropertyOrder({
    "@odata.type", 
    "recipients", 
    "actionLastModifiedDateTime", 
    "overrideOption", 
    "emailText", 
    "policyTip"})
@JsonInclude(Include.NON_NULL)
public class NotifyUserAction extends DlpActionInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("recipients")
    protected List<String> recipients;

    @JsonProperty("recipients@nextLink")
    protected String recipientsNextLink;

    @JsonProperty("actionLastModifiedDateTime")
    protected OffsetDateTime actionLastModifiedDateTime;

    @JsonProperty("overrideOption")
    protected OverrideOption overrideOption;

    @JsonProperty("emailText")
    protected String emailText;

    @JsonProperty("policyTip")
    protected String policyTip;

    protected NotifyUserAction() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.notifyUserAction";
    }

    @Property(name="recipients")
    @JsonIgnore
    public CollectionPage<String> getRecipients() {
        return new CollectionPage<String>(contextPath, String.class, recipients, Optional.ofNullable(recipientsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="recipients")
    @JsonIgnore
    public CollectionPage<String> getRecipients(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, recipients, Optional.ofNullable(recipientsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="actionLastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getActionLastModifiedDateTime() {
        return Optional.ofNullable(actionLastModifiedDateTime);
    }

    public NotifyUserAction withActionLastModifiedDateTime(OffsetDateTime actionLastModifiedDateTime) {
        NotifyUserAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notifyUserAction");
        _x.actionLastModifiedDateTime = actionLastModifiedDateTime;
        return _x;
    }

    @Property(name="overrideOption")
    @JsonIgnore
    public Optional<OverrideOption> getOverrideOption() {
        return Optional.ofNullable(overrideOption);
    }

    public NotifyUserAction withOverrideOption(OverrideOption overrideOption) {
        NotifyUserAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notifyUserAction");
        _x.overrideOption = overrideOption;
        return _x;
    }

    @Property(name="emailText")
    @JsonIgnore
    public Optional<String> getEmailText() {
        return Optional.ofNullable(emailText);
    }

    public NotifyUserAction withEmailText(String emailText) {
        NotifyUserAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notifyUserAction");
        _x.emailText = emailText;
        return _x;
    }

    @Property(name="policyTip")
    @JsonIgnore
    public Optional<String> getPolicyTip() {
        return Optional.ofNullable(policyTip);
    }

    public NotifyUserAction withPolicyTip(String policyTip) {
        NotifyUserAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.notifyUserAction");
        _x.policyTip = policyTip;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderNotifyUserAction() {
        return new Builder();
    }

    public static final class Builder {
        private DlpAction action;
        private List<String> recipients;
        private String recipientsNextLink;
        private OffsetDateTime actionLastModifiedDateTime;
        private OverrideOption overrideOption;
        private String emailText;
        private String policyTip;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder action(DlpAction action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        public Builder recipients(List<String> recipients) {
            this.recipients = recipients;
            this.changedFields = changedFields.add("recipients");
            return this;
        }

        public Builder recipients(String... recipients) {
            return recipients(Arrays.asList(recipients));
        }

        public Builder recipientsNextLink(String recipientsNextLink) {
            this.recipientsNextLink = recipientsNextLink;
            this.changedFields = changedFields.add("recipients");
            return this;
        }

        public Builder actionLastModifiedDateTime(OffsetDateTime actionLastModifiedDateTime) {
            this.actionLastModifiedDateTime = actionLastModifiedDateTime;
            this.changedFields = changedFields.add("actionLastModifiedDateTime");
            return this;
        }

        public Builder overrideOption(OverrideOption overrideOption) {
            this.overrideOption = overrideOption;
            this.changedFields = changedFields.add("overrideOption");
            return this;
        }

        public Builder emailText(String emailText) {
            this.emailText = emailText;
            this.changedFields = changedFields.add("emailText");
            return this;
        }

        public Builder policyTip(String policyTip) {
            this.policyTip = policyTip;
            this.changedFields = changedFields.add("policyTip");
            return this;
        }

        public NotifyUserAction build() {
            NotifyUserAction _x = new NotifyUserAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.notifyUserAction";
            _x.action = action;
            _x.recipients = recipients;
            _x.recipientsNextLink = recipientsNextLink;
            _x.actionLastModifiedDateTime = actionLastModifiedDateTime;
            _x.overrideOption = overrideOption;
            _x.emailText = emailText;
            _x.policyTip = policyTip;
            return _x;
        }
    }

    private NotifyUserAction _copy() {
        NotifyUserAction _x = new NotifyUserAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.action = action;
        _x.recipients = recipients;
        _x.actionLastModifiedDateTime = actionLastModifiedDateTime;
        _x.overrideOption = overrideOption;
        _x.emailText = emailText;
        _x.policyTip = policyTip;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NotifyUserAction[");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("recipients=");
        b.append(this.recipients);
        b.append(", ");
        b.append("actionLastModifiedDateTime=");
        b.append(this.actionLastModifiedDateTime);
        b.append(", ");
        b.append("overrideOption=");
        b.append(this.overrideOption);
        b.append(", ");
        b.append("emailText=");
        b.append(this.emailText);
        b.append(", ");
        b.append("policyTip=");
        b.append(this.policyTip);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
