package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ConnectionDirection;
import odata.msgraph.client.beta.enums.ConnectionStatus;
import odata.msgraph.client.beta.enums.SecurityNetworkProtocol;

@JsonPropertyOrder({
    "@odata.type", 
    "applicationName", 
    "destinationAddress", 
    "destinationDomain", 
    "destinationLocation", 
    "destinationPort", 
    "destinationUrl", 
    "direction", 
    "domainRegisteredDateTime", 
    "localDnsName", 
    "natDestinationAddress", 
    "natDestinationPort", 
    "natSourceAddress", 
    "natSourcePort", 
    "protocol", 
    "riskScore", 
    "sourceAddress", 
    "sourceLocation", 
    "sourcePort", 
    "status", 
    "urlParameters"})
@JsonInclude(Include.NON_NULL)
public class NetworkConnection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("applicationName")
    protected String applicationName;

    @JsonProperty("destinationAddress")
    protected String destinationAddress;

    @JsonProperty("destinationDomain")
    protected String destinationDomain;

    @JsonProperty("destinationLocation")
    protected String destinationLocation;

    @JsonProperty("destinationPort")
    protected String destinationPort;

    @JsonProperty("destinationUrl")
    protected String destinationUrl;

    @JsonProperty("direction")
    protected ConnectionDirection direction;

    @JsonProperty("domainRegisteredDateTime")
    protected OffsetDateTime domainRegisteredDateTime;

    @JsonProperty("localDnsName")
    protected String localDnsName;

    @JsonProperty("natDestinationAddress")
    protected String natDestinationAddress;

    @JsonProperty("natDestinationPort")
    protected String natDestinationPort;

    @JsonProperty("natSourceAddress")
    protected String natSourceAddress;

    @JsonProperty("natSourcePort")
    protected String natSourcePort;

    @JsonProperty("protocol")
    protected SecurityNetworkProtocol protocol;

    @JsonProperty("riskScore")
    protected String riskScore;

    @JsonProperty("sourceAddress")
    protected String sourceAddress;

    @JsonProperty("sourceLocation")
    protected String sourceLocation;

    @JsonProperty("sourcePort")
    protected String sourcePort;

    @JsonProperty("status")
    protected ConnectionStatus status;

    @JsonProperty("urlParameters")
    protected String urlParameters;

    protected NetworkConnection() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.networkConnection";
    }

    @Property(name="applicationName")
    @JsonIgnore
    public Optional<String> getApplicationName() {
        return Optional.ofNullable(applicationName);
    }

    public NetworkConnection withApplicationName(String applicationName) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.applicationName = applicationName;
        return _x;
    }

    @Property(name="destinationAddress")
    @JsonIgnore
    public Optional<String> getDestinationAddress() {
        return Optional.ofNullable(destinationAddress);
    }

    public NetworkConnection withDestinationAddress(String destinationAddress) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.destinationAddress = destinationAddress;
        return _x;
    }

    @Property(name="destinationDomain")
    @JsonIgnore
    public Optional<String> getDestinationDomain() {
        return Optional.ofNullable(destinationDomain);
    }

    public NetworkConnection withDestinationDomain(String destinationDomain) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.destinationDomain = destinationDomain;
        return _x;
    }

    @Property(name="destinationLocation")
    @JsonIgnore
    public Optional<String> getDestinationLocation() {
        return Optional.ofNullable(destinationLocation);
    }

    public NetworkConnection withDestinationLocation(String destinationLocation) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.destinationLocation = destinationLocation;
        return _x;
    }

    @Property(name="destinationPort")
    @JsonIgnore
    public Optional<String> getDestinationPort() {
        return Optional.ofNullable(destinationPort);
    }

    public NetworkConnection withDestinationPort(String destinationPort) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.destinationPort = destinationPort;
        return _x;
    }

    @Property(name="destinationUrl")
    @JsonIgnore
    public Optional<String> getDestinationUrl() {
        return Optional.ofNullable(destinationUrl);
    }

    public NetworkConnection withDestinationUrl(String destinationUrl) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.destinationUrl = destinationUrl;
        return _x;
    }

    @Property(name="direction")
    @JsonIgnore
    public Optional<ConnectionDirection> getDirection() {
        return Optional.ofNullable(direction);
    }

    public NetworkConnection withDirection(ConnectionDirection direction) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.direction = direction;
        return _x;
    }

    @Property(name="domainRegisteredDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDomainRegisteredDateTime() {
        return Optional.ofNullable(domainRegisteredDateTime);
    }

    public NetworkConnection withDomainRegisteredDateTime(OffsetDateTime domainRegisteredDateTime) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.domainRegisteredDateTime = domainRegisteredDateTime;
        return _x;
    }

    @Property(name="localDnsName")
    @JsonIgnore
    public Optional<String> getLocalDnsName() {
        return Optional.ofNullable(localDnsName);
    }

    public NetworkConnection withLocalDnsName(String localDnsName) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.localDnsName = localDnsName;
        return _x;
    }

    @Property(name="natDestinationAddress")
    @JsonIgnore
    public Optional<String> getNatDestinationAddress() {
        return Optional.ofNullable(natDestinationAddress);
    }

    public NetworkConnection withNatDestinationAddress(String natDestinationAddress) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.natDestinationAddress = natDestinationAddress;
        return _x;
    }

    @Property(name="natDestinationPort")
    @JsonIgnore
    public Optional<String> getNatDestinationPort() {
        return Optional.ofNullable(natDestinationPort);
    }

    public NetworkConnection withNatDestinationPort(String natDestinationPort) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.natDestinationPort = natDestinationPort;
        return _x;
    }

    @Property(name="natSourceAddress")
    @JsonIgnore
    public Optional<String> getNatSourceAddress() {
        return Optional.ofNullable(natSourceAddress);
    }

    public NetworkConnection withNatSourceAddress(String natSourceAddress) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.natSourceAddress = natSourceAddress;
        return _x;
    }

    @Property(name="natSourcePort")
    @JsonIgnore
    public Optional<String> getNatSourcePort() {
        return Optional.ofNullable(natSourcePort);
    }

    public NetworkConnection withNatSourcePort(String natSourcePort) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.natSourcePort = natSourcePort;
        return _x;
    }

    @Property(name="protocol")
    @JsonIgnore
    public Optional<SecurityNetworkProtocol> getProtocol() {
        return Optional.ofNullable(protocol);
    }

    public NetworkConnection withProtocol(SecurityNetworkProtocol protocol) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.protocol = protocol;
        return _x;
    }

    @Property(name="riskScore")
    @JsonIgnore
    public Optional<String> getRiskScore() {
        return Optional.ofNullable(riskScore);
    }

    public NetworkConnection withRiskScore(String riskScore) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.riskScore = riskScore;
        return _x;
    }

    @Property(name="sourceAddress")
    @JsonIgnore
    public Optional<String> getSourceAddress() {
        return Optional.ofNullable(sourceAddress);
    }

    public NetworkConnection withSourceAddress(String sourceAddress) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.sourceAddress = sourceAddress;
        return _x;
    }

    @Property(name="sourceLocation")
    @JsonIgnore
    public Optional<String> getSourceLocation() {
        return Optional.ofNullable(sourceLocation);
    }

    public NetworkConnection withSourceLocation(String sourceLocation) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.sourceLocation = sourceLocation;
        return _x;
    }

    @Property(name="sourcePort")
    @JsonIgnore
    public Optional<String> getSourcePort() {
        return Optional.ofNullable(sourcePort);
    }

    public NetworkConnection withSourcePort(String sourcePort) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.sourcePort = sourcePort;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<ConnectionStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public NetworkConnection withStatus(ConnectionStatus status) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.status = status;
        return _x;
    }

    @Property(name="urlParameters")
    @JsonIgnore
    public Optional<String> getUrlParameters() {
        return Optional.ofNullable(urlParameters);
    }

    public NetworkConnection withUrlParameters(String urlParameters) {
        NetworkConnection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkConnection");
        _x.urlParameters = urlParameters;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String applicationName;
        private String destinationAddress;
        private String destinationDomain;
        private String destinationLocation;
        private String destinationPort;
        private String destinationUrl;
        private ConnectionDirection direction;
        private OffsetDateTime domainRegisteredDateTime;
        private String localDnsName;
        private String natDestinationAddress;
        private String natDestinationPort;
        private String natSourceAddress;
        private String natSourcePort;
        private SecurityNetworkProtocol protocol;
        private String riskScore;
        private String sourceAddress;
        private String sourceLocation;
        private String sourcePort;
        private ConnectionStatus status;
        private String urlParameters;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            this.changedFields = changedFields.add("applicationName");
            return this;
        }

        public Builder destinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
            this.changedFields = changedFields.add("destinationAddress");
            return this;
        }

        public Builder destinationDomain(String destinationDomain) {
            this.destinationDomain = destinationDomain;
            this.changedFields = changedFields.add("destinationDomain");
            return this;
        }

        public Builder destinationLocation(String destinationLocation) {
            this.destinationLocation = destinationLocation;
            this.changedFields = changedFields.add("destinationLocation");
            return this;
        }

        public Builder destinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
            this.changedFields = changedFields.add("destinationPort");
            return this;
        }

        public Builder destinationUrl(String destinationUrl) {
            this.destinationUrl = destinationUrl;
            this.changedFields = changedFields.add("destinationUrl");
            return this;
        }

        public Builder direction(ConnectionDirection direction) {
            this.direction = direction;
            this.changedFields = changedFields.add("direction");
            return this;
        }

        public Builder domainRegisteredDateTime(OffsetDateTime domainRegisteredDateTime) {
            this.domainRegisteredDateTime = domainRegisteredDateTime;
            this.changedFields = changedFields.add("domainRegisteredDateTime");
            return this;
        }

        public Builder localDnsName(String localDnsName) {
            this.localDnsName = localDnsName;
            this.changedFields = changedFields.add("localDnsName");
            return this;
        }

        public Builder natDestinationAddress(String natDestinationAddress) {
            this.natDestinationAddress = natDestinationAddress;
            this.changedFields = changedFields.add("natDestinationAddress");
            return this;
        }

        public Builder natDestinationPort(String natDestinationPort) {
            this.natDestinationPort = natDestinationPort;
            this.changedFields = changedFields.add("natDestinationPort");
            return this;
        }

        public Builder natSourceAddress(String natSourceAddress) {
            this.natSourceAddress = natSourceAddress;
            this.changedFields = changedFields.add("natSourceAddress");
            return this;
        }

        public Builder natSourcePort(String natSourcePort) {
            this.natSourcePort = natSourcePort;
            this.changedFields = changedFields.add("natSourcePort");
            return this;
        }

        public Builder protocol(SecurityNetworkProtocol protocol) {
            this.protocol = protocol;
            this.changedFields = changedFields.add("protocol");
            return this;
        }

        public Builder riskScore(String riskScore) {
            this.riskScore = riskScore;
            this.changedFields = changedFields.add("riskScore");
            return this;
        }

        public Builder sourceAddress(String sourceAddress) {
            this.sourceAddress = sourceAddress;
            this.changedFields = changedFields.add("sourceAddress");
            return this;
        }

        public Builder sourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
            this.changedFields = changedFields.add("sourceLocation");
            return this;
        }

        public Builder sourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
            this.changedFields = changedFields.add("sourcePort");
            return this;
        }

        public Builder status(ConnectionStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder urlParameters(String urlParameters) {
            this.urlParameters = urlParameters;
            this.changedFields = changedFields.add("urlParameters");
            return this;
        }

        public NetworkConnection build() {
            NetworkConnection _x = new NetworkConnection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.networkConnection";
            _x.applicationName = applicationName;
            _x.destinationAddress = destinationAddress;
            _x.destinationDomain = destinationDomain;
            _x.destinationLocation = destinationLocation;
            _x.destinationPort = destinationPort;
            _x.destinationUrl = destinationUrl;
            _x.direction = direction;
            _x.domainRegisteredDateTime = domainRegisteredDateTime;
            _x.localDnsName = localDnsName;
            _x.natDestinationAddress = natDestinationAddress;
            _x.natDestinationPort = natDestinationPort;
            _x.natSourceAddress = natSourceAddress;
            _x.natSourcePort = natSourcePort;
            _x.protocol = protocol;
            _x.riskScore = riskScore;
            _x.sourceAddress = sourceAddress;
            _x.sourceLocation = sourceLocation;
            _x.sourcePort = sourcePort;
            _x.status = status;
            _x.urlParameters = urlParameters;
            return _x;
        }
    }

    private NetworkConnection _copy() {
        NetworkConnection _x = new NetworkConnection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.applicationName = applicationName;
        _x.destinationAddress = destinationAddress;
        _x.destinationDomain = destinationDomain;
        _x.destinationLocation = destinationLocation;
        _x.destinationPort = destinationPort;
        _x.destinationUrl = destinationUrl;
        _x.direction = direction;
        _x.domainRegisteredDateTime = domainRegisteredDateTime;
        _x.localDnsName = localDnsName;
        _x.natDestinationAddress = natDestinationAddress;
        _x.natDestinationPort = natDestinationPort;
        _x.natSourceAddress = natSourceAddress;
        _x.natSourcePort = natSourcePort;
        _x.protocol = protocol;
        _x.riskScore = riskScore;
        _x.sourceAddress = sourceAddress;
        _x.sourceLocation = sourceLocation;
        _x.sourcePort = sourcePort;
        _x.status = status;
        _x.urlParameters = urlParameters;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NetworkConnection[");
        b.append("applicationName=");
        b.append(this.applicationName);
        b.append(", ");
        b.append("destinationAddress=");
        b.append(this.destinationAddress);
        b.append(", ");
        b.append("destinationDomain=");
        b.append(this.destinationDomain);
        b.append(", ");
        b.append("destinationLocation=");
        b.append(this.destinationLocation);
        b.append(", ");
        b.append("destinationPort=");
        b.append(this.destinationPort);
        b.append(", ");
        b.append("destinationUrl=");
        b.append(this.destinationUrl);
        b.append(", ");
        b.append("direction=");
        b.append(this.direction);
        b.append(", ");
        b.append("domainRegisteredDateTime=");
        b.append(this.domainRegisteredDateTime);
        b.append(", ");
        b.append("localDnsName=");
        b.append(this.localDnsName);
        b.append(", ");
        b.append("natDestinationAddress=");
        b.append(this.natDestinationAddress);
        b.append(", ");
        b.append("natDestinationPort=");
        b.append(this.natDestinationPort);
        b.append(", ");
        b.append("natSourceAddress=");
        b.append(this.natSourceAddress);
        b.append(", ");
        b.append("natSourcePort=");
        b.append(this.natSourcePort);
        b.append(", ");
        b.append("protocol=");
        b.append(this.protocol);
        b.append(", ");
        b.append("riskScore=");
        b.append(this.riskScore);
        b.append(", ");
        b.append("sourceAddress=");
        b.append(this.sourceAddress);
        b.append(", ");
        b.append("sourceLocation=");
        b.append(this.sourceLocation);
        b.append(", ");
        b.append("sourcePort=");
        b.append(this.sourcePort);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("urlParameters=");
        b.append(this.urlParameters);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
