package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "oldValue", 
    "newValue"})
@JsonInclude(Include.NON_NULL)
public class ModifiedProperty implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("oldValue")
    protected String oldValue;

    @JsonProperty("newValue")
    protected String newValue;

    protected ModifiedProperty() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.modifiedProperty";
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ModifiedProperty withDisplayName(String displayName) {
        ModifiedProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.modifiedProperty");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="oldValue")
    @JsonIgnore
    public Optional<String> getOldValue() {
        return Optional.ofNullable(oldValue);
    }

    public ModifiedProperty withOldValue(String oldValue) {
        ModifiedProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.modifiedProperty");
        _x.oldValue = oldValue;
        return _x;
    }

    @Property(name="newValue")
    @JsonIgnore
    public Optional<String> getNewValue() {
        return Optional.ofNullable(newValue);
    }

    public ModifiedProperty withNewValue(String newValue) {
        ModifiedProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.modifiedProperty");
        _x.newValue = newValue;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String oldValue;
        private String newValue;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder oldValue(String oldValue) {
            this.oldValue = oldValue;
            this.changedFields = changedFields.add("oldValue");
            return this;
        }

        public Builder newValue(String newValue) {
            this.newValue = newValue;
            this.changedFields = changedFields.add("newValue");
            return this;
        }

        public ModifiedProperty build() {
            ModifiedProperty _x = new ModifiedProperty();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.modifiedProperty";
            _x.displayName = displayName;
            _x.oldValue = oldValue;
            _x.newValue = newValue;
            return _x;
        }
    }

    private ModifiedProperty _copy() {
        ModifiedProperty _x = new ModifiedProperty();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.oldValue = oldValue;
        _x.newValue = newValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ModifiedProperty[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("oldValue=");
        b.append(this.oldValue);
        b.append(", ");
        b.append("newValue=");
        b.append(this.newValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
