package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“History Item contained in the Mobile App Troubleshooting Event.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "occurrenceDateTime", 
    "troubleshootingErrorDetails"})
@JsonInclude(Include.NON_NULL)
public class MobileAppTroubleshootingHistoryItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("occurrenceDateTime")
    protected OffsetDateTime occurrenceDateTime;

    @JsonProperty("troubleshootingErrorDetails")
    protected DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails;

    protected MobileAppTroubleshootingHistoryItem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppTroubleshootingHistoryItem";
    }

    /**
     * <i>“Time when the history item occurred.”</i>
     * 
     * @return property occurrenceDateTime
     */
    @Property(name="occurrenceDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOccurrenceDateTime() {
        return Optional.ofNullable(occurrenceDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * occurrenceDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Time when the history item occurred.”</i>
     * 
     * @param occurrenceDateTime
     *            new value of {@code occurrenceDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code occurrenceDateTime} field changed
     */
    public MobileAppTroubleshootingHistoryItem withOccurrenceDateTime(OffsetDateTime occurrenceDateTime) {
        MobileAppTroubleshootingHistoryItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppTroubleshootingHistoryItem");
        _x.occurrenceDateTime = occurrenceDateTime;
        return _x;
    }

    /**
     * <i>“Object containing detailed information about the error and its remediation.”</i>
     * 
     * @return property troubleshootingErrorDetails
     */
    @Property(name="troubleshootingErrorDetails")
    @JsonIgnore
    public Optional<DeviceManagementTroubleshootingErrorDetails> getTroubleshootingErrorDetails() {
        return Optional.ofNullable(troubleshootingErrorDetails);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * troubleshootingErrorDetails} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Object containing detailed information about the error and its remediation.”</i>
     * 
     * @param troubleshootingErrorDetails
     *            new value of {@code troubleshootingErrorDetails} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code troubleshootingErrorDetails} field changed
     */
    public MobileAppTroubleshootingHistoryItem withTroubleshootingErrorDetails(DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails) {
        MobileAppTroubleshootingHistoryItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppTroubleshootingHistoryItem");
        _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime occurrenceDateTime;
        private DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Time when the history item occurred.”</i>
         * 
         * @param occurrenceDateTime
         *            value of {@code occurrenceDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder occurrenceDateTime(OffsetDateTime occurrenceDateTime) {
            this.occurrenceDateTime = occurrenceDateTime;
            this.changedFields = changedFields.add("occurrenceDateTime");
            return this;
        }

        /**
         * <i>“Object containing detailed information about the error and its remediation.”</i>
         * 
         * @param troubleshootingErrorDetails
         *            value of {@code troubleshootingErrorDetails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder troubleshootingErrorDetails(DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails) {
            this.troubleshootingErrorDetails = troubleshootingErrorDetails;
            this.changedFields = changedFields.add("troubleshootingErrorDetails");
            return this;
        }

        public MobileAppTroubleshootingHistoryItem build() {
            MobileAppTroubleshootingHistoryItem _x = new MobileAppTroubleshootingHistoryItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mobileAppTroubleshootingHistoryItem";
            _x.occurrenceDateTime = occurrenceDateTime;
            _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
            return _x;
        }
    }

    private MobileAppTroubleshootingHistoryItem _copy() {
        MobileAppTroubleshootingHistoryItem _x = new MobileAppTroubleshootingHistoryItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.occurrenceDateTime = occurrenceDateTime;
        _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppTroubleshootingHistoryItem[");
        b.append("occurrenceDateTime=");
        b.append(this.occurrenceDateTime);
        b.append(", ");
        b.append("troubleshootingErrorDetails=");
        b.append(this.troubleshootingErrorDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
