package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;


/**
 * <i>“History Item contained in the Mobile App Troubleshooting Event.”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class MobileAppTroubleshootingAppUpdateHistory extends MobileAppTroubleshootingHistoryItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    protected MobileAppTroubleshootingAppUpdateHistory() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppTroubleshootingAppUpdateHistory";
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileAppTroubleshootingAppUpdateHistory() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime occurrenceDateTime;
        private DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder occurrenceDateTime(OffsetDateTime occurrenceDateTime) {
            this.occurrenceDateTime = occurrenceDateTime;
            this.changedFields = changedFields.add("occurrenceDateTime");
            return this;
        }

        public Builder troubleshootingErrorDetails(DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails) {
            this.troubleshootingErrorDetails = troubleshootingErrorDetails;
            this.changedFields = changedFields.add("troubleshootingErrorDetails");
            return this;
        }

        public MobileAppTroubleshootingAppUpdateHistory build() {
            MobileAppTroubleshootingAppUpdateHistory _x = new MobileAppTroubleshootingAppUpdateHistory();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mobileAppTroubleshootingAppUpdateHistory";
            _x.occurrenceDateTime = occurrenceDateTime;
            _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppTroubleshootingAppUpdateHistory[");
        b.append("occurrenceDateTime=");
        b.append(this.occurrenceDateTime);
        b.append(", ");
        b.append("troubleshootingErrorDetails=");
        b.append(this.troubleshootingErrorDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
