package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Contains properties used to determine when to offer an app to devices and when
 * to install the app on devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "useLocalTime", 
    "startDateTime", 
    "deadlineDateTime"})
@JsonInclude(Include.NON_NULL)
public class MobileAppInstallTimeSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("useLocalTime")
    protected Boolean useLocalTime;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("deadlineDateTime")
    protected OffsetDateTime deadlineDateTime;

    protected MobileAppInstallTimeSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppInstallTimeSettings";
    }

    /**
     * <i>“Whether the local device time or UTC time should be used when determining the
     * available and deadline times.”</i>
     * 
     * @return property useLocalTime
     */
    @Property(name="useLocalTime")
    @JsonIgnore
    public Optional<Boolean> getUseLocalTime() {
        return Optional.ofNullable(useLocalTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code useLocalTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether the local device time or UTC time should be used when determining the
     * available and deadline times.”</i>
     * 
     * @param useLocalTime
     *            new value of {@code useLocalTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code useLocalTime} field changed
     */
    public MobileAppInstallTimeSettings withUseLocalTime(Boolean useLocalTime) {
        MobileAppInstallTimeSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallTimeSettings");
        _x.useLocalTime = useLocalTime;
        return _x;
    }

    /**
     * <i>“The time at which the app should be available for installation.”</i>
     * 
     * @return property startDateTime
     */
    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time at which the app should be available for installation.”</i>
     * 
     * @param startDateTime
     *            new value of {@code startDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startDateTime} field changed
     */
    public MobileAppInstallTimeSettings withStartDateTime(OffsetDateTime startDateTime) {
        MobileAppInstallTimeSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallTimeSettings");
        _x.startDateTime = startDateTime;
        return _x;
    }

    /**
     * <i>“The time at which the app should be installed.”</i>
     * 
     * @return property deadlineDateTime
     */
    @Property(name="deadlineDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDeadlineDateTime() {
        return Optional.ofNullable(deadlineDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deadlineDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time at which the app should be installed.”</i>
     * 
     * @param deadlineDateTime
     *            new value of {@code deadlineDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deadlineDateTime} field changed
     */
    public MobileAppInstallTimeSettings withDeadlineDateTime(OffsetDateTime deadlineDateTime) {
        MobileAppInstallTimeSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallTimeSettings");
        _x.deadlineDateTime = deadlineDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean useLocalTime;
        private OffsetDateTime startDateTime;
        private OffsetDateTime deadlineDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Whether the local device time or UTC time should be used when determining the
         * available and deadline times.”</i>
         * 
         * @param useLocalTime
         *            value of {@code useLocalTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder useLocalTime(Boolean useLocalTime) {
            this.useLocalTime = useLocalTime;
            this.changedFields = changedFields.add("useLocalTime");
            return this;
        }

        /**
         * <i>“The time at which the app should be available for installation.”</i>
         * 
         * @param startDateTime
         *            value of {@code startDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        /**
         * <i>“The time at which the app should be installed.”</i>
         * 
         * @param deadlineDateTime
         *            value of {@code deadlineDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deadlineDateTime(OffsetDateTime deadlineDateTime) {
            this.deadlineDateTime = deadlineDateTime;
            this.changedFields = changedFields.add("deadlineDateTime");
            return this;
        }

        public MobileAppInstallTimeSettings build() {
            MobileAppInstallTimeSettings _x = new MobileAppInstallTimeSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mobileAppInstallTimeSettings";
            _x.useLocalTime = useLocalTime;
            _x.startDateTime = startDateTime;
            _x.deadlineDateTime = deadlineDateTime;
            return _x;
        }
    }

    private MobileAppInstallTimeSettings _copy() {
        MobileAppInstallTimeSettings _x = new MobileAppInstallTimeSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.useLocalTime = useLocalTime;
        _x.startDateTime = startDateTime;
        _x.deadlineDateTime = deadlineDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppInstallTimeSettings[");
        b.append("useLocalTime=");
        b.append(this.useLocalTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("deadlineDateTime=");
        b.append(this.deadlineDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
