package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "authMethod", 
    "authDetail"})
@JsonInclude(Include.NON_NULL)
public class MfaDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("authMethod")
    protected String authMethod;

    @JsonProperty("authDetail")
    protected String authDetail;

    protected MfaDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mfaDetail";
    }

    @Property(name="authMethod")
    @JsonIgnore
    public Optional<String> getAuthMethod() {
        return Optional.ofNullable(authMethod);
    }

    public MfaDetail withAuthMethod(String authMethod) {
        MfaDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mfaDetail");
        _x.authMethod = authMethod;
        return _x;
    }

    @Property(name="authDetail")
    @JsonIgnore
    public Optional<String> getAuthDetail() {
        return Optional.ofNullable(authDetail);
    }

    public MfaDetail withAuthDetail(String authDetail) {
        MfaDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mfaDetail");
        _x.authDetail = authDetail;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String authMethod;
        private String authDetail;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder authMethod(String authMethod) {
            this.authMethod = authMethod;
            this.changedFields = changedFields.add("authMethod");
            return this;
        }

        public Builder authDetail(String authDetail) {
            this.authDetail = authDetail;
            this.changedFields = changedFields.add("authDetail");
            return this;
        }

        public MfaDetail build() {
            MfaDetail _x = new MfaDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mfaDetail";
            _x.authMethod = authMethod;
            _x.authDetail = authDetail;
            return _x;
        }
    }

    private MfaDetail _copy() {
        MfaDetail _x = new MfaDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.authMethod = authMethod;
        _x.authDetail = authDetail;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MfaDetail[");
        b.append("authMethod=");
        b.append(this.authMethod);
        b.append(", ");
        b.append("authDetail=");
        b.append(this.authDetail);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
