package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "metadataToRemove", 
    "metadataToAdd"})
@JsonInclude(Include.NON_NULL)
public class MetadataAction extends InformationProtectionAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("metadataToRemove")
    protected List<String> metadataToRemove;

    @JsonProperty("metadataToRemove@nextLink")
    protected String metadataToRemoveNextLink;

    @JsonProperty("metadataToAdd")
    protected List<KeyValuePair> metadataToAdd;

    @JsonProperty("metadataToAdd@nextLink")
    protected String metadataToAddNextLink;

    protected MetadataAction() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.metadataAction";
    }

    @Property(name="metadataToRemove")
    @JsonIgnore
    public CollectionPage<String> getMetadataToRemove() {
        return new CollectionPage<String>(contextPath, String.class, metadataToRemove, Optional.ofNullable(metadataToRemoveNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="metadataToRemove")
    @JsonIgnore
    public CollectionPage<String> getMetadataToRemove(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, metadataToRemove, Optional.ofNullable(metadataToRemoveNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="metadataToAdd")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getMetadataToAdd() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, metadataToAdd, Optional.ofNullable(metadataToAddNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="metadataToAdd")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getMetadataToAdd(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, metadataToAdd, Optional.ofNullable(metadataToAddNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMetadataAction() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> metadataToRemove;
        private String metadataToRemoveNextLink;
        private List<KeyValuePair> metadataToAdd;
        private String metadataToAddNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder metadataToRemove(List<String> metadataToRemove) {
            this.metadataToRemove = metadataToRemove;
            this.changedFields = changedFields.add("metadataToRemove");
            return this;
        }

        public Builder metadataToRemove(String... metadataToRemove) {
            return metadataToRemove(Arrays.asList(metadataToRemove));
        }

        public Builder metadataToRemoveNextLink(String metadataToRemoveNextLink) {
            this.metadataToRemoveNextLink = metadataToRemoveNextLink;
            this.changedFields = changedFields.add("metadataToRemove");
            return this;
        }

        public Builder metadataToAdd(List<KeyValuePair> metadataToAdd) {
            this.metadataToAdd = metadataToAdd;
            this.changedFields = changedFields.add("metadataToAdd");
            return this;
        }

        public Builder metadataToAdd(KeyValuePair... metadataToAdd) {
            return metadataToAdd(Arrays.asList(metadataToAdd));
        }

        public Builder metadataToAddNextLink(String metadataToAddNextLink) {
            this.metadataToAddNextLink = metadataToAddNextLink;
            this.changedFields = changedFields.add("metadataToAdd");
            return this;
        }

        public MetadataAction build() {
            MetadataAction _x = new MetadataAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.metadataAction";
            _x.metadataToRemove = metadataToRemove;
            _x.metadataToRemoveNextLink = metadataToRemoveNextLink;
            _x.metadataToAdd = metadataToAdd;
            _x.metadataToAddNextLink = metadataToAddNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MetadataAction[");
        b.append("metadataToRemove=");
        b.append(this.metadataToRemove);
        b.append(", ");
        b.append("metadataToAdd=");
        b.append(this.metadataToAdd);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
