package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.Importance;
import odata.msgraph.client.beta.enums.MessageActionFlag;
import odata.msgraph.client.beta.enums.Sensitivity;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "categories", 
    "subjectContains", 
    "bodyContains", 
    "bodyOrSubjectContains", 
    "senderContains", 
    "recipientContains", 
    "headerContains", 
    "messageActionFlag", 
    "importance", 
    "sensitivity", 
    "fromAddresses", 
    "sentToAddresses", 
    "sentToMe", 
    "sentOnlyToMe", 
    "sentCcMe", 
    "sentToOrCcMe", 
    "notSentToMe", 
    "hasAttachments", 
    "isApprovalRequest", 
    "isAutomaticForward", 
    "isAutomaticReply", 
    "isEncrypted", 
    "isMeetingRequest", 
    "isMeetingResponse", 
    "isNonDeliveryReport", 
    "isPermissionControlled", 
    "isReadReceipt", 
    "isSigned", 
    "isVoicemail", 
    "withinSizeRange"})
@JsonInclude(Include.NON_NULL)
public class MessageRulePredicates implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("categories")
    protected List<String> categories;

    @JsonProperty("categories@nextLink")
    protected String categoriesNextLink;

    @JsonProperty("subjectContains")
    protected List<String> subjectContains;

    @JsonProperty("subjectContains@nextLink")
    protected String subjectContainsNextLink;

    @JsonProperty("bodyContains")
    protected List<String> bodyContains;

    @JsonProperty("bodyContains@nextLink")
    protected String bodyContainsNextLink;

    @JsonProperty("bodyOrSubjectContains")
    protected List<String> bodyOrSubjectContains;

    @JsonProperty("bodyOrSubjectContains@nextLink")
    protected String bodyOrSubjectContainsNextLink;

    @JsonProperty("senderContains")
    protected List<String> senderContains;

    @JsonProperty("senderContains@nextLink")
    protected String senderContainsNextLink;

    @JsonProperty("recipientContains")
    protected List<String> recipientContains;

    @JsonProperty("recipientContains@nextLink")
    protected String recipientContainsNextLink;

    @JsonProperty("headerContains")
    protected List<String> headerContains;

    @JsonProperty("headerContains@nextLink")
    protected String headerContainsNextLink;

    @JsonProperty("messageActionFlag")
    protected MessageActionFlag messageActionFlag;

    @JsonProperty("importance")
    protected Importance importance;

    @JsonProperty("sensitivity")
    protected Sensitivity sensitivity;

    @JsonProperty("fromAddresses")
    protected List<Recipient> fromAddresses;

    @JsonProperty("fromAddresses@nextLink")
    protected String fromAddressesNextLink;

    @JsonProperty("sentToAddresses")
    protected List<Recipient> sentToAddresses;

    @JsonProperty("sentToAddresses@nextLink")
    protected String sentToAddressesNextLink;

    @JsonProperty("sentToMe")
    protected Boolean sentToMe;

    @JsonProperty("sentOnlyToMe")
    protected Boolean sentOnlyToMe;

    @JsonProperty("sentCcMe")
    protected Boolean sentCcMe;

    @JsonProperty("sentToOrCcMe")
    protected Boolean sentToOrCcMe;

    @JsonProperty("notSentToMe")
    protected Boolean notSentToMe;

    @JsonProperty("hasAttachments")
    protected Boolean hasAttachments;

    @JsonProperty("isApprovalRequest")
    protected Boolean isApprovalRequest;

    @JsonProperty("isAutomaticForward")
    protected Boolean isAutomaticForward;

    @JsonProperty("isAutomaticReply")
    protected Boolean isAutomaticReply;

    @JsonProperty("isEncrypted")
    protected Boolean isEncrypted;

    @JsonProperty("isMeetingRequest")
    protected Boolean isMeetingRequest;

    @JsonProperty("isMeetingResponse")
    protected Boolean isMeetingResponse;

    @JsonProperty("isNonDeliveryReport")
    protected Boolean isNonDeliveryReport;

    @JsonProperty("isPermissionControlled")
    protected Boolean isPermissionControlled;

    @JsonProperty("isReadReceipt")
    protected Boolean isReadReceipt;

    @JsonProperty("isSigned")
    protected Boolean isSigned;

    @JsonProperty("isVoicemail")
    protected Boolean isVoicemail;

    @JsonProperty("withinSizeRange")
    protected SizeRange withinSizeRange;

    protected MessageRulePredicates() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.messageRulePredicates";
    }

    @Property(name="categories")
    @JsonIgnore
    public CollectionPage<String> getCategories() {
        return new CollectionPage<String>(contextPath, String.class, categories, Optional.ofNullable(categoriesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="categories")
    @JsonIgnore
    public CollectionPage<String> getCategories(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, categories, Optional.ofNullable(categoriesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="subjectContains")
    @JsonIgnore
    public CollectionPage<String> getSubjectContains() {
        return new CollectionPage<String>(contextPath, String.class, subjectContains, Optional.ofNullable(subjectContainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="subjectContains")
    @JsonIgnore
    public CollectionPage<String> getSubjectContains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, subjectContains, Optional.ofNullable(subjectContainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="bodyContains")
    @JsonIgnore
    public CollectionPage<String> getBodyContains() {
        return new CollectionPage<String>(contextPath, String.class, bodyContains, Optional.ofNullable(bodyContainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="bodyContains")
    @JsonIgnore
    public CollectionPage<String> getBodyContains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, bodyContains, Optional.ofNullable(bodyContainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="bodyOrSubjectContains")
    @JsonIgnore
    public CollectionPage<String> getBodyOrSubjectContains() {
        return new CollectionPage<String>(contextPath, String.class, bodyOrSubjectContains, Optional.ofNullable(bodyOrSubjectContainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="bodyOrSubjectContains")
    @JsonIgnore
    public CollectionPage<String> getBodyOrSubjectContains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, bodyOrSubjectContains, Optional.ofNullable(bodyOrSubjectContainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="senderContains")
    @JsonIgnore
    public CollectionPage<String> getSenderContains() {
        return new CollectionPage<String>(contextPath, String.class, senderContains, Optional.ofNullable(senderContainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="senderContains")
    @JsonIgnore
    public CollectionPage<String> getSenderContains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, senderContains, Optional.ofNullable(senderContainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="recipientContains")
    @JsonIgnore
    public CollectionPage<String> getRecipientContains() {
        return new CollectionPage<String>(contextPath, String.class, recipientContains, Optional.ofNullable(recipientContainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="recipientContains")
    @JsonIgnore
    public CollectionPage<String> getRecipientContains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, recipientContains, Optional.ofNullable(recipientContainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="headerContains")
    @JsonIgnore
    public CollectionPage<String> getHeaderContains() {
        return new CollectionPage<String>(contextPath, String.class, headerContains, Optional.ofNullable(headerContainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="headerContains")
    @JsonIgnore
    public CollectionPage<String> getHeaderContains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, headerContains, Optional.ofNullable(headerContainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="messageActionFlag")
    @JsonIgnore
    public Optional<MessageActionFlag> getMessageActionFlag() {
        return Optional.ofNullable(messageActionFlag);
    }

    public MessageRulePredicates withMessageActionFlag(MessageActionFlag messageActionFlag) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.messageActionFlag = messageActionFlag;
        return _x;
    }

    @Property(name="importance")
    @JsonIgnore
    public Optional<Importance> getImportance() {
        return Optional.ofNullable(importance);
    }

    public MessageRulePredicates withImportance(Importance importance) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.importance = importance;
        return _x;
    }

    @Property(name="sensitivity")
    @JsonIgnore
    public Optional<Sensitivity> getSensitivity() {
        return Optional.ofNullable(sensitivity);
    }

    public MessageRulePredicates withSensitivity(Sensitivity sensitivity) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.sensitivity = sensitivity;
        return _x;
    }

    @Property(name="fromAddresses")
    @JsonIgnore
    public CollectionPage<Recipient> getFromAddresses() {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, fromAddresses, Optional.ofNullable(fromAddressesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="fromAddresses")
    @JsonIgnore
    public CollectionPage<Recipient> getFromAddresses(HttpRequestOptions options) {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, fromAddresses, Optional.ofNullable(fromAddressesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="sentToAddresses")
    @JsonIgnore
    public CollectionPage<Recipient> getSentToAddresses() {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, sentToAddresses, Optional.ofNullable(sentToAddressesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="sentToAddresses")
    @JsonIgnore
    public CollectionPage<Recipient> getSentToAddresses(HttpRequestOptions options) {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, sentToAddresses, Optional.ofNullable(sentToAddressesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="sentToMe")
    @JsonIgnore
    public Optional<Boolean> getSentToMe() {
        return Optional.ofNullable(sentToMe);
    }

    public MessageRulePredicates withSentToMe(Boolean sentToMe) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.sentToMe = sentToMe;
        return _x;
    }

    @Property(name="sentOnlyToMe")
    @JsonIgnore
    public Optional<Boolean> getSentOnlyToMe() {
        return Optional.ofNullable(sentOnlyToMe);
    }

    public MessageRulePredicates withSentOnlyToMe(Boolean sentOnlyToMe) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.sentOnlyToMe = sentOnlyToMe;
        return _x;
    }

    @Property(name="sentCcMe")
    @JsonIgnore
    public Optional<Boolean> getSentCcMe() {
        return Optional.ofNullable(sentCcMe);
    }

    public MessageRulePredicates withSentCcMe(Boolean sentCcMe) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.sentCcMe = sentCcMe;
        return _x;
    }

    @Property(name="sentToOrCcMe")
    @JsonIgnore
    public Optional<Boolean> getSentToOrCcMe() {
        return Optional.ofNullable(sentToOrCcMe);
    }

    public MessageRulePredicates withSentToOrCcMe(Boolean sentToOrCcMe) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.sentToOrCcMe = sentToOrCcMe;
        return _x;
    }

    @Property(name="notSentToMe")
    @JsonIgnore
    public Optional<Boolean> getNotSentToMe() {
        return Optional.ofNullable(notSentToMe);
    }

    public MessageRulePredicates withNotSentToMe(Boolean notSentToMe) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.notSentToMe = notSentToMe;
        return _x;
    }

    @Property(name="hasAttachments")
    @JsonIgnore
    public Optional<Boolean> getHasAttachments() {
        return Optional.ofNullable(hasAttachments);
    }

    public MessageRulePredicates withHasAttachments(Boolean hasAttachments) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.hasAttachments = hasAttachments;
        return _x;
    }

    @Property(name="isApprovalRequest")
    @JsonIgnore
    public Optional<Boolean> getIsApprovalRequest() {
        return Optional.ofNullable(isApprovalRequest);
    }

    public MessageRulePredicates withIsApprovalRequest(Boolean isApprovalRequest) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.isApprovalRequest = isApprovalRequest;
        return _x;
    }

    @Property(name="isAutomaticForward")
    @JsonIgnore
    public Optional<Boolean> getIsAutomaticForward() {
        return Optional.ofNullable(isAutomaticForward);
    }

    public MessageRulePredicates withIsAutomaticForward(Boolean isAutomaticForward) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.isAutomaticForward = isAutomaticForward;
        return _x;
    }

    @Property(name="isAutomaticReply")
    @JsonIgnore
    public Optional<Boolean> getIsAutomaticReply() {
        return Optional.ofNullable(isAutomaticReply);
    }

    public MessageRulePredicates withIsAutomaticReply(Boolean isAutomaticReply) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.isAutomaticReply = isAutomaticReply;
        return _x;
    }

    @Property(name="isEncrypted")
    @JsonIgnore
    public Optional<Boolean> getIsEncrypted() {
        return Optional.ofNullable(isEncrypted);
    }

    public MessageRulePredicates withIsEncrypted(Boolean isEncrypted) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.isEncrypted = isEncrypted;
        return _x;
    }

    @Property(name="isMeetingRequest")
    @JsonIgnore
    public Optional<Boolean> getIsMeetingRequest() {
        return Optional.ofNullable(isMeetingRequest);
    }

    public MessageRulePredicates withIsMeetingRequest(Boolean isMeetingRequest) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.isMeetingRequest = isMeetingRequest;
        return _x;
    }

    @Property(name="isMeetingResponse")
    @JsonIgnore
    public Optional<Boolean> getIsMeetingResponse() {
        return Optional.ofNullable(isMeetingResponse);
    }

    public MessageRulePredicates withIsMeetingResponse(Boolean isMeetingResponse) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.isMeetingResponse = isMeetingResponse;
        return _x;
    }

    @Property(name="isNonDeliveryReport")
    @JsonIgnore
    public Optional<Boolean> getIsNonDeliveryReport() {
        return Optional.ofNullable(isNonDeliveryReport);
    }

    public MessageRulePredicates withIsNonDeliveryReport(Boolean isNonDeliveryReport) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.isNonDeliveryReport = isNonDeliveryReport;
        return _x;
    }

    @Property(name="isPermissionControlled")
    @JsonIgnore
    public Optional<Boolean> getIsPermissionControlled() {
        return Optional.ofNullable(isPermissionControlled);
    }

    public MessageRulePredicates withIsPermissionControlled(Boolean isPermissionControlled) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.isPermissionControlled = isPermissionControlled;
        return _x;
    }

    @Property(name="isReadReceipt")
    @JsonIgnore
    public Optional<Boolean> getIsReadReceipt() {
        return Optional.ofNullable(isReadReceipt);
    }

    public MessageRulePredicates withIsReadReceipt(Boolean isReadReceipt) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.isReadReceipt = isReadReceipt;
        return _x;
    }

    @Property(name="isSigned")
    @JsonIgnore
    public Optional<Boolean> getIsSigned() {
        return Optional.ofNullable(isSigned);
    }

    public MessageRulePredicates withIsSigned(Boolean isSigned) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.isSigned = isSigned;
        return _x;
    }

    @Property(name="isVoicemail")
    @JsonIgnore
    public Optional<Boolean> getIsVoicemail() {
        return Optional.ofNullable(isVoicemail);
    }

    public MessageRulePredicates withIsVoicemail(Boolean isVoicemail) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.isVoicemail = isVoicemail;
        return _x;
    }

    @Property(name="withinSizeRange")
    @JsonIgnore
    public Optional<SizeRange> getWithinSizeRange() {
        return Optional.ofNullable(withinSizeRange);
    }

    public MessageRulePredicates withWithinSizeRange(SizeRange withinSizeRange) {
        MessageRulePredicates _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRulePredicates");
        _x.withinSizeRange = withinSizeRange;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> categories;
        private String categoriesNextLink;
        private List<String> subjectContains;
        private String subjectContainsNextLink;
        private List<String> bodyContains;
        private String bodyContainsNextLink;
        private List<String> bodyOrSubjectContains;
        private String bodyOrSubjectContainsNextLink;
        private List<String> senderContains;
        private String senderContainsNextLink;
        private List<String> recipientContains;
        private String recipientContainsNextLink;
        private List<String> headerContains;
        private String headerContainsNextLink;
        private MessageActionFlag messageActionFlag;
        private Importance importance;
        private Sensitivity sensitivity;
        private List<Recipient> fromAddresses;
        private String fromAddressesNextLink;
        private List<Recipient> sentToAddresses;
        private String sentToAddressesNextLink;
        private Boolean sentToMe;
        private Boolean sentOnlyToMe;
        private Boolean sentCcMe;
        private Boolean sentToOrCcMe;
        private Boolean notSentToMe;
        private Boolean hasAttachments;
        private Boolean isApprovalRequest;
        private Boolean isAutomaticForward;
        private Boolean isAutomaticReply;
        private Boolean isEncrypted;
        private Boolean isMeetingRequest;
        private Boolean isMeetingResponse;
        private Boolean isNonDeliveryReport;
        private Boolean isPermissionControlled;
        private Boolean isReadReceipt;
        private Boolean isSigned;
        private Boolean isVoicemail;
        private SizeRange withinSizeRange;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder categories(String... categories) {
            return categories(Arrays.asList(categories));
        }

        public Builder categoriesNextLink(String categoriesNextLink) {
            this.categoriesNextLink = categoriesNextLink;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder subjectContains(List<String> subjectContains) {
            this.subjectContains = subjectContains;
            this.changedFields = changedFields.add("subjectContains");
            return this;
        }

        public Builder subjectContains(String... subjectContains) {
            return subjectContains(Arrays.asList(subjectContains));
        }

        public Builder subjectContainsNextLink(String subjectContainsNextLink) {
            this.subjectContainsNextLink = subjectContainsNextLink;
            this.changedFields = changedFields.add("subjectContains");
            return this;
        }

        public Builder bodyContains(List<String> bodyContains) {
            this.bodyContains = bodyContains;
            this.changedFields = changedFields.add("bodyContains");
            return this;
        }

        public Builder bodyContains(String... bodyContains) {
            return bodyContains(Arrays.asList(bodyContains));
        }

        public Builder bodyContainsNextLink(String bodyContainsNextLink) {
            this.bodyContainsNextLink = bodyContainsNextLink;
            this.changedFields = changedFields.add("bodyContains");
            return this;
        }

        public Builder bodyOrSubjectContains(List<String> bodyOrSubjectContains) {
            this.bodyOrSubjectContains = bodyOrSubjectContains;
            this.changedFields = changedFields.add("bodyOrSubjectContains");
            return this;
        }

        public Builder bodyOrSubjectContains(String... bodyOrSubjectContains) {
            return bodyOrSubjectContains(Arrays.asList(bodyOrSubjectContains));
        }

        public Builder bodyOrSubjectContainsNextLink(String bodyOrSubjectContainsNextLink) {
            this.bodyOrSubjectContainsNextLink = bodyOrSubjectContainsNextLink;
            this.changedFields = changedFields.add("bodyOrSubjectContains");
            return this;
        }

        public Builder senderContains(List<String> senderContains) {
            this.senderContains = senderContains;
            this.changedFields = changedFields.add("senderContains");
            return this;
        }

        public Builder senderContains(String... senderContains) {
            return senderContains(Arrays.asList(senderContains));
        }

        public Builder senderContainsNextLink(String senderContainsNextLink) {
            this.senderContainsNextLink = senderContainsNextLink;
            this.changedFields = changedFields.add("senderContains");
            return this;
        }

        public Builder recipientContains(List<String> recipientContains) {
            this.recipientContains = recipientContains;
            this.changedFields = changedFields.add("recipientContains");
            return this;
        }

        public Builder recipientContains(String... recipientContains) {
            return recipientContains(Arrays.asList(recipientContains));
        }

        public Builder recipientContainsNextLink(String recipientContainsNextLink) {
            this.recipientContainsNextLink = recipientContainsNextLink;
            this.changedFields = changedFields.add("recipientContains");
            return this;
        }

        public Builder headerContains(List<String> headerContains) {
            this.headerContains = headerContains;
            this.changedFields = changedFields.add("headerContains");
            return this;
        }

        public Builder headerContains(String... headerContains) {
            return headerContains(Arrays.asList(headerContains));
        }

        public Builder headerContainsNextLink(String headerContainsNextLink) {
            this.headerContainsNextLink = headerContainsNextLink;
            this.changedFields = changedFields.add("headerContains");
            return this;
        }

        public Builder messageActionFlag(MessageActionFlag messageActionFlag) {
            this.messageActionFlag = messageActionFlag;
            this.changedFields = changedFields.add("messageActionFlag");
            return this;
        }

        public Builder importance(Importance importance) {
            this.importance = importance;
            this.changedFields = changedFields.add("importance");
            return this;
        }

        public Builder sensitivity(Sensitivity sensitivity) {
            this.sensitivity = sensitivity;
            this.changedFields = changedFields.add("sensitivity");
            return this;
        }

        public Builder fromAddresses(List<Recipient> fromAddresses) {
            this.fromAddresses = fromAddresses;
            this.changedFields = changedFields.add("fromAddresses");
            return this;
        }

        public Builder fromAddresses(Recipient... fromAddresses) {
            return fromAddresses(Arrays.asList(fromAddresses));
        }

        public Builder fromAddressesNextLink(String fromAddressesNextLink) {
            this.fromAddressesNextLink = fromAddressesNextLink;
            this.changedFields = changedFields.add("fromAddresses");
            return this;
        }

        public Builder sentToAddresses(List<Recipient> sentToAddresses) {
            this.sentToAddresses = sentToAddresses;
            this.changedFields = changedFields.add("sentToAddresses");
            return this;
        }

        public Builder sentToAddresses(Recipient... sentToAddresses) {
            return sentToAddresses(Arrays.asList(sentToAddresses));
        }

        public Builder sentToAddressesNextLink(String sentToAddressesNextLink) {
            this.sentToAddressesNextLink = sentToAddressesNextLink;
            this.changedFields = changedFields.add("sentToAddresses");
            return this;
        }

        public Builder sentToMe(Boolean sentToMe) {
            this.sentToMe = sentToMe;
            this.changedFields = changedFields.add("sentToMe");
            return this;
        }

        public Builder sentOnlyToMe(Boolean sentOnlyToMe) {
            this.sentOnlyToMe = sentOnlyToMe;
            this.changedFields = changedFields.add("sentOnlyToMe");
            return this;
        }

        public Builder sentCcMe(Boolean sentCcMe) {
            this.sentCcMe = sentCcMe;
            this.changedFields = changedFields.add("sentCcMe");
            return this;
        }

        public Builder sentToOrCcMe(Boolean sentToOrCcMe) {
            this.sentToOrCcMe = sentToOrCcMe;
            this.changedFields = changedFields.add("sentToOrCcMe");
            return this;
        }

        public Builder notSentToMe(Boolean notSentToMe) {
            this.notSentToMe = notSentToMe;
            this.changedFields = changedFields.add("notSentToMe");
            return this;
        }

        public Builder hasAttachments(Boolean hasAttachments) {
            this.hasAttachments = hasAttachments;
            this.changedFields = changedFields.add("hasAttachments");
            return this;
        }

        public Builder isApprovalRequest(Boolean isApprovalRequest) {
            this.isApprovalRequest = isApprovalRequest;
            this.changedFields = changedFields.add("isApprovalRequest");
            return this;
        }

        public Builder isAutomaticForward(Boolean isAutomaticForward) {
            this.isAutomaticForward = isAutomaticForward;
            this.changedFields = changedFields.add("isAutomaticForward");
            return this;
        }

        public Builder isAutomaticReply(Boolean isAutomaticReply) {
            this.isAutomaticReply = isAutomaticReply;
            this.changedFields = changedFields.add("isAutomaticReply");
            return this;
        }

        public Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            this.changedFields = changedFields.add("isEncrypted");
            return this;
        }

        public Builder isMeetingRequest(Boolean isMeetingRequest) {
            this.isMeetingRequest = isMeetingRequest;
            this.changedFields = changedFields.add("isMeetingRequest");
            return this;
        }

        public Builder isMeetingResponse(Boolean isMeetingResponse) {
            this.isMeetingResponse = isMeetingResponse;
            this.changedFields = changedFields.add("isMeetingResponse");
            return this;
        }

        public Builder isNonDeliveryReport(Boolean isNonDeliveryReport) {
            this.isNonDeliveryReport = isNonDeliveryReport;
            this.changedFields = changedFields.add("isNonDeliveryReport");
            return this;
        }

        public Builder isPermissionControlled(Boolean isPermissionControlled) {
            this.isPermissionControlled = isPermissionControlled;
            this.changedFields = changedFields.add("isPermissionControlled");
            return this;
        }

        public Builder isReadReceipt(Boolean isReadReceipt) {
            this.isReadReceipt = isReadReceipt;
            this.changedFields = changedFields.add("isReadReceipt");
            return this;
        }

        public Builder isSigned(Boolean isSigned) {
            this.isSigned = isSigned;
            this.changedFields = changedFields.add("isSigned");
            return this;
        }

        public Builder isVoicemail(Boolean isVoicemail) {
            this.isVoicemail = isVoicemail;
            this.changedFields = changedFields.add("isVoicemail");
            return this;
        }

        public Builder withinSizeRange(SizeRange withinSizeRange) {
            this.withinSizeRange = withinSizeRange;
            this.changedFields = changedFields.add("withinSizeRange");
            return this;
        }

        public MessageRulePredicates build() {
            MessageRulePredicates _x = new MessageRulePredicates();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.messageRulePredicates";
            _x.categories = categories;
            _x.categoriesNextLink = categoriesNextLink;
            _x.subjectContains = subjectContains;
            _x.subjectContainsNextLink = subjectContainsNextLink;
            _x.bodyContains = bodyContains;
            _x.bodyContainsNextLink = bodyContainsNextLink;
            _x.bodyOrSubjectContains = bodyOrSubjectContains;
            _x.bodyOrSubjectContainsNextLink = bodyOrSubjectContainsNextLink;
            _x.senderContains = senderContains;
            _x.senderContainsNextLink = senderContainsNextLink;
            _x.recipientContains = recipientContains;
            _x.recipientContainsNextLink = recipientContainsNextLink;
            _x.headerContains = headerContains;
            _x.headerContainsNextLink = headerContainsNextLink;
            _x.messageActionFlag = messageActionFlag;
            _x.importance = importance;
            _x.sensitivity = sensitivity;
            _x.fromAddresses = fromAddresses;
            _x.fromAddressesNextLink = fromAddressesNextLink;
            _x.sentToAddresses = sentToAddresses;
            _x.sentToAddressesNextLink = sentToAddressesNextLink;
            _x.sentToMe = sentToMe;
            _x.sentOnlyToMe = sentOnlyToMe;
            _x.sentCcMe = sentCcMe;
            _x.sentToOrCcMe = sentToOrCcMe;
            _x.notSentToMe = notSentToMe;
            _x.hasAttachments = hasAttachments;
            _x.isApprovalRequest = isApprovalRequest;
            _x.isAutomaticForward = isAutomaticForward;
            _x.isAutomaticReply = isAutomaticReply;
            _x.isEncrypted = isEncrypted;
            _x.isMeetingRequest = isMeetingRequest;
            _x.isMeetingResponse = isMeetingResponse;
            _x.isNonDeliveryReport = isNonDeliveryReport;
            _x.isPermissionControlled = isPermissionControlled;
            _x.isReadReceipt = isReadReceipt;
            _x.isSigned = isSigned;
            _x.isVoicemail = isVoicemail;
            _x.withinSizeRange = withinSizeRange;
            return _x;
        }
    }

    private MessageRulePredicates _copy() {
        MessageRulePredicates _x = new MessageRulePredicates();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.categories = categories;
        _x.subjectContains = subjectContains;
        _x.bodyContains = bodyContains;
        _x.bodyOrSubjectContains = bodyOrSubjectContains;
        _x.senderContains = senderContains;
        _x.recipientContains = recipientContains;
        _x.headerContains = headerContains;
        _x.messageActionFlag = messageActionFlag;
        _x.importance = importance;
        _x.sensitivity = sensitivity;
        _x.fromAddresses = fromAddresses;
        _x.sentToAddresses = sentToAddresses;
        _x.sentToMe = sentToMe;
        _x.sentOnlyToMe = sentOnlyToMe;
        _x.sentCcMe = sentCcMe;
        _x.sentToOrCcMe = sentToOrCcMe;
        _x.notSentToMe = notSentToMe;
        _x.hasAttachments = hasAttachments;
        _x.isApprovalRequest = isApprovalRequest;
        _x.isAutomaticForward = isAutomaticForward;
        _x.isAutomaticReply = isAutomaticReply;
        _x.isEncrypted = isEncrypted;
        _x.isMeetingRequest = isMeetingRequest;
        _x.isMeetingResponse = isMeetingResponse;
        _x.isNonDeliveryReport = isNonDeliveryReport;
        _x.isPermissionControlled = isPermissionControlled;
        _x.isReadReceipt = isReadReceipt;
        _x.isSigned = isSigned;
        _x.isVoicemail = isVoicemail;
        _x.withinSizeRange = withinSizeRange;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MessageRulePredicates[");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("subjectContains=");
        b.append(this.subjectContains);
        b.append(", ");
        b.append("bodyContains=");
        b.append(this.bodyContains);
        b.append(", ");
        b.append("bodyOrSubjectContains=");
        b.append(this.bodyOrSubjectContains);
        b.append(", ");
        b.append("senderContains=");
        b.append(this.senderContains);
        b.append(", ");
        b.append("recipientContains=");
        b.append(this.recipientContains);
        b.append(", ");
        b.append("headerContains=");
        b.append(this.headerContains);
        b.append(", ");
        b.append("messageActionFlag=");
        b.append(this.messageActionFlag);
        b.append(", ");
        b.append("importance=");
        b.append(this.importance);
        b.append(", ");
        b.append("sensitivity=");
        b.append(this.sensitivity);
        b.append(", ");
        b.append("fromAddresses=");
        b.append(this.fromAddresses);
        b.append(", ");
        b.append("sentToAddresses=");
        b.append(this.sentToAddresses);
        b.append(", ");
        b.append("sentToMe=");
        b.append(this.sentToMe);
        b.append(", ");
        b.append("sentOnlyToMe=");
        b.append(this.sentOnlyToMe);
        b.append(", ");
        b.append("sentCcMe=");
        b.append(this.sentCcMe);
        b.append(", ");
        b.append("sentToOrCcMe=");
        b.append(this.sentToOrCcMe);
        b.append(", ");
        b.append("notSentToMe=");
        b.append(this.notSentToMe);
        b.append(", ");
        b.append("hasAttachments=");
        b.append(this.hasAttachments);
        b.append(", ");
        b.append("isApprovalRequest=");
        b.append(this.isApprovalRequest);
        b.append(", ");
        b.append("isAutomaticForward=");
        b.append(this.isAutomaticForward);
        b.append(", ");
        b.append("isAutomaticReply=");
        b.append(this.isAutomaticReply);
        b.append(", ");
        b.append("isEncrypted=");
        b.append(this.isEncrypted);
        b.append(", ");
        b.append("isMeetingRequest=");
        b.append(this.isMeetingRequest);
        b.append(", ");
        b.append("isMeetingResponse=");
        b.append(this.isMeetingResponse);
        b.append(", ");
        b.append("isNonDeliveryReport=");
        b.append(this.isNonDeliveryReport);
        b.append(", ");
        b.append("isPermissionControlled=");
        b.append(this.isPermissionControlled);
        b.append(", ");
        b.append("isReadReceipt=");
        b.append(this.isReadReceipt);
        b.append(", ");
        b.append("isSigned=");
        b.append(this.isSigned);
        b.append(", ");
        b.append("isVoicemail=");
        b.append(this.isVoicemail);
        b.append(", ");
        b.append("withinSizeRange=");
        b.append(this.withinSizeRange);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
