package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.Importance;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "moveToFolder", 
    "copyToFolder", 
    "delete", 
    "permanentDelete", 
    "markAsRead", 
    "markImportance", 
    "forwardTo", 
    "forwardAsAttachmentTo", 
    "redirectTo", 
    "assignCategories", 
    "stopProcessingRules"})
@JsonInclude(Include.NON_NULL)
public class MessageRuleActions implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("moveToFolder")
    protected String moveToFolder;

    @JsonProperty("copyToFolder")
    protected String copyToFolder;

    @JsonProperty("delete")
    protected Boolean delete;

    @JsonProperty("permanentDelete")
    protected Boolean permanentDelete;

    @JsonProperty("markAsRead")
    protected Boolean markAsRead;

    @JsonProperty("markImportance")
    protected Importance markImportance;

    @JsonProperty("forwardTo")
    protected List<Recipient> forwardTo;

    @JsonProperty("forwardTo@nextLink")
    protected String forwardToNextLink;

    @JsonProperty("forwardAsAttachmentTo")
    protected List<Recipient> forwardAsAttachmentTo;

    @JsonProperty("forwardAsAttachmentTo@nextLink")
    protected String forwardAsAttachmentToNextLink;

    @JsonProperty("redirectTo")
    protected List<Recipient> redirectTo;

    @JsonProperty("redirectTo@nextLink")
    protected String redirectToNextLink;

    @JsonProperty("assignCategories")
    protected List<String> assignCategories;

    @JsonProperty("assignCategories@nextLink")
    protected String assignCategoriesNextLink;

    @JsonProperty("stopProcessingRules")
    protected Boolean stopProcessingRules;

    protected MessageRuleActions() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.messageRuleActions";
    }

    @Property(name="moveToFolder")
    @JsonIgnore
    public Optional<String> getMoveToFolder() {
        return Optional.ofNullable(moveToFolder);
    }

    public MessageRuleActions withMoveToFolder(String moveToFolder) {
        MessageRuleActions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRuleActions");
        _x.moveToFolder = moveToFolder;
        return _x;
    }

    @Property(name="copyToFolder")
    @JsonIgnore
    public Optional<String> getCopyToFolder() {
        return Optional.ofNullable(copyToFolder);
    }

    public MessageRuleActions withCopyToFolder(String copyToFolder) {
        MessageRuleActions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRuleActions");
        _x.copyToFolder = copyToFolder;
        return _x;
    }

    @Property(name="delete")
    @JsonIgnore
    public Optional<Boolean> getDelete() {
        return Optional.ofNullable(delete);
    }

    public MessageRuleActions withDelete(Boolean delete) {
        MessageRuleActions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRuleActions");
        _x.delete = delete;
        return _x;
    }

    @Property(name="permanentDelete")
    @JsonIgnore
    public Optional<Boolean> getPermanentDelete() {
        return Optional.ofNullable(permanentDelete);
    }

    public MessageRuleActions withPermanentDelete(Boolean permanentDelete) {
        MessageRuleActions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRuleActions");
        _x.permanentDelete = permanentDelete;
        return _x;
    }

    @Property(name="markAsRead")
    @JsonIgnore
    public Optional<Boolean> getMarkAsRead() {
        return Optional.ofNullable(markAsRead);
    }

    public MessageRuleActions withMarkAsRead(Boolean markAsRead) {
        MessageRuleActions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRuleActions");
        _x.markAsRead = markAsRead;
        return _x;
    }

    @Property(name="markImportance")
    @JsonIgnore
    public Optional<Importance> getMarkImportance() {
        return Optional.ofNullable(markImportance);
    }

    public MessageRuleActions withMarkImportance(Importance markImportance) {
        MessageRuleActions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRuleActions");
        _x.markImportance = markImportance;
        return _x;
    }

    @Property(name="forwardTo")
    @JsonIgnore
    public CollectionPage<Recipient> getForwardTo() {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, forwardTo, Optional.ofNullable(forwardToNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="forwardTo")
    @JsonIgnore
    public CollectionPage<Recipient> getForwardTo(HttpRequestOptions options) {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, forwardTo, Optional.ofNullable(forwardToNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="forwardAsAttachmentTo")
    @JsonIgnore
    public CollectionPage<Recipient> getForwardAsAttachmentTo() {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, forwardAsAttachmentTo, Optional.ofNullable(forwardAsAttachmentToNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="forwardAsAttachmentTo")
    @JsonIgnore
    public CollectionPage<Recipient> getForwardAsAttachmentTo(HttpRequestOptions options) {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, forwardAsAttachmentTo, Optional.ofNullable(forwardAsAttachmentToNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="redirectTo")
    @JsonIgnore
    public CollectionPage<Recipient> getRedirectTo() {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, redirectTo, Optional.ofNullable(redirectToNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="redirectTo")
    @JsonIgnore
    public CollectionPage<Recipient> getRedirectTo(HttpRequestOptions options) {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, redirectTo, Optional.ofNullable(redirectToNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="assignCategories")
    @JsonIgnore
    public CollectionPage<String> getAssignCategories() {
        return new CollectionPage<String>(contextPath, String.class, assignCategories, Optional.ofNullable(assignCategoriesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="assignCategories")
    @JsonIgnore
    public CollectionPage<String> getAssignCategories(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, assignCategories, Optional.ofNullable(assignCategoriesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="stopProcessingRules")
    @JsonIgnore
    public Optional<Boolean> getStopProcessingRules() {
        return Optional.ofNullable(stopProcessingRules);
    }

    public MessageRuleActions withStopProcessingRules(Boolean stopProcessingRules) {
        MessageRuleActions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.messageRuleActions");
        _x.stopProcessingRules = stopProcessingRules;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String moveToFolder;
        private String copyToFolder;
        private Boolean delete;
        private Boolean permanentDelete;
        private Boolean markAsRead;
        private Importance markImportance;
        private List<Recipient> forwardTo;
        private String forwardToNextLink;
        private List<Recipient> forwardAsAttachmentTo;
        private String forwardAsAttachmentToNextLink;
        private List<Recipient> redirectTo;
        private String redirectToNextLink;
        private List<String> assignCategories;
        private String assignCategoriesNextLink;
        private Boolean stopProcessingRules;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder moveToFolder(String moveToFolder) {
            this.moveToFolder = moveToFolder;
            this.changedFields = changedFields.add("moveToFolder");
            return this;
        }

        public Builder copyToFolder(String copyToFolder) {
            this.copyToFolder = copyToFolder;
            this.changedFields = changedFields.add("copyToFolder");
            return this;
        }

        public Builder delete(Boolean delete) {
            this.delete = delete;
            this.changedFields = changedFields.add("delete");
            return this;
        }

        public Builder permanentDelete(Boolean permanentDelete) {
            this.permanentDelete = permanentDelete;
            this.changedFields = changedFields.add("permanentDelete");
            return this;
        }

        public Builder markAsRead(Boolean markAsRead) {
            this.markAsRead = markAsRead;
            this.changedFields = changedFields.add("markAsRead");
            return this;
        }

        public Builder markImportance(Importance markImportance) {
            this.markImportance = markImportance;
            this.changedFields = changedFields.add("markImportance");
            return this;
        }

        public Builder forwardTo(List<Recipient> forwardTo) {
            this.forwardTo = forwardTo;
            this.changedFields = changedFields.add("forwardTo");
            return this;
        }

        public Builder forwardTo(Recipient... forwardTo) {
            return forwardTo(Arrays.asList(forwardTo));
        }

        public Builder forwardToNextLink(String forwardToNextLink) {
            this.forwardToNextLink = forwardToNextLink;
            this.changedFields = changedFields.add("forwardTo");
            return this;
        }

        public Builder forwardAsAttachmentTo(List<Recipient> forwardAsAttachmentTo) {
            this.forwardAsAttachmentTo = forwardAsAttachmentTo;
            this.changedFields = changedFields.add("forwardAsAttachmentTo");
            return this;
        }

        public Builder forwardAsAttachmentTo(Recipient... forwardAsAttachmentTo) {
            return forwardAsAttachmentTo(Arrays.asList(forwardAsAttachmentTo));
        }

        public Builder forwardAsAttachmentToNextLink(String forwardAsAttachmentToNextLink) {
            this.forwardAsAttachmentToNextLink = forwardAsAttachmentToNextLink;
            this.changedFields = changedFields.add("forwardAsAttachmentTo");
            return this;
        }

        public Builder redirectTo(List<Recipient> redirectTo) {
            this.redirectTo = redirectTo;
            this.changedFields = changedFields.add("redirectTo");
            return this;
        }

        public Builder redirectTo(Recipient... redirectTo) {
            return redirectTo(Arrays.asList(redirectTo));
        }

        public Builder redirectToNextLink(String redirectToNextLink) {
            this.redirectToNextLink = redirectToNextLink;
            this.changedFields = changedFields.add("redirectTo");
            return this;
        }

        public Builder assignCategories(List<String> assignCategories) {
            this.assignCategories = assignCategories;
            this.changedFields = changedFields.add("assignCategories");
            return this;
        }

        public Builder assignCategories(String... assignCategories) {
            return assignCategories(Arrays.asList(assignCategories));
        }

        public Builder assignCategoriesNextLink(String assignCategoriesNextLink) {
            this.assignCategoriesNextLink = assignCategoriesNextLink;
            this.changedFields = changedFields.add("assignCategories");
            return this;
        }

        public Builder stopProcessingRules(Boolean stopProcessingRules) {
            this.stopProcessingRules = stopProcessingRules;
            this.changedFields = changedFields.add("stopProcessingRules");
            return this;
        }

        public MessageRuleActions build() {
            MessageRuleActions _x = new MessageRuleActions();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.messageRuleActions";
            _x.moveToFolder = moveToFolder;
            _x.copyToFolder = copyToFolder;
            _x.delete = delete;
            _x.permanentDelete = permanentDelete;
            _x.markAsRead = markAsRead;
            _x.markImportance = markImportance;
            _x.forwardTo = forwardTo;
            _x.forwardToNextLink = forwardToNextLink;
            _x.forwardAsAttachmentTo = forwardAsAttachmentTo;
            _x.forwardAsAttachmentToNextLink = forwardAsAttachmentToNextLink;
            _x.redirectTo = redirectTo;
            _x.redirectToNextLink = redirectToNextLink;
            _x.assignCategories = assignCategories;
            _x.assignCategoriesNextLink = assignCategoriesNextLink;
            _x.stopProcessingRules = stopProcessingRules;
            return _x;
        }
    }

    private MessageRuleActions _copy() {
        MessageRuleActions _x = new MessageRuleActions();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.moveToFolder = moveToFolder;
        _x.copyToFolder = copyToFolder;
        _x.delete = delete;
        _x.permanentDelete = permanentDelete;
        _x.markAsRead = markAsRead;
        _x.markImportance = markImportance;
        _x.forwardTo = forwardTo;
        _x.forwardAsAttachmentTo = forwardAsAttachmentTo;
        _x.redirectTo = redirectTo;
        _x.assignCategories = assignCategories;
        _x.stopProcessingRules = stopProcessingRules;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MessageRuleActions[");
        b.append("moveToFolder=");
        b.append(this.moveToFolder);
        b.append(", ");
        b.append("copyToFolder=");
        b.append(this.copyToFolder);
        b.append(", ");
        b.append("delete=");
        b.append(this.delete);
        b.append(", ");
        b.append("permanentDelete=");
        b.append(this.permanentDelete);
        b.append(", ");
        b.append("markAsRead=");
        b.append(this.markAsRead);
        b.append(", ");
        b.append("markImportance=");
        b.append(this.markImportance);
        b.append(", ");
        b.append("forwardTo=");
        b.append(this.forwardTo);
        b.append(", ");
        b.append("forwardAsAttachmentTo=");
        b.append(this.forwardAsAttachmentTo);
        b.append(", ");
        b.append("redirectTo=");
        b.append(this.redirectTo);
        b.append(", ");
        b.append("assignCategories=");
        b.append(this.assignCategories);
        b.append(", ");
        b.append("stopProcessingRules=");
        b.append(this.stopProcessingRules);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
