package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "mentionees"})
@JsonInclude(Include.NON_NULL)
public class MentionAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("mentionees")
    protected List<IdentitySet> mentionees;

    @JsonProperty("mentionees@nextLink")
    protected String mentioneesNextLink;

    protected MentionAction() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mentionAction";
    }

    @Property(name="mentionees")
    @JsonIgnore
    public CollectionPage<IdentitySet> getMentionees() {
        return new CollectionPage<IdentitySet>(contextPath, IdentitySet.class, mentionees, Optional.ofNullable(mentioneesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="mentionees")
    @JsonIgnore
    public CollectionPage<IdentitySet> getMentionees(HttpRequestOptions options) {
        return new CollectionPage<IdentitySet>(contextPath, IdentitySet.class, mentionees, Optional.ofNullable(mentioneesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<IdentitySet> mentionees;
        private String mentioneesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder mentionees(List<IdentitySet> mentionees) {
            this.mentionees = mentionees;
            this.changedFields = changedFields.add("mentionees");
            return this;
        }

        public Builder mentionees(IdentitySet... mentionees) {
            return mentionees(Arrays.asList(mentionees));
        }

        public Builder mentioneesNextLink(String mentioneesNextLink) {
            this.mentioneesNextLink = mentioneesNextLink;
            this.changedFields = changedFields.add("mentionees");
            return this;
        }

        public MentionAction build() {
            MentionAction _x = new MentionAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mentionAction";
            _x.mentionees = mentionees;
            _x.mentioneesNextLink = mentioneesNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MentionAction[");
        b.append("mentionees=");
        b.append(this.mentionees);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
