package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "membershipRuleEvaluationDetails"})
@JsonInclude(Include.NON_NULL)
public class MembershipRuleEvaluationDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("membershipRuleEvaluationDetails")
    protected ExpressionEvaluationDetails membershipRuleEvaluationDetails;

    protected MembershipRuleEvaluationDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.membershipRuleEvaluationDetails";
    }

    @Property(name="membershipRuleEvaluationDetails")
    @JsonIgnore
    public Optional<ExpressionEvaluationDetails> getMembershipRuleEvaluationDetails() {
        return Optional.ofNullable(membershipRuleEvaluationDetails);
    }

    public MembershipRuleEvaluationDetails withMembershipRuleEvaluationDetails(ExpressionEvaluationDetails membershipRuleEvaluationDetails) {
        MembershipRuleEvaluationDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.membershipRuleEvaluationDetails");
        _x.membershipRuleEvaluationDetails = membershipRuleEvaluationDetails;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ExpressionEvaluationDetails membershipRuleEvaluationDetails;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder membershipRuleEvaluationDetails(ExpressionEvaluationDetails membershipRuleEvaluationDetails) {
            this.membershipRuleEvaluationDetails = membershipRuleEvaluationDetails;
            this.changedFields = changedFields.add("membershipRuleEvaluationDetails");
            return this;
        }

        public MembershipRuleEvaluationDetails build() {
            MembershipRuleEvaluationDetails _x = new MembershipRuleEvaluationDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.membershipRuleEvaluationDetails";
            _x.membershipRuleEvaluationDetails = membershipRuleEvaluationDetails;
            return _x;
        }
    }

    private MembershipRuleEvaluationDetails _copy() {
        MembershipRuleEvaluationDetails _x = new MembershipRuleEvaluationDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.membershipRuleEvaluationDetails = membershipRuleEvaluationDetails;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MembershipRuleEvaluationDetails[");
        b.append("membershipRuleEvaluationDetails=");
        b.append(this.membershipRuleEvaluationDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
