package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "meetingTimeSuggestions", 
    "emptySuggestionsReason"})
@JsonInclude(Include.NON_NULL)
public class MeetingTimeSuggestionsResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("meetingTimeSuggestions")
    protected List<MeetingTimeSuggestion> meetingTimeSuggestions;

    @JsonProperty("meetingTimeSuggestions@nextLink")
    protected String meetingTimeSuggestionsNextLink;

    @JsonProperty("emptySuggestionsReason")
    protected String emptySuggestionsReason;

    protected MeetingTimeSuggestionsResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.meetingTimeSuggestionsResult";
    }

    @Property(name="meetingTimeSuggestions")
    @JsonIgnore
    public CollectionPage<MeetingTimeSuggestion> getMeetingTimeSuggestions() {
        return new CollectionPage<MeetingTimeSuggestion>(contextPath, MeetingTimeSuggestion.class, meetingTimeSuggestions, Optional.ofNullable(meetingTimeSuggestionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="meetingTimeSuggestions")
    @JsonIgnore
    public CollectionPage<MeetingTimeSuggestion> getMeetingTimeSuggestions(HttpRequestOptions options) {
        return new CollectionPage<MeetingTimeSuggestion>(contextPath, MeetingTimeSuggestion.class, meetingTimeSuggestions, Optional.ofNullable(meetingTimeSuggestionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="emptySuggestionsReason")
    @JsonIgnore
    public Optional<String> getEmptySuggestionsReason() {
        return Optional.ofNullable(emptySuggestionsReason);
    }

    public MeetingTimeSuggestionsResult withEmptySuggestionsReason(String emptySuggestionsReason) {
        MeetingTimeSuggestionsResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingTimeSuggestionsResult");
        _x.emptySuggestionsReason = emptySuggestionsReason;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<MeetingTimeSuggestion> meetingTimeSuggestions;
        private String meetingTimeSuggestionsNextLink;
        private String emptySuggestionsReason;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder meetingTimeSuggestions(List<MeetingTimeSuggestion> meetingTimeSuggestions) {
            this.meetingTimeSuggestions = meetingTimeSuggestions;
            this.changedFields = changedFields.add("meetingTimeSuggestions");
            return this;
        }

        public Builder meetingTimeSuggestions(MeetingTimeSuggestion... meetingTimeSuggestions) {
            return meetingTimeSuggestions(Arrays.asList(meetingTimeSuggestions));
        }

        public Builder meetingTimeSuggestionsNextLink(String meetingTimeSuggestionsNextLink) {
            this.meetingTimeSuggestionsNextLink = meetingTimeSuggestionsNextLink;
            this.changedFields = changedFields.add("meetingTimeSuggestions");
            return this;
        }

        public Builder emptySuggestionsReason(String emptySuggestionsReason) {
            this.emptySuggestionsReason = emptySuggestionsReason;
            this.changedFields = changedFields.add("emptySuggestionsReason");
            return this;
        }

        public MeetingTimeSuggestionsResult build() {
            MeetingTimeSuggestionsResult _x = new MeetingTimeSuggestionsResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.meetingTimeSuggestionsResult";
            _x.meetingTimeSuggestions = meetingTimeSuggestions;
            _x.meetingTimeSuggestionsNextLink = meetingTimeSuggestionsNextLink;
            _x.emptySuggestionsReason = emptySuggestionsReason;
            return _x;
        }
    }

    private MeetingTimeSuggestionsResult _copy() {
        MeetingTimeSuggestionsResult _x = new MeetingTimeSuggestionsResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.meetingTimeSuggestions = meetingTimeSuggestions;
        _x.emptySuggestionsReason = emptySuggestionsReason;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MeetingTimeSuggestionsResult[");
        b.append("meetingTimeSuggestions=");
        b.append(this.meetingTimeSuggestions);
        b.append(", ");
        b.append("emptySuggestionsReason=");
        b.append(this.emptySuggestionsReason);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
