package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.FreeBusyStatus;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "confidence", 
    "order", 
    "organizerAvailability", 
    "attendeeAvailability", 
    "locations", 
    "suggestionReason", 
    "meetingTimeSlot"})
@JsonInclude(Include.NON_NULL)
public class MeetingTimeSuggestion implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("confidence")
    protected Double confidence;

    @JsonProperty("order")
    protected Integer order;

    @JsonProperty("organizerAvailability")
    protected FreeBusyStatus organizerAvailability;

    @JsonProperty("attendeeAvailability")
    protected List<AttendeeAvailability> attendeeAvailability;

    @JsonProperty("attendeeAvailability@nextLink")
    protected String attendeeAvailabilityNextLink;

    @JsonProperty("locations")
    protected List<Location> locations;

    @JsonProperty("locations@nextLink")
    protected String locationsNextLink;

    @JsonProperty("suggestionReason")
    protected String suggestionReason;

    @JsonProperty("meetingTimeSlot")
    protected TimeSlot meetingTimeSlot;

    protected MeetingTimeSuggestion() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.meetingTimeSuggestion";
    }

    @Property(name="confidence")
    @JsonIgnore
    public Optional<Double> getConfidence() {
        return Optional.ofNullable(confidence);
    }

    public MeetingTimeSuggestion withConfidence(Double confidence) {
        MeetingTimeSuggestion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingTimeSuggestion");
        _x.confidence = confidence;
        return _x;
    }

    @Property(name="order")
    @JsonIgnore
    public Optional<Integer> getOrder() {
        return Optional.ofNullable(order);
    }

    public MeetingTimeSuggestion withOrder(Integer order) {
        MeetingTimeSuggestion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingTimeSuggestion");
        _x.order = order;
        return _x;
    }

    @Property(name="organizerAvailability")
    @JsonIgnore
    public Optional<FreeBusyStatus> getOrganizerAvailability() {
        return Optional.ofNullable(organizerAvailability);
    }

    public MeetingTimeSuggestion withOrganizerAvailability(FreeBusyStatus organizerAvailability) {
        MeetingTimeSuggestion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingTimeSuggestion");
        _x.organizerAvailability = organizerAvailability;
        return _x;
    }

    @Property(name="attendeeAvailability")
    @JsonIgnore
    public CollectionPage<AttendeeAvailability> getAttendeeAvailability() {
        return new CollectionPage<AttendeeAvailability>(contextPath, AttendeeAvailability.class, attendeeAvailability, Optional.ofNullable(attendeeAvailabilityNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="attendeeAvailability")
    @JsonIgnore
    public CollectionPage<AttendeeAvailability> getAttendeeAvailability(HttpRequestOptions options) {
        return new CollectionPage<AttendeeAvailability>(contextPath, AttendeeAvailability.class, attendeeAvailability, Optional.ofNullable(attendeeAvailabilityNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="locations")
    @JsonIgnore
    public CollectionPage<Location> getLocations() {
        return new CollectionPage<Location>(contextPath, Location.class, locations, Optional.ofNullable(locationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="locations")
    @JsonIgnore
    public CollectionPage<Location> getLocations(HttpRequestOptions options) {
        return new CollectionPage<Location>(contextPath, Location.class, locations, Optional.ofNullable(locationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="suggestionReason")
    @JsonIgnore
    public Optional<String> getSuggestionReason() {
        return Optional.ofNullable(suggestionReason);
    }

    public MeetingTimeSuggestion withSuggestionReason(String suggestionReason) {
        MeetingTimeSuggestion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingTimeSuggestion");
        _x.suggestionReason = suggestionReason;
        return _x;
    }

    @Property(name="meetingTimeSlot")
    @JsonIgnore
    public Optional<TimeSlot> getMeetingTimeSlot() {
        return Optional.ofNullable(meetingTimeSlot);
    }

    public MeetingTimeSuggestion withMeetingTimeSlot(TimeSlot meetingTimeSlot) {
        MeetingTimeSuggestion _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingTimeSuggestion");
        _x.meetingTimeSlot = meetingTimeSlot;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Double confidence;
        private Integer order;
        private FreeBusyStatus organizerAvailability;
        private List<AttendeeAvailability> attendeeAvailability;
        private String attendeeAvailabilityNextLink;
        private List<Location> locations;
        private String locationsNextLink;
        private String suggestionReason;
        private TimeSlot meetingTimeSlot;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder confidence(Double confidence) {
            this.confidence = confidence;
            this.changedFields = changedFields.add("confidence");
            return this;
        }

        public Builder order(Integer order) {
            this.order = order;
            this.changedFields = changedFields.add("order");
            return this;
        }

        public Builder organizerAvailability(FreeBusyStatus organizerAvailability) {
            this.organizerAvailability = organizerAvailability;
            this.changedFields = changedFields.add("organizerAvailability");
            return this;
        }

        public Builder attendeeAvailability(List<AttendeeAvailability> attendeeAvailability) {
            this.attendeeAvailability = attendeeAvailability;
            this.changedFields = changedFields.add("attendeeAvailability");
            return this;
        }

        public Builder attendeeAvailability(AttendeeAvailability... attendeeAvailability) {
            return attendeeAvailability(Arrays.asList(attendeeAvailability));
        }

        public Builder attendeeAvailabilityNextLink(String attendeeAvailabilityNextLink) {
            this.attendeeAvailabilityNextLink = attendeeAvailabilityNextLink;
            this.changedFields = changedFields.add("attendeeAvailability");
            return this;
        }

        public Builder locations(List<Location> locations) {
            this.locations = locations;
            this.changedFields = changedFields.add("locations");
            return this;
        }

        public Builder locations(Location... locations) {
            return locations(Arrays.asList(locations));
        }

        public Builder locationsNextLink(String locationsNextLink) {
            this.locationsNextLink = locationsNextLink;
            this.changedFields = changedFields.add("locations");
            return this;
        }

        public Builder suggestionReason(String suggestionReason) {
            this.suggestionReason = suggestionReason;
            this.changedFields = changedFields.add("suggestionReason");
            return this;
        }

        public Builder meetingTimeSlot(TimeSlot meetingTimeSlot) {
            this.meetingTimeSlot = meetingTimeSlot;
            this.changedFields = changedFields.add("meetingTimeSlot");
            return this;
        }

        public MeetingTimeSuggestion build() {
            MeetingTimeSuggestion _x = new MeetingTimeSuggestion();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.meetingTimeSuggestion";
            _x.confidence = confidence;
            _x.order = order;
            _x.organizerAvailability = organizerAvailability;
            _x.attendeeAvailability = attendeeAvailability;
            _x.attendeeAvailabilityNextLink = attendeeAvailabilityNextLink;
            _x.locations = locations;
            _x.locationsNextLink = locationsNextLink;
            _x.suggestionReason = suggestionReason;
            _x.meetingTimeSlot = meetingTimeSlot;
            return _x;
        }
    }

    private MeetingTimeSuggestion _copy() {
        MeetingTimeSuggestion _x = new MeetingTimeSuggestion();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.confidence = confidence;
        _x.order = order;
        _x.organizerAvailability = organizerAvailability;
        _x.attendeeAvailability = attendeeAvailability;
        _x.locations = locations;
        _x.suggestionReason = suggestionReason;
        _x.meetingTimeSlot = meetingTimeSlot;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MeetingTimeSuggestion[");
        b.append("confidence=");
        b.append(this.confidence);
        b.append(", ");
        b.append("order=");
        b.append(this.order);
        b.append(", ");
        b.append("organizerAvailability=");
        b.append(this.organizerAvailability);
        b.append(", ");
        b.append("attendeeAvailability=");
        b.append(this.attendeeAvailability);
        b.append(", ");
        b.append("locations=");
        b.append(this.locations);
        b.append(", ");
        b.append("suggestionReason=");
        b.append(this.suggestionReason);
        b.append(", ");
        b.append("meetingTimeSlot=");
        b.append(this.meetingTimeSlot);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
