package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.AutoAdmittedUsersType;

@JsonPropertyOrder({
    "@odata.type", 
    "allowAnonymousUsersToDialOut", 
    "autoAdmittedUsers", 
    "allowAnonymousUsersToStartMeeting"})
@JsonInclude(Include.NON_NULL)
public class MeetingCapability implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowAnonymousUsersToDialOut")
    protected Boolean allowAnonymousUsersToDialOut;

    @JsonProperty("autoAdmittedUsers")
    protected AutoAdmittedUsersType autoAdmittedUsers;

    @JsonProperty("allowAnonymousUsersToStartMeeting")
    protected Boolean allowAnonymousUsersToStartMeeting;

    protected MeetingCapability() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.meetingCapability";
    }

    @Property(name="allowAnonymousUsersToDialOut")
    @JsonIgnore
    public Optional<Boolean> getAllowAnonymousUsersToDialOut() {
        return Optional.ofNullable(allowAnonymousUsersToDialOut);
    }

    public MeetingCapability withAllowAnonymousUsersToDialOut(Boolean allowAnonymousUsersToDialOut) {
        MeetingCapability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingCapability");
        _x.allowAnonymousUsersToDialOut = allowAnonymousUsersToDialOut;
        return _x;
    }

    @Property(name="autoAdmittedUsers")
    @JsonIgnore
    public Optional<AutoAdmittedUsersType> getAutoAdmittedUsers() {
        return Optional.ofNullable(autoAdmittedUsers);
    }

    public MeetingCapability withAutoAdmittedUsers(AutoAdmittedUsersType autoAdmittedUsers) {
        MeetingCapability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingCapability");
        _x.autoAdmittedUsers = autoAdmittedUsers;
        return _x;
    }

    @Property(name="allowAnonymousUsersToStartMeeting")
    @JsonIgnore
    public Optional<Boolean> getAllowAnonymousUsersToStartMeeting() {
        return Optional.ofNullable(allowAnonymousUsersToStartMeeting);
    }

    public MeetingCapability withAllowAnonymousUsersToStartMeeting(Boolean allowAnonymousUsersToStartMeeting) {
        MeetingCapability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingCapability");
        _x.allowAnonymousUsersToStartMeeting = allowAnonymousUsersToStartMeeting;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowAnonymousUsersToDialOut;
        private AutoAdmittedUsersType autoAdmittedUsers;
        private Boolean allowAnonymousUsersToStartMeeting;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder allowAnonymousUsersToDialOut(Boolean allowAnonymousUsersToDialOut) {
            this.allowAnonymousUsersToDialOut = allowAnonymousUsersToDialOut;
            this.changedFields = changedFields.add("allowAnonymousUsersToDialOut");
            return this;
        }

        public Builder autoAdmittedUsers(AutoAdmittedUsersType autoAdmittedUsers) {
            this.autoAdmittedUsers = autoAdmittedUsers;
            this.changedFields = changedFields.add("autoAdmittedUsers");
            return this;
        }

        public Builder allowAnonymousUsersToStartMeeting(Boolean allowAnonymousUsersToStartMeeting) {
            this.allowAnonymousUsersToStartMeeting = allowAnonymousUsersToStartMeeting;
            this.changedFields = changedFields.add("allowAnonymousUsersToStartMeeting");
            return this;
        }

        public MeetingCapability build() {
            MeetingCapability _x = new MeetingCapability();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.meetingCapability";
            _x.allowAnonymousUsersToDialOut = allowAnonymousUsersToDialOut;
            _x.autoAdmittedUsers = autoAdmittedUsers;
            _x.allowAnonymousUsersToStartMeeting = allowAnonymousUsersToStartMeeting;
            return _x;
        }
    }

    private MeetingCapability _copy() {
        MeetingCapability _x = new MeetingCapability();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.allowAnonymousUsersToDialOut = allowAnonymousUsersToDialOut;
        _x.autoAdmittedUsers = autoAdmittedUsers;
        _x.allowAnonymousUsersToStartMeeting = allowAnonymousUsersToStartMeeting;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MeetingCapability[");
        b.append("allowAnonymousUsersToDialOut=");
        b.append(this.allowAnonymousUsersToDialOut);
        b.append(", ");
        b.append("autoAdmittedUsers=");
        b.append(this.autoAdmittedUsers);
        b.append(", ");
        b.append("allowAnonymousUsersToStartMeeting=");
        b.append(this.allowAnonymousUsersToStartMeeting);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
