package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.MediaDirection;
import odata.msgraph.client.beta.enums.Modality;

@JsonPropertyOrder({
    "@odata.type", 
    "mediaType", 
    "label", 
    "sourceId", 
    "direction", 
    "serverMuted"})
@JsonInclude(Include.NON_NULL)
public class MediaStream implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("mediaType")
    protected Modality mediaType;

    @JsonProperty("label")
    protected String label;

    @JsonProperty("sourceId")
    protected String sourceId;

    @JsonProperty("direction")
    protected MediaDirection direction;

    @JsonProperty("serverMuted")
    protected Boolean serverMuted;

    protected MediaStream() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mediaStream";
    }

    @Property(name="mediaType")
    @JsonIgnore
    public Optional<Modality> getMediaType() {
        return Optional.ofNullable(mediaType);
    }

    public MediaStream withMediaType(Modality mediaType) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaStream");
        _x.mediaType = mediaType;
        return _x;
    }

    @Property(name="label")
    @JsonIgnore
    public Optional<String> getLabel() {
        return Optional.ofNullable(label);
    }

    public MediaStream withLabel(String label) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaStream");
        _x.label = label;
        return _x;
    }

    @Property(name="sourceId")
    @JsonIgnore
    public Optional<String> getSourceId() {
        return Optional.ofNullable(sourceId);
    }

    public MediaStream withSourceId(String sourceId) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaStream");
        _x.sourceId = sourceId;
        return _x;
    }

    @Property(name="direction")
    @JsonIgnore
    public Optional<MediaDirection> getDirection() {
        return Optional.ofNullable(direction);
    }

    public MediaStream withDirection(MediaDirection direction) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaStream");
        _x.direction = direction;
        return _x;
    }

    @Property(name="serverMuted")
    @JsonIgnore
    public Optional<Boolean> getServerMuted() {
        return Optional.ofNullable(serverMuted);
    }

    public MediaStream withServerMuted(Boolean serverMuted) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaStream");
        _x.serverMuted = serverMuted;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Modality mediaType;
        private String label;
        private String sourceId;
        private MediaDirection direction;
        private Boolean serverMuted;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder mediaType(Modality mediaType) {
            this.mediaType = mediaType;
            this.changedFields = changedFields.add("mediaType");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            this.changedFields = changedFields.add("sourceId");
            return this;
        }

        public Builder direction(MediaDirection direction) {
            this.direction = direction;
            this.changedFields = changedFields.add("direction");
            return this;
        }

        public Builder serverMuted(Boolean serverMuted) {
            this.serverMuted = serverMuted;
            this.changedFields = changedFields.add("serverMuted");
            return this;
        }

        public MediaStream build() {
            MediaStream _x = new MediaStream();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mediaStream";
            _x.mediaType = mediaType;
            _x.label = label;
            _x.sourceId = sourceId;
            _x.direction = direction;
            _x.serverMuted = serverMuted;
            return _x;
        }
    }

    private MediaStream _copy() {
        MediaStream _x = new MediaStream();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.mediaType = mediaType;
        _x.label = label;
        _x.sourceId = sourceId;
        _x.direction = direction;
        _x.serverMuted = serverMuted;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MediaStream[");
        b.append("mediaType=");
        b.append(this.mediaType);
        b.append(", ");
        b.append("label=");
        b.append(this.label);
        b.append(", ");
        b.append("sourceId=");
        b.append(this.sourceId);
        b.append(", ");
        b.append("direction=");
        b.append(this.direction);
        b.append(", ");
        b.append("serverMuted=");
        b.append(this.serverMuted);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
