package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "mediaInfo", 
    "loop"})
@JsonInclude(Include.NON_NULL)
public class MediaPrompt extends Prompt implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("mediaInfo")
    protected MediaInfo mediaInfo;

    @JsonProperty("loop")
    protected Integer loop;

    protected MediaPrompt() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mediaPrompt";
    }

    @Property(name="mediaInfo")
    @JsonIgnore
    public Optional<MediaInfo> getMediaInfo() {
        return Optional.ofNullable(mediaInfo);
    }

    public MediaPrompt withMediaInfo(MediaInfo mediaInfo) {
        MediaPrompt _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaPrompt");
        _x.mediaInfo = mediaInfo;
        return _x;
    }

    @Property(name="loop")
    @JsonIgnore
    public Optional<Integer> getLoop() {
        return Optional.ofNullable(loop);
    }

    public MediaPrompt withLoop(Integer loop) {
        MediaPrompt _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaPrompt");
        _x.loop = loop;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMediaPrompt() {
        return new Builder();
    }

    public static final class Builder {
        private MediaInfo mediaInfo;
        private Integer loop;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder mediaInfo(MediaInfo mediaInfo) {
            this.mediaInfo = mediaInfo;
            this.changedFields = changedFields.add("mediaInfo");
            return this;
        }

        public Builder loop(Integer loop) {
            this.loop = loop;
            this.changedFields = changedFields.add("loop");
            return this;
        }

        public MediaPrompt build() {
            MediaPrompt _x = new MediaPrompt();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mediaPrompt";
            _x.mediaInfo = mediaInfo;
            _x.loop = loop;
            return _x;
        }
    }

    private MediaPrompt _copy() {
        MediaPrompt _x = new MediaPrompt();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.mediaInfo = mediaInfo;
        _x.loop = loop;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MediaPrompt[");
        b.append("mediaInfo=");
        b.append(this.mediaInfo);
        b.append(", ");
        b.append("loop=");
        b.append(this.loop);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
