package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.RatingIrelandMoviesType;
import odata.msgraph.client.beta.enums.RatingIrelandTelevisionType;

@JsonPropertyOrder({
    "@odata.type", 
    "movieRating", 
    "tvRating"})
@JsonInclude(Include.NON_NULL)
public class MediaContentRatingIreland implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("movieRating")
    protected RatingIrelandMoviesType movieRating;

    @JsonProperty("tvRating")
    protected RatingIrelandTelevisionType tvRating;

    protected MediaContentRatingIreland() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mediaContentRatingIreland";
    }

    /**
     * <i>“Movies rating selected for Ireland”</i>
     * 
     * @return property movieRating
     */
    @Property(name="movieRating")
    @JsonIgnore
    public Optional<RatingIrelandMoviesType> getMovieRating() {
        return Optional.ofNullable(movieRating);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code movieRating}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Movies rating selected for Ireland”</i>
     * 
     * @param movieRating
     *            new value of {@code movieRating} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code movieRating} field changed
     */
    public MediaContentRatingIreland withMovieRating(RatingIrelandMoviesType movieRating) {
        MediaContentRatingIreland _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaContentRatingIreland");
        _x.movieRating = movieRating;
        return _x;
    }

    /**
     * <i>“TV rating selected for Ireland”</i>
     * 
     * @return property tvRating
     */
    @Property(name="tvRating")
    @JsonIgnore
    public Optional<RatingIrelandTelevisionType> getTvRating() {
        return Optional.ofNullable(tvRating);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tvRating} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“TV rating selected for Ireland”</i>
     * 
     * @param tvRating
     *            new value of {@code tvRating} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tvRating} field changed
     */
    public MediaContentRatingIreland withTvRating(RatingIrelandTelevisionType tvRating) {
        MediaContentRatingIreland _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaContentRatingIreland");
        _x.tvRating = tvRating;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RatingIrelandMoviesType movieRating;
        private RatingIrelandTelevisionType tvRating;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Movies rating selected for Ireland”</i>
         * 
         * @param movieRating
         *            value of {@code movieRating} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder movieRating(RatingIrelandMoviesType movieRating) {
            this.movieRating = movieRating;
            this.changedFields = changedFields.add("movieRating");
            return this;
        }

        /**
         * <i>“TV rating selected for Ireland”</i>
         * 
         * @param tvRating
         *            value of {@code tvRating} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tvRating(RatingIrelandTelevisionType tvRating) {
            this.tvRating = tvRating;
            this.changedFields = changedFields.add("tvRating");
            return this;
        }

        public MediaContentRatingIreland build() {
            MediaContentRatingIreland _x = new MediaContentRatingIreland();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.mediaContentRatingIreland";
            _x.movieRating = movieRating;
            _x.tvRating = tvRating;
            return _x;
        }
    }

    private MediaContentRatingIreland _copy() {
        MediaContentRatingIreland _x = new MediaContentRatingIreland();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.movieRating = movieRating;
        _x.tvRating = tvRating;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MediaContentRatingIreland[");
        b.append("movieRating=");
        b.append(this.movieRating);
        b.append(", ");
        b.append("tvRating=");
        b.append(this.tvRating);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
