package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "removeFromDefaultAudioGroup"})
@JsonInclude(Include.NON_NULL)
public class MediaConfig implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("removeFromDefaultAudioGroup")
    protected Boolean removeFromDefaultAudioGroup;

    protected MediaConfig() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mediaConfig";
    }

    @Property(name="removeFromDefaultAudioGroup")
    @JsonIgnore
    public Optional<Boolean> getRemoveFromDefaultAudioGroup() {
        return Optional.ofNullable(removeFromDefaultAudioGroup);
    }

    public MediaConfig withRemoveFromDefaultAudioGroup(Boolean removeFromDefaultAudioGroup) {
        MediaConfig _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mediaConfig");
        _x.removeFromDefaultAudioGroup = removeFromDefaultAudioGroup;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private MediaConfig _copy() {
        MediaConfig _x = new MediaConfig();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.removeFromDefaultAudioGroup = removeFromDefaultAudioGroup;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MediaConfig[");
        b.append("removeFromDefaultAudioGroup=");
        b.append(this.removeFromDefaultAudioGroup);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
