package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ApplicationMode;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "name", 
    "displayName", 
    "description", 
    "toolTip", 
    "policyTip", 
    "isEndpointProtectionEnabled", 
    "applicationMode", 
    "labelActions", 
    "priority"})
@JsonInclude(Include.NON_NULL)
public class MatchingLabel implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("toolTip")
    protected String toolTip;

    @JsonProperty("policyTip")
    protected String policyTip;

    @JsonProperty("isEndpointProtectionEnabled")
    protected Boolean isEndpointProtectionEnabled;

    @JsonProperty("applicationMode")
    protected ApplicationMode applicationMode;

    @JsonProperty("labelActions")
    protected List<LabelActionBase> labelActions;

    @JsonProperty("labelActions@nextLink")
    protected String labelActionsNextLink;

    @JsonProperty("priority")
    protected Integer priority;

    protected MatchingLabel() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.matchingLabel";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public MatchingLabel withId(String id) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.id = id;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public MatchingLabel withName(String name) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.name = name;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public MatchingLabel withDisplayName(String displayName) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public MatchingLabel withDescription(String description) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.description = description;
        return _x;
    }

    @Property(name="toolTip")
    @JsonIgnore
    public Optional<String> getToolTip() {
        return Optional.ofNullable(toolTip);
    }

    public MatchingLabel withToolTip(String toolTip) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.toolTip = toolTip;
        return _x;
    }

    @Property(name="policyTip")
    @JsonIgnore
    public Optional<String> getPolicyTip() {
        return Optional.ofNullable(policyTip);
    }

    public MatchingLabel withPolicyTip(String policyTip) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.policyTip = policyTip;
        return _x;
    }

    @Property(name="isEndpointProtectionEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEndpointProtectionEnabled() {
        return Optional.ofNullable(isEndpointProtectionEnabled);
    }

    public MatchingLabel withIsEndpointProtectionEnabled(Boolean isEndpointProtectionEnabled) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.isEndpointProtectionEnabled = isEndpointProtectionEnabled;
        return _x;
    }

    @Property(name="applicationMode")
    @JsonIgnore
    public Optional<ApplicationMode> getApplicationMode() {
        return Optional.ofNullable(applicationMode);
    }

    public MatchingLabel withApplicationMode(ApplicationMode applicationMode) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.applicationMode = applicationMode;
        return _x;
    }

    @Property(name="labelActions")
    @JsonIgnore
    public CollectionPage<LabelActionBase> getLabelActions() {
        return new CollectionPage<LabelActionBase>(contextPath, LabelActionBase.class, labelActions, Optional.ofNullable(labelActionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="labelActions")
    @JsonIgnore
    public CollectionPage<LabelActionBase> getLabelActions(HttpRequestOptions options) {
        return new CollectionPage<LabelActionBase>(contextPath, LabelActionBase.class, labelActions, Optional.ofNullable(labelActionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public MatchingLabel withPriority(Integer priority) {
        MatchingLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingLabel");
        _x.priority = priority;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private String displayName;
        private String description;
        private String toolTip;
        private String policyTip;
        private Boolean isEndpointProtectionEnabled;
        private ApplicationMode applicationMode;
        private List<LabelActionBase> labelActions;
        private String labelActionsNextLink;
        private Integer priority;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder toolTip(String toolTip) {
            this.toolTip = toolTip;
            this.changedFields = changedFields.add("toolTip");
            return this;
        }

        public Builder policyTip(String policyTip) {
            this.policyTip = policyTip;
            this.changedFields = changedFields.add("policyTip");
            return this;
        }

        public Builder isEndpointProtectionEnabled(Boolean isEndpointProtectionEnabled) {
            this.isEndpointProtectionEnabled = isEndpointProtectionEnabled;
            this.changedFields = changedFields.add("isEndpointProtectionEnabled");
            return this;
        }

        public Builder applicationMode(ApplicationMode applicationMode) {
            this.applicationMode = applicationMode;
            this.changedFields = changedFields.add("applicationMode");
            return this;
        }

        public Builder labelActions(List<LabelActionBase> labelActions) {
            this.labelActions = labelActions;
            this.changedFields = changedFields.add("labelActions");
            return this;
        }

        public Builder labelActions(LabelActionBase... labelActions) {
            return labelActions(Arrays.asList(labelActions));
        }

        public Builder labelActionsNextLink(String labelActionsNextLink) {
            this.labelActionsNextLink = labelActionsNextLink;
            this.changedFields = changedFields.add("labelActions");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public MatchingLabel build() {
            MatchingLabel _x = new MatchingLabel();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.matchingLabel";
            _x.id = id;
            _x.name = name;
            _x.displayName = displayName;
            _x.description = description;
            _x.toolTip = toolTip;
            _x.policyTip = policyTip;
            _x.isEndpointProtectionEnabled = isEndpointProtectionEnabled;
            _x.applicationMode = applicationMode;
            _x.labelActions = labelActions;
            _x.labelActionsNextLink = labelActionsNextLink;
            _x.priority = priority;
            return _x;
        }
    }

    private MatchingLabel _copy() {
        MatchingLabel _x = new MatchingLabel();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.name = name;
        _x.displayName = displayName;
        _x.description = description;
        _x.toolTip = toolTip;
        _x.policyTip = policyTip;
        _x.isEndpointProtectionEnabled = isEndpointProtectionEnabled;
        _x.applicationMode = applicationMode;
        _x.labelActions = labelActions;
        _x.priority = priority;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MatchingLabel[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("toolTip=");
        b.append(this.toolTip);
        b.append(", ");
        b.append("policyTip=");
        b.append(this.policyTip);
        b.append(", ");
        b.append("isEndpointProtectionEnabled=");
        b.append(this.isEndpointProtectionEnabled);
        b.append(", ");
        b.append("applicationMode=");
        b.append(this.applicationMode);
        b.append(", ");
        b.append("labelActions=");
        b.append(this.labelActions);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
