package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RuleMode;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "ruleId", 
    "ruleName", 
    "policyId", 
    "policyName", 
    "isMostRestrictive", 
    "priority", 
    "actions", 
    "ruleMode"})
@JsonInclude(Include.NON_NULL)
public class MatchingDlpRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ruleId")
    protected String ruleId;

    @JsonProperty("ruleName")
    protected String ruleName;

    @JsonProperty("policyId")
    protected String policyId;

    @JsonProperty("policyName")
    protected String policyName;

    @JsonProperty("isMostRestrictive")
    protected Boolean isMostRestrictive;

    @JsonProperty("priority")
    protected Integer priority;

    @JsonProperty("actions")
    protected List<DlpActionInfo> actions;

    @JsonProperty("actions@nextLink")
    protected String actionsNextLink;

    @JsonProperty("ruleMode")
    protected RuleMode ruleMode;

    protected MatchingDlpRule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.matchingDlpRule";
    }

    @Property(name="ruleId")
    @JsonIgnore
    public Optional<String> getRuleId() {
        return Optional.ofNullable(ruleId);
    }

    public MatchingDlpRule withRuleId(String ruleId) {
        MatchingDlpRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingDlpRule");
        _x.ruleId = ruleId;
        return _x;
    }

    @Property(name="ruleName")
    @JsonIgnore
    public Optional<String> getRuleName() {
        return Optional.ofNullable(ruleName);
    }

    public MatchingDlpRule withRuleName(String ruleName) {
        MatchingDlpRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingDlpRule");
        _x.ruleName = ruleName;
        return _x;
    }

    @Property(name="policyId")
    @JsonIgnore
    public Optional<String> getPolicyId() {
        return Optional.ofNullable(policyId);
    }

    public MatchingDlpRule withPolicyId(String policyId) {
        MatchingDlpRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingDlpRule");
        _x.policyId = policyId;
        return _x;
    }

    @Property(name="policyName")
    @JsonIgnore
    public Optional<String> getPolicyName() {
        return Optional.ofNullable(policyName);
    }

    public MatchingDlpRule withPolicyName(String policyName) {
        MatchingDlpRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingDlpRule");
        _x.policyName = policyName;
        return _x;
    }

    @Property(name="isMostRestrictive")
    @JsonIgnore
    public Optional<Boolean> getIsMostRestrictive() {
        return Optional.ofNullable(isMostRestrictive);
    }

    public MatchingDlpRule withIsMostRestrictive(Boolean isMostRestrictive) {
        MatchingDlpRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingDlpRule");
        _x.isMostRestrictive = isMostRestrictive;
        return _x;
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public MatchingDlpRule withPriority(Integer priority) {
        MatchingDlpRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingDlpRule");
        _x.priority = priority;
        return _x;
    }

    @Property(name="actions")
    @JsonIgnore
    public CollectionPage<DlpActionInfo> getActions() {
        return new CollectionPage<DlpActionInfo>(contextPath, DlpActionInfo.class, actions, Optional.ofNullable(actionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="actions")
    @JsonIgnore
    public CollectionPage<DlpActionInfo> getActions(HttpRequestOptions options) {
        return new CollectionPage<DlpActionInfo>(contextPath, DlpActionInfo.class, actions, Optional.ofNullable(actionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="ruleMode")
    @JsonIgnore
    public Optional<RuleMode> getRuleMode() {
        return Optional.ofNullable(ruleMode);
    }

    public MatchingDlpRule withRuleMode(RuleMode ruleMode) {
        MatchingDlpRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.matchingDlpRule");
        _x.ruleMode = ruleMode;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String ruleId;
        private String ruleName;
        private String policyId;
        private String policyName;
        private Boolean isMostRestrictive;
        private Integer priority;
        private List<DlpActionInfo> actions;
        private String actionsNextLink;
        private RuleMode ruleMode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            this.changedFields = changedFields.add("ruleId");
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            this.changedFields = changedFields.add("ruleName");
            return this;
        }

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            this.changedFields = changedFields.add("policyId");
            return this;
        }

        public Builder policyName(String policyName) {
            this.policyName = policyName;
            this.changedFields = changedFields.add("policyName");
            return this;
        }

        public Builder isMostRestrictive(Boolean isMostRestrictive) {
            this.isMostRestrictive = isMostRestrictive;
            this.changedFields = changedFields.add("isMostRestrictive");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder actions(List<DlpActionInfo> actions) {
            this.actions = actions;
            this.changedFields = changedFields.add("actions");
            return this;
        }

        public Builder actions(DlpActionInfo... actions) {
            return actions(Arrays.asList(actions));
        }

        public Builder actionsNextLink(String actionsNextLink) {
            this.actionsNextLink = actionsNextLink;
            this.changedFields = changedFields.add("actions");
            return this;
        }

        public Builder ruleMode(RuleMode ruleMode) {
            this.ruleMode = ruleMode;
            this.changedFields = changedFields.add("ruleMode");
            return this;
        }

        public MatchingDlpRule build() {
            MatchingDlpRule _x = new MatchingDlpRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.matchingDlpRule";
            _x.ruleId = ruleId;
            _x.ruleName = ruleName;
            _x.policyId = policyId;
            _x.policyName = policyName;
            _x.isMostRestrictive = isMostRestrictive;
            _x.priority = priority;
            _x.actions = actions;
            _x.actionsNextLink = actionsNextLink;
            _x.ruleMode = ruleMode;
            return _x;
        }
    }

    private MatchingDlpRule _copy() {
        MatchingDlpRule _x = new MatchingDlpRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.ruleId = ruleId;
        _x.ruleName = ruleName;
        _x.policyId = policyId;
        _x.policyName = policyName;
        _x.isMostRestrictive = isMostRestrictive;
        _x.priority = priority;
        _x.actions = actions;
        _x.ruleMode = ruleMode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MatchingDlpRule[");
        b.append("ruleId=");
        b.append(this.ruleId);
        b.append(", ");
        b.append("ruleName=");
        b.append(this.ruleName);
        b.append(", ");
        b.append("policyId=");
        b.append(this.policyId);
        b.append(", ");
        b.append("policyName=");
        b.append(this.policyName);
        b.append(", ");
        b.append("isMostRestrictive=");
        b.append(this.isMostRestrictive);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("actions=");
        b.append(this.actions);
        b.append(", ");
        b.append("ruleMode=");
        b.append(this.ruleMode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
