package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "thumbprint", 
    "certificate"})
@JsonInclude(Include.NON_NULL)
public class ManagementCertificateWithThumbprint implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("thumbprint")
    protected String thumbprint;

    @JsonProperty("certificate")
    protected String certificate;

    protected ManagementCertificateWithThumbprint() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managementCertificateWithThumbprint";
    }

    /**
     * <i>“The thumbprint of the management certificate”</i>
     * 
     * @return property thumbprint
     */
    @Property(name="thumbprint")
    @JsonIgnore
    public Optional<String> getThumbprint() {
        return Optional.ofNullable(thumbprint);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code thumbprint} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The thumbprint of the management certificate”</i>
     * 
     * @param thumbprint
     *            new value of {@code thumbprint} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code thumbprint} field changed
     */
    public ManagementCertificateWithThumbprint withThumbprint(String thumbprint) {
        ManagementCertificateWithThumbprint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementCertificateWithThumbprint");
        _x.thumbprint = thumbprint;
        return _x;
    }

    /**
     * <i>“The Base 64 encoded management certificate”</i>
     * 
     * @return property certificate
     */
    @Property(name="certificate")
    @JsonIgnore
    public Optional<String> getCertificate() {
        return Optional.ofNullable(certificate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code certificate}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Base 64 encoded management certificate”</i>
     * 
     * @param certificate
     *            new value of {@code certificate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificate} field changed
     */
    public ManagementCertificateWithThumbprint withCertificate(String certificate) {
        ManagementCertificateWithThumbprint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementCertificateWithThumbprint");
        _x.certificate = certificate;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String thumbprint;
        private String certificate;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The thumbprint of the management certificate”</i>
         * 
         * @param thumbprint
         *            value of {@code thumbprint} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder thumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
            this.changedFields = changedFields.add("thumbprint");
            return this;
        }

        /**
         * <i>“The Base 64 encoded management certificate”</i>
         * 
         * @param certificate
         *            value of {@code certificate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificate(String certificate) {
            this.certificate = certificate;
            this.changedFields = changedFields.add("certificate");
            return this;
        }

        public ManagementCertificateWithThumbprint build() {
            ManagementCertificateWithThumbprint _x = new ManagementCertificateWithThumbprint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.managementCertificateWithThumbprint";
            _x.thumbprint = thumbprint;
            _x.certificate = certificate;
            return _x;
        }
    }

    private ManagementCertificateWithThumbprint _copy() {
        ManagementCertificateWithThumbprint _x = new ManagementCertificateWithThumbprint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.thumbprint = thumbprint;
        _x.certificate = certificate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagementCertificateWithThumbprint[");
        b.append("thumbprint=");
        b.append(this.thumbprint);
        b.append(", ");
        b.append("certificate=");
        b.append(this.certificate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
