package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.RunState;


/**
 * <i>“Event representing a user's devices with failed or pending apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "summarizedAppState", 
    "deviceId"})
@JsonInclude(Include.NON_NULL)
public class ManagedDeviceSummarizedAppState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("summarizedAppState")
    protected RunState summarizedAppState;

    @JsonProperty("deviceId")
    protected String deviceId;

    protected ManagedDeviceSummarizedAppState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedDeviceSummarizedAppState";
    }

    /**
     * <i>“runState for the object”</i>
     * 
     * @return property summarizedAppState
     */
    @Property(name="summarizedAppState")
    @JsonIgnore
    public Optional<RunState> getSummarizedAppState() {
        return Optional.ofNullable(summarizedAppState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * summarizedAppState} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“runState for the object”</i>
     * 
     * @param summarizedAppState
     *            new value of {@code summarizedAppState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code summarizedAppState} field changed
     */
    public ManagedDeviceSummarizedAppState withSummarizedAppState(RunState summarizedAppState) {
        ManagedDeviceSummarizedAppState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceSummarizedAppState");
        _x.summarizedAppState = summarizedAppState;
        return _x;
    }

    /**
     * <i>“DeviceId of device represented by this object”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“DeviceId of device represented by this object”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public ManagedDeviceSummarizedAppState withDeviceId(String deviceId) {
        ManagedDeviceSummarizedAppState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceSummarizedAppState");
        _x.deviceId = deviceId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RunState summarizedAppState;
        private String deviceId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“runState for the object”</i>
         * 
         * @param summarizedAppState
         *            value of {@code summarizedAppState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder summarizedAppState(RunState summarizedAppState) {
            this.summarizedAppState = summarizedAppState;
            this.changedFields = changedFields.add("summarizedAppState");
            return this;
        }

        /**
         * <i>“DeviceId of device represented by this object”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        public ManagedDeviceSummarizedAppState build() {
            ManagedDeviceSummarizedAppState _x = new ManagedDeviceSummarizedAppState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.managedDeviceSummarizedAppState";
            _x.summarizedAppState = summarizedAppState;
            _x.deviceId = deviceId;
            return _x;
        }
    }

    private ManagedDeviceSummarizedAppState _copy() {
        ManagedDeviceSummarizedAppState _x = new ManagedDeviceSummarizedAppState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.summarizedAppState = summarizedAppState;
        _x.deviceId = deviceId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDeviceSummarizedAppState[");
        b.append("summarizedAppState=");
        b.append(this.summarizedAppState);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
