package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Models and Manufactures meatadata for managed devices in the account”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceModels", 
    "deviceManufacturers"})
@JsonInclude(Include.NON_NULL)
public class ManagedDeviceModelsAndManufacturers implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceModels")
    protected List<String> deviceModels;

    @JsonProperty("deviceModels@nextLink")
    protected String deviceModelsNextLink;

    @JsonProperty("deviceManufacturers")
    protected List<String> deviceManufacturers;

    @JsonProperty("deviceManufacturers@nextLink")
    protected String deviceManufacturersNextLink;

    protected ManagedDeviceModelsAndManufacturers() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedDeviceModelsAndManufacturers";
    }

    /**
     * <i>“List of Models for managed devices in the account”</i>
     * 
     * @return property deviceModels
     */
    @Property(name="deviceModels")
    @JsonIgnore
    public CollectionPage<String> getDeviceModels() {
        return new CollectionPage<String>(contextPath, String.class, deviceModels, Optional.ofNullable(deviceModelsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Models for managed devices in the account”</i>
     * 
     * @return property deviceModels
     */
    @Property(name="deviceModels")
    @JsonIgnore
    public CollectionPage<String> getDeviceModels(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, deviceModels, Optional.ofNullable(deviceModelsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“List of Manufactures for managed devices in the account”</i>
     * 
     * @return property deviceManufacturers
     */
    @Property(name="deviceManufacturers")
    @JsonIgnore
    public CollectionPage<String> getDeviceManufacturers() {
        return new CollectionPage<String>(contextPath, String.class, deviceManufacturers, Optional.ofNullable(deviceManufacturersNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Manufactures for managed devices in the account”</i>
     * 
     * @return property deviceManufacturers
     */
    @Property(name="deviceManufacturers")
    @JsonIgnore
    public CollectionPage<String> getDeviceManufacturers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, deviceManufacturers, Optional.ofNullable(deviceManufacturersNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> deviceModels;
        private String deviceModelsNextLink;
        private List<String> deviceManufacturers;
        private String deviceManufacturersNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“List of Models for managed devices in the account”</i>
         * 
         * @param deviceModels
         *            value of {@code deviceModels} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceModels(List<String> deviceModels) {
            this.deviceModels = deviceModels;
            this.changedFields = changedFields.add("deviceModels");
            return this;
        }

        /**
         * <i>“List of Models for managed devices in the account”</i>
         * 
         * @param deviceModels
         *            value of {@code deviceModels} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceModels(String... deviceModels) {
            return deviceModels(Arrays.asList(deviceModels));
        }

        /**
         * <i>“List of Models for managed devices in the account”</i>
         * 
         * @param deviceModelsNextLink
         *            value of {@code deviceModels@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceModelsNextLink(String deviceModelsNextLink) {
            this.deviceModelsNextLink = deviceModelsNextLink;
            this.changedFields = changedFields.add("deviceModels");
            return this;
        }

        /**
         * <i>“List of Manufactures for managed devices in the account”</i>
         * 
         * @param deviceManufacturers
         *            value of {@code deviceManufacturers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManufacturers(List<String> deviceManufacturers) {
            this.deviceManufacturers = deviceManufacturers;
            this.changedFields = changedFields.add("deviceManufacturers");
            return this;
        }

        /**
         * <i>“List of Manufactures for managed devices in the account”</i>
         * 
         * @param deviceManufacturers
         *            value of {@code deviceManufacturers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManufacturers(String... deviceManufacturers) {
            return deviceManufacturers(Arrays.asList(deviceManufacturers));
        }

        /**
         * <i>“List of Manufactures for managed devices in the account”</i>
         * 
         * @param deviceManufacturersNextLink
         *            value of {@code deviceManufacturers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceManufacturersNextLink(String deviceManufacturersNextLink) {
            this.deviceManufacturersNextLink = deviceManufacturersNextLink;
            this.changedFields = changedFields.add("deviceManufacturers");
            return this;
        }

        public ManagedDeviceModelsAndManufacturers build() {
            ManagedDeviceModelsAndManufacturers _x = new ManagedDeviceModelsAndManufacturers();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.managedDeviceModelsAndManufacturers";
            _x.deviceModels = deviceModels;
            _x.deviceModelsNextLink = deviceModelsNextLink;
            _x.deviceManufacturers = deviceManufacturers;
            _x.deviceManufacturersNextLink = deviceManufacturersNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDeviceModelsAndManufacturers[");
        b.append("deviceModels=");
        b.append(this.deviceModels);
        b.append(", ");
        b.append("deviceManufacturers=");
        b.append(this.deviceManufacturers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
