package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Define the rule when the admin wants the devices to be cleaned up.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceInactivityBeforeRetirementInDays"})
@JsonInclude(Include.NON_NULL)
public class ManagedDeviceCleanupSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceInactivityBeforeRetirementInDays")
    protected String deviceInactivityBeforeRetirementInDays;

    protected ManagedDeviceCleanupSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedDeviceCleanupSettings";
    }

    /**
     * <i>“Number of days when the device has not contacted Intune.”</i>
     * 
     * @return property deviceInactivityBeforeRetirementInDays
     */
    @Property(name="deviceInactivityBeforeRetirementInDays")
    @JsonIgnore
    public Optional<String> getDeviceInactivityBeforeRetirementInDays() {
        return Optional.ofNullable(deviceInactivityBeforeRetirementInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceInactivityBeforeRetirementInDays} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Number of days when the device has not contacted Intune.”</i>
     * 
     * @param deviceInactivityBeforeRetirementInDays
     *            new value of {@code deviceInactivityBeforeRetirementInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceInactivityBeforeRetirementInDays} field changed
     */
    public ManagedDeviceCleanupSettings withDeviceInactivityBeforeRetirementInDays(String deviceInactivityBeforeRetirementInDays) {
        ManagedDeviceCleanupSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceCleanupSettings");
        _x.deviceInactivityBeforeRetirementInDays = deviceInactivityBeforeRetirementInDays;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String deviceInactivityBeforeRetirementInDays;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Number of days when the device has not contacted Intune.”</i>
         * 
         * @param deviceInactivityBeforeRetirementInDays
         *            value of {@code deviceInactivityBeforeRetirementInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceInactivityBeforeRetirementInDays(String deviceInactivityBeforeRetirementInDays) {
            this.deviceInactivityBeforeRetirementInDays = deviceInactivityBeforeRetirementInDays;
            this.changedFields = changedFields.add("deviceInactivityBeforeRetirementInDays");
            return this;
        }

        public ManagedDeviceCleanupSettings build() {
            ManagedDeviceCleanupSettings _x = new ManagedDeviceCleanupSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.managedDeviceCleanupSettings";
            _x.deviceInactivityBeforeRetirementInDays = deviceInactivityBeforeRetirementInDays;
            return _x;
        }
    }

    private ManagedDeviceCleanupSettings _copy() {
        ManagedDeviceCleanupSettings _x = new ManagedDeviceCleanupSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.deviceInactivityBeforeRetirementInDays = deviceInactivityBeforeRetirementInDays;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDeviceCleanupSettings[");
        b.append("deviceInactivityBeforeRetirementInDays=");
        b.append(this.deviceInactivityBeforeRetirementInDays);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
