package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Represents policy deployment summary per app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "mobileAppIdentifier", 
    "configurationAppliedUserCount"})
@JsonInclude(Include.NON_NULL)
public class ManagedAppPolicyDeploymentSummaryPerApp implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("mobileAppIdentifier")
    protected MobileAppIdentifier mobileAppIdentifier;

    @JsonProperty("configurationAppliedUserCount")
    protected Integer configurationAppliedUserCount;

    protected ManagedAppPolicyDeploymentSummaryPerApp() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedAppPolicyDeploymentSummaryPerApp";
    }

    /**
     * <i>“Deployment of an app.”</i>
     * 
     * @return property mobileAppIdentifier
     */
    @Property(name="mobileAppIdentifier")
    @JsonIgnore
    public Optional<MobileAppIdentifier> getMobileAppIdentifier() {
        return Optional.ofNullable(mobileAppIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mobileAppIdentifier} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Deployment of an app.”</i>
     * 
     * @param mobileAppIdentifier
     *            new value of {@code mobileAppIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileAppIdentifier} field changed
     */
    public ManagedAppPolicyDeploymentSummaryPerApp withMobileAppIdentifier(MobileAppIdentifier mobileAppIdentifier) {
        ManagedAppPolicyDeploymentSummaryPerApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppPolicyDeploymentSummaryPerApp");
        _x.mobileAppIdentifier = mobileAppIdentifier;
        return _x;
    }

    /**
     * <i>“Number of users the policy is applied.”</i>
     * 
     * @return property configurationAppliedUserCount
     */
    @Property(name="configurationAppliedUserCount")
    @JsonIgnore
    public Optional<Integer> getConfigurationAppliedUserCount() {
        return Optional.ofNullable(configurationAppliedUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationAppliedUserCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of users the policy is applied.”</i>
     * 
     * @param configurationAppliedUserCount
     *            new value of {@code configurationAppliedUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationAppliedUserCount} field changed
     */
    public ManagedAppPolicyDeploymentSummaryPerApp withConfigurationAppliedUserCount(Integer configurationAppliedUserCount) {
        ManagedAppPolicyDeploymentSummaryPerApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppPolicyDeploymentSummaryPerApp");
        _x.configurationAppliedUserCount = configurationAppliedUserCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private MobileAppIdentifier mobileAppIdentifier;
        private Integer configurationAppliedUserCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Deployment of an app.”</i>
         * 
         * @param mobileAppIdentifier
         *            value of {@code mobileAppIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppIdentifier(MobileAppIdentifier mobileAppIdentifier) {
            this.mobileAppIdentifier = mobileAppIdentifier;
            this.changedFields = changedFields.add("mobileAppIdentifier");
            return this;
        }

        /**
         * <i>“Number of users the policy is applied.”</i>
         * 
         * @param configurationAppliedUserCount
         *            value of {@code configurationAppliedUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationAppliedUserCount(Integer configurationAppliedUserCount) {
            this.configurationAppliedUserCount = configurationAppliedUserCount;
            this.changedFields = changedFields.add("configurationAppliedUserCount");
            return this;
        }

        public ManagedAppPolicyDeploymentSummaryPerApp build() {
            ManagedAppPolicyDeploymentSummaryPerApp _x = new ManagedAppPolicyDeploymentSummaryPerApp();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.managedAppPolicyDeploymentSummaryPerApp";
            _x.mobileAppIdentifier = mobileAppIdentifier;
            _x.configurationAppliedUserCount = configurationAppliedUserCount;
            return _x;
        }
    }

    private ManagedAppPolicyDeploymentSummaryPerApp _copy() {
        ManagedAppPolicyDeploymentSummaryPerApp _x = new ManagedAppPolicyDeploymentSummaryPerApp();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.mobileAppIdentifier = mobileAppIdentifier;
        _x.configurationAppliedUserCount = configurationAppliedUserCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedAppPolicyDeploymentSummaryPerApp[");
        b.append("mobileAppIdentifier=");
        b.append(this.mobileAppIdentifier);
        b.append(", ");
        b.append("configurationAppliedUserCount=");
        b.append(this.configurationAppliedUserCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
