package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Represents diagnostics status.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "validationName", 
    "state", 
    "mitigationInstruction"})
@JsonInclude(Include.NON_NULL)
public class ManagedAppDiagnosticStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("validationName")
    protected String validationName;

    @JsonProperty("state")
    protected String state;

    @JsonProperty("mitigationInstruction")
    protected String mitigationInstruction;

    protected ManagedAppDiagnosticStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedAppDiagnosticStatus";
    }

    /**
     * <i>“The validation friendly name”</i>
     * 
     * @return property validationName
     */
    @Property(name="validationName")
    @JsonIgnore
    public Optional<String> getValidationName() {
        return Optional.ofNullable(validationName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code validationName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The validation friendly name”</i>
     * 
     * @param validationName
     *            new value of {@code validationName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code validationName} field changed
     */
    public ManagedAppDiagnosticStatus withValidationName(String validationName) {
        ManagedAppDiagnosticStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppDiagnosticStatus");
        _x.validationName = validationName;
        return _x;
    }

    /**
     * <i>“The state of the operation”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The state of the operation”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public ManagedAppDiagnosticStatus withState(String state) {
        ManagedAppDiagnosticStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppDiagnosticStatus");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“Instruction on how to mitigate a failed validation”</i>
     * 
     * @return property mitigationInstruction
     */
    @Property(name="mitigationInstruction")
    @JsonIgnore
    public Optional<String> getMitigationInstruction() {
        return Optional.ofNullable(mitigationInstruction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mitigationInstruction} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Instruction on how to mitigate a failed validation”</i>
     * 
     * @param mitigationInstruction
     *            new value of {@code mitigationInstruction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mitigationInstruction} field changed
     */
    public ManagedAppDiagnosticStatus withMitigationInstruction(String mitigationInstruction) {
        ManagedAppDiagnosticStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppDiagnosticStatus");
        _x.mitigationInstruction = mitigationInstruction;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String validationName;
        private String state;
        private String mitigationInstruction;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The validation friendly name”</i>
         * 
         * @param validationName
         *            value of {@code validationName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder validationName(String validationName) {
            this.validationName = validationName;
            this.changedFields = changedFields.add("validationName");
            return this;
        }

        /**
         * <i>“The state of the operation”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“Instruction on how to mitigate a failed validation”</i>
         * 
         * @param mitigationInstruction
         *            value of {@code mitigationInstruction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mitigationInstruction(String mitigationInstruction) {
            this.mitigationInstruction = mitigationInstruction;
            this.changedFields = changedFields.add("mitigationInstruction");
            return this;
        }

        public ManagedAppDiagnosticStatus build() {
            ManagedAppDiagnosticStatus _x = new ManagedAppDiagnosticStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.managedAppDiagnosticStatus";
            _x.validationName = validationName;
            _x.state = state;
            _x.mitigationInstruction = mitigationInstruction;
            return _x;
        }
    }

    private ManagedAppDiagnosticStatus _copy() {
        ManagedAppDiagnosticStatus _x = new ManagedAppDiagnosticStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.validationName = validationName;
        _x.state = state;
        _x.mitigationInstruction = mitigationInstruction;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedAppDiagnosticStatus[");
        b.append("validationName=");
        b.append(this.validationName);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("mitigationInstruction=");
        b.append(this.mitigationInstruction);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
