package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Represents a Redirect-type Single Sign-On extension profile for macOS devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "extensionIdentifier", 
    "teamIdentifier", 
    "configurations", 
    "urlPrefixes"})
@JsonInclude(Include.NON_NULL)
public class MacOSRedirectSingleSignOnExtension extends MacOSSingleSignOnExtension implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("extensionIdentifier")
    protected String extensionIdentifier;

    @JsonProperty("teamIdentifier")
    protected String teamIdentifier;

    @JsonProperty("configurations")
    protected List<KeyTypedValuePair> configurations;

    @JsonProperty("configurations@nextLink")
    protected String configurationsNextLink;

    @JsonProperty("urlPrefixes")
    protected List<String> urlPrefixes;

    @JsonProperty("urlPrefixes@nextLink")
    protected String urlPrefixesNextLink;

    protected MacOSRedirectSingleSignOnExtension() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSRedirectSingleSignOnExtension";
    }

    /**
     * <i>“Gets or sets the bundle ID of the app extension that performs SSO for the
     * specified URLs.”</i>
     * 
     * @return property extensionIdentifier
     */
    @Property(name="extensionIdentifier")
    @JsonIgnore
    public Optional<String> getExtensionIdentifier() {
        return Optional.ofNullable(extensionIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * extensionIdentifier} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Gets or sets the bundle ID of the app extension that performs SSO for the
     * specified URLs.”</i>
     * 
     * @param extensionIdentifier
     *            new value of {@code extensionIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code extensionIdentifier} field changed
     */
    public MacOSRedirectSingleSignOnExtension withExtensionIdentifier(String extensionIdentifier) {
        MacOSRedirectSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSRedirectSingleSignOnExtension");
        _x.extensionIdentifier = extensionIdentifier;
        return _x;
    }

    /**
     * <i>“Gets or sets the team ID of the app extension that performs SSO for the
     * specified URLs.”</i>
     * 
     * @return property teamIdentifier
     */
    @Property(name="teamIdentifier")
    @JsonIgnore
    public Optional<String> getTeamIdentifier() {
        return Optional.ofNullable(teamIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code teamIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Gets or sets the team ID of the app extension that performs SSO for the
     * specified URLs.”</i>
     * 
     * @param teamIdentifier
     *            new value of {@code teamIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code teamIdentifier} field changed
     */
    public MacOSRedirectSingleSignOnExtension withTeamIdentifier(String teamIdentifier) {
        MacOSRedirectSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSRedirectSingleSignOnExtension");
        _x.teamIdentifier = teamIdentifier;
        return _x;
    }

    /**
     * <i>“Gets or sets a list of typed key-value pairs used to configure Credential-type
     * profiles. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property configurations
     */
    @Property(name="configurations")
    @JsonIgnore
    public CollectionPage<KeyTypedValuePair> getConfigurations() {
        return new CollectionPage<KeyTypedValuePair>(contextPath, KeyTypedValuePair.class, configurations, Optional.ofNullable(configurationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Gets or sets a list of typed key-value pairs used to configure Credential-type
     * profiles. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property configurations
     */
    @Property(name="configurations")
    @JsonIgnore
    public CollectionPage<KeyTypedValuePair> getConfigurations(HttpRequestOptions options) {
        return new CollectionPage<KeyTypedValuePair>(contextPath, KeyTypedValuePair.class, configurations, Optional.ofNullable(configurationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“One or more URL prefixes of identity providers on whose behalf the app extension
     * performs single sign-on. URLs must begin with http:// or https://. All URL
     * prefixes must be unique for all profiles.”</i>
     * 
     * @return property urlPrefixes
     */
    @Property(name="urlPrefixes")
    @JsonIgnore
    public CollectionPage<String> getUrlPrefixes() {
        return new CollectionPage<String>(contextPath, String.class, urlPrefixes, Optional.ofNullable(urlPrefixesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“One or more URL prefixes of identity providers on whose behalf the app extension
     * performs single sign-on. URLs must begin with http:// or https://. All URL
     * prefixes must be unique for all profiles.”</i>
     * 
     * @return property urlPrefixes
     */
    @Property(name="urlPrefixes")
    @JsonIgnore
    public CollectionPage<String> getUrlPrefixes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, urlPrefixes, Optional.ofNullable(urlPrefixesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMacOSRedirectSingleSignOnExtension() {
        return new Builder();
    }

    public static final class Builder {
        private String extensionIdentifier;
        private String teamIdentifier;
        private List<KeyTypedValuePair> configurations;
        private String configurationsNextLink;
        private List<String> urlPrefixes;
        private String urlPrefixesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Gets or sets the bundle ID of the app extension that performs SSO for the
         * specified URLs.”</i>
         * 
         * @param extensionIdentifier
         *            value of {@code extensionIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder extensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
            this.changedFields = changedFields.add("extensionIdentifier");
            return this;
        }

        /**
         * <i>“Gets or sets the team ID of the app extension that performs SSO for the
         * specified URLs.”</i>
         * 
         * @param teamIdentifier
         *            value of {@code teamIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder teamIdentifier(String teamIdentifier) {
            this.teamIdentifier = teamIdentifier;
            this.changedFields = changedFields.add("teamIdentifier");
            return this;
        }

        /**
         * <i>“Gets or sets a list of typed key-value pairs used to configure Credential-type
         * profiles. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param configurations
         *            value of {@code configurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurations(List<KeyTypedValuePair> configurations) {
            this.configurations = configurations;
            this.changedFields = changedFields.add("configurations");
            return this;
        }

        /**
         * <i>“Gets or sets a list of typed key-value pairs used to configure Credential-type
         * profiles. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param configurations
         *            value of {@code configurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurations(KeyTypedValuePair... configurations) {
            return configurations(Arrays.asList(configurations));
        }

        /**
         * <i>“Gets or sets a list of typed key-value pairs used to configure Credential-type
         * profiles. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param configurationsNextLink
         *            value of {@code configurations@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationsNextLink(String configurationsNextLink) {
            this.configurationsNextLink = configurationsNextLink;
            this.changedFields = changedFields.add("configurations");
            return this;
        }

        /**
         * <i>“One or more URL prefixes of identity providers on whose behalf the app extension
         * performs single sign-on. URLs must begin with http:// or https://. All URL
         * prefixes must be unique for all profiles.”</i>
         * 
         * @param urlPrefixes
         *            value of {@code urlPrefixes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder urlPrefixes(List<String> urlPrefixes) {
            this.urlPrefixes = urlPrefixes;
            this.changedFields = changedFields.add("urlPrefixes");
            return this;
        }

        /**
         * <i>“One or more URL prefixes of identity providers on whose behalf the app extension
         * performs single sign-on. URLs must begin with http:// or https://. All URL
         * prefixes must be unique for all profiles.”</i>
         * 
         * @param urlPrefixes
         *            value of {@code urlPrefixes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder urlPrefixes(String... urlPrefixes) {
            return urlPrefixes(Arrays.asList(urlPrefixes));
        }

        /**
         * <i>“One or more URL prefixes of identity providers on whose behalf the app extension
         * performs single sign-on. URLs must begin with http:// or https://. All URL
         * prefixes must be unique for all profiles.”</i>
         * 
         * @param urlPrefixesNextLink
         *            value of {@code urlPrefixes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder urlPrefixesNextLink(String urlPrefixesNextLink) {
            this.urlPrefixesNextLink = urlPrefixesNextLink;
            this.changedFields = changedFields.add("urlPrefixes");
            return this;
        }

        public MacOSRedirectSingleSignOnExtension build() {
            MacOSRedirectSingleSignOnExtension _x = new MacOSRedirectSingleSignOnExtension();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.macOSRedirectSingleSignOnExtension";
            _x.extensionIdentifier = extensionIdentifier;
            _x.teamIdentifier = teamIdentifier;
            _x.configurations = configurations;
            _x.configurationsNextLink = configurationsNextLink;
            _x.urlPrefixes = urlPrefixes;
            _x.urlPrefixesNextLink = urlPrefixesNextLink;
            return _x;
        }
    }

    private MacOSRedirectSingleSignOnExtension _copy() {
        MacOSRedirectSingleSignOnExtension _x = new MacOSRedirectSingleSignOnExtension();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.extensionIdentifier = extensionIdentifier;
        _x.teamIdentifier = teamIdentifier;
        _x.configurations = configurations;
        _x.urlPrefixes = urlPrefixes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSRedirectSingleSignOnExtension[");
        b.append("extensionIdentifier=");
        b.append(this.extensionIdentifier);
        b.append(", ");
        b.append("teamIdentifier=");
        b.append(this.teamIdentifier);
        b.append(", ");
        b.append("configurations=");
        b.append(this.configurations);
        b.append(", ");
        b.append("urlPrefixes=");
        b.append(this.urlPrefixes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
