package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.Enablement;
import odata.msgraph.client.beta.enums.MacOSProcessIdentifierType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Represents per-process privacy preferences.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "identifier", 
    "identifierType", 
    "codeRequirement", 
    "staticCodeValidation", 
    "blockCamera", 
    "blockMicrophone", 
    "blockScreenCapture", 
    "blockListenEvent", 
    "speechRecognition", 
    "accessibility", 
    "addressBook", 
    "calendar", 
    "reminders", 
    "photos", 
    "mediaLibrary", 
    "fileProviderPresence", 
    "systemPolicyAllFiles", 
    "systemPolicySystemAdminFiles", 
    "systemPolicyDesktopFolder", 
    "systemPolicyDocumentsFolder", 
    "systemPolicyDownloadsFolder", 
    "systemPolicyNetworkVolumes", 
    "systemPolicyRemovableVolumes", 
    "postEvent", 
    "appleEventsAllowedReceivers"})
@JsonInclude(Include.NON_NULL)
public class MacOSPrivacyAccessControlItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("identifier")
    protected String identifier;

    @JsonProperty("identifierType")
    protected MacOSProcessIdentifierType identifierType;

    @JsonProperty("codeRequirement")
    protected String codeRequirement;

    @JsonProperty("staticCodeValidation")
    protected Boolean staticCodeValidation;

    @JsonProperty("blockCamera")
    protected Boolean blockCamera;

    @JsonProperty("blockMicrophone")
    protected Boolean blockMicrophone;

    @JsonProperty("blockScreenCapture")
    protected Boolean blockScreenCapture;

    @JsonProperty("blockListenEvent")
    protected Boolean blockListenEvent;

    @JsonProperty("speechRecognition")
    protected Enablement speechRecognition;

    @JsonProperty("accessibility")
    protected Enablement accessibility;

    @JsonProperty("addressBook")
    protected Enablement addressBook;

    @JsonProperty("calendar")
    protected Enablement calendar;

    @JsonProperty("reminders")
    protected Enablement reminders;

    @JsonProperty("photos")
    protected Enablement photos;

    @JsonProperty("mediaLibrary")
    protected Enablement mediaLibrary;

    @JsonProperty("fileProviderPresence")
    protected Enablement fileProviderPresence;

    @JsonProperty("systemPolicyAllFiles")
    protected Enablement systemPolicyAllFiles;

    @JsonProperty("systemPolicySystemAdminFiles")
    protected Enablement systemPolicySystemAdminFiles;

    @JsonProperty("systemPolicyDesktopFolder")
    protected Enablement systemPolicyDesktopFolder;

    @JsonProperty("systemPolicyDocumentsFolder")
    protected Enablement systemPolicyDocumentsFolder;

    @JsonProperty("systemPolicyDownloadsFolder")
    protected Enablement systemPolicyDownloadsFolder;

    @JsonProperty("systemPolicyNetworkVolumes")
    protected Enablement systemPolicyNetworkVolumes;

    @JsonProperty("systemPolicyRemovableVolumes")
    protected Enablement systemPolicyRemovableVolumes;

    @JsonProperty("postEvent")
    protected Enablement postEvent;

    @JsonProperty("appleEventsAllowedReceivers")
    protected List<MacOSAppleEventReceiver> appleEventsAllowedReceivers;

    @JsonProperty("appleEventsAllowedReceivers@nextLink")
    protected String appleEventsAllowedReceiversNextLink;

    protected MacOSPrivacyAccessControlItem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSPrivacyAccessControlItem";
    }

    /**
     * <i>“The display name of the app, process, or executable.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display name of the app, process, or executable.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public MacOSPrivacyAccessControlItem withDisplayName(String displayName) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The bundle ID or path of the app, process, or executable.”</i>
     * 
     * @return property identifier
     */
    @Property(name="identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code identifier} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The bundle ID or path of the app, process, or executable.”</i>
     * 
     * @param identifier
     *            new value of {@code identifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code identifier} field changed
     */
    public MacOSPrivacyAccessControlItem withIdentifier(String identifier) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.identifier = identifier;
        return _x;
    }

    /**
     * <i>“A bundle ID is used to identify an app. A path is used to identify a process or
     * executable.”</i>
     * 
     * @return property identifierType
     */
    @Property(name="identifierType")
    @JsonIgnore
    public Optional<MacOSProcessIdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code identifierType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“A bundle ID is used to identify an app. A path is used to identify a process or
     * executable.”</i>
     * 
     * @param identifierType
     *            new value of {@code identifierType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code identifierType} field changed
     */
    public MacOSPrivacyAccessControlItem withIdentifierType(MacOSProcessIdentifierType identifierType) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.identifierType = identifierType;
        return _x;
    }

    /**
     * <i>“Enter the code requirement, which can be obtained with the command 'codesign
     * –display -r –' in the Terminal app. Include everything after '=&amp;gt;'.”</i>
     * 
     * @return property codeRequirement
     */
    @Property(name="codeRequirement")
    @JsonIgnore
    public Optional<String> getCodeRequirement() {
        return Optional.ofNullable(codeRequirement);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code codeRequirement}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Enter the code requirement, which can be obtained with the command 'codesign
     * –display -r –' in the Terminal app. Include everything after '=&amp;gt;'.”</i>
     * 
     * @param codeRequirement
     *            new value of {@code codeRequirement} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code codeRequirement} field changed
     */
    public MacOSPrivacyAccessControlItem withCodeRequirement(String codeRequirement) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.codeRequirement = codeRequirement;
        return _x;
    }

    /**
     * <i>“Statically validates the code requirement. Use this setting if the process
     * invalidates its dynamic code signature.”</i>
     * 
     * @return property staticCodeValidation
     */
    @Property(name="staticCodeValidation")
    @JsonIgnore
    public Optional<Boolean> getStaticCodeValidation() {
        return Optional.ofNullable(staticCodeValidation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * staticCodeValidation} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Statically validates the code requirement. Use this setting if the process
     * invalidates its dynamic code signature.”</i>
     * 
     * @param staticCodeValidation
     *            new value of {@code staticCodeValidation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code staticCodeValidation} field changed
     */
    public MacOSPrivacyAccessControlItem withStaticCodeValidation(Boolean staticCodeValidation) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.staticCodeValidation = staticCodeValidation;
        return _x;
    }

    /**
     * <i>“Block access to camera app.”</i>
     * 
     * @return property blockCamera
     */
    @Property(name="blockCamera")
    @JsonIgnore
    public Optional<Boolean> getBlockCamera() {
        return Optional.ofNullable(blockCamera);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code blockCamera}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Block access to camera app.”</i>
     * 
     * @param blockCamera
     *            new value of {@code blockCamera} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockCamera} field changed
     */
    public MacOSPrivacyAccessControlItem withBlockCamera(Boolean blockCamera) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.blockCamera = blockCamera;
        return _x;
    }

    /**
     * <i>“Block access to microphone.”</i>
     * 
     * @return property blockMicrophone
     */
    @Property(name="blockMicrophone")
    @JsonIgnore
    public Optional<Boolean> getBlockMicrophone() {
        return Optional.ofNullable(blockMicrophone);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code blockMicrophone}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Block access to microphone.”</i>
     * 
     * @param blockMicrophone
     *            new value of {@code blockMicrophone} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockMicrophone} field changed
     */
    public MacOSPrivacyAccessControlItem withBlockMicrophone(Boolean blockMicrophone) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.blockMicrophone = blockMicrophone;
        return _x;
    }

    /**
     * <i>“Block app from capturing contents of system display. Requires macOS 10.15 or
     * later.”</i>
     * 
     * @return property blockScreenCapture
     */
    @Property(name="blockScreenCapture")
    @JsonIgnore
    public Optional<Boolean> getBlockScreenCapture() {
        return Optional.ofNullable(blockScreenCapture);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockScreenCapture} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Block app from capturing contents of system display. Requires macOS 10.15 or
     * later.”</i>
     * 
     * @param blockScreenCapture
     *            new value of {@code blockScreenCapture} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockScreenCapture} field changed
     */
    public MacOSPrivacyAccessControlItem withBlockScreenCapture(Boolean blockScreenCapture) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.blockScreenCapture = blockScreenCapture;
        return _x;
    }

    /**
     * <i>“Block the app or process from listening to events from input devices such as
     * mouse, keyboard, and trackpad.Requires macOS 10.15 or later.”</i>
     * 
     * @return property blockListenEvent
     */
    @Property(name="blockListenEvent")
    @JsonIgnore
    public Optional<Boolean> getBlockListenEvent() {
        return Optional.ofNullable(blockListenEvent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code blockListenEvent}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Block the app or process from listening to events from input devices such as
     * mouse, keyboard, and trackpad.Requires macOS 10.15 or later.”</i>
     * 
     * @param blockListenEvent
     *            new value of {@code blockListenEvent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockListenEvent} field changed
     */
    public MacOSPrivacyAccessControlItem withBlockListenEvent(Boolean blockListenEvent) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.blockListenEvent = blockListenEvent;
        return _x;
    }

    /**
     * <i>“Allow or block access to system speech recognition facility.”</i>
     * 
     * @return property speechRecognition
     */
    @Property(name="speechRecognition")
    @JsonIgnore
    public Optional<Enablement> getSpeechRecognition() {
        return Optional.ofNullable(speechRecognition);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code speechRecognition
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Allow or block access to system speech recognition facility.”</i>
     * 
     * @param speechRecognition
     *            new value of {@code speechRecognition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code speechRecognition} field changed
     */
    public MacOSPrivacyAccessControlItem withSpeechRecognition(Enablement speechRecognition) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.speechRecognition = speechRecognition;
        return _x;
    }

    /**
     * <i>“Allow the app or process to control the Mac via the Accessibility subsystem.”</i>
     * 
     * @return property accessibility
     */
    @Property(name="accessibility")
    @JsonIgnore
    public Optional<Enablement> getAccessibility() {
        return Optional.ofNullable(accessibility);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code accessibility}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Allow the app or process to control the Mac via the Accessibility subsystem.”</i>
     * 
     * @param accessibility
     *            new value of {@code accessibility} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accessibility} field changed
     */
    public MacOSPrivacyAccessControlItem withAccessibility(Enablement accessibility) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.accessibility = accessibility;
        return _x;
    }

    /**
     * <i>“Allow or block access to contact information managed by Contacts.”</i>
     * 
     * @return property addressBook
     */
    @Property(name="addressBook")
    @JsonIgnore
    public Optional<Enablement> getAddressBook() {
        return Optional.ofNullable(addressBook);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code addressBook}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Allow or block access to contact information managed by Contacts.”</i>
     * 
     * @param addressBook
     *            new value of {@code addressBook} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code addressBook} field changed
     */
    public MacOSPrivacyAccessControlItem withAddressBook(Enablement addressBook) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.addressBook = addressBook;
        return _x;
    }

    /**
     * <i>“Allow or block access to event information managed by Calendar.”</i>
     * 
     * @return property calendar
     */
    @Property(name="calendar")
    @JsonIgnore
    public Optional<Enablement> getCalendar() {
        return Optional.ofNullable(calendar);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code calendar} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Allow or block access to event information managed by Calendar.”</i>
     * 
     * @param calendar
     *            new value of {@code calendar} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code calendar} field changed
     */
    public MacOSPrivacyAccessControlItem withCalendar(Enablement calendar) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.calendar = calendar;
        return _x;
    }

    /**
     * <i>“Allow or block access to information managed by Reminders.”</i>
     * 
     * @return property reminders
     */
    @Property(name="reminders")
    @JsonIgnore
    public Optional<Enablement> getReminders() {
        return Optional.ofNullable(reminders);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code reminders} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Allow or block access to information managed by Reminders.”</i>
     * 
     * @param reminders
     *            new value of {@code reminders} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code reminders} field changed
     */
    public MacOSPrivacyAccessControlItem withReminders(Enablement reminders) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.reminders = reminders;
        return _x;
    }

    /**
     * <i>“Allow or block access to images managed by Photos.”</i>
     * 
     * @return property photos
     */
    @Property(name="photos")
    @JsonIgnore
    public Optional<Enablement> getPhotos() {
        return Optional.ofNullable(photos);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code photos} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Allow or block access to images managed by Photos.”</i>
     * 
     * @param photos
     *            new value of {@code photos} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code photos} field changed
     */
    public MacOSPrivacyAccessControlItem withPhotos(Enablement photos) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.photos = photos;
        return _x;
    }

    /**
     * <i>“Allow or block access to music and the media library.”</i>
     * 
     * @return property mediaLibrary
     */
    @Property(name="mediaLibrary")
    @JsonIgnore
    public Optional<Enablement> getMediaLibrary() {
        return Optional.ofNullable(mediaLibrary);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mediaLibrary}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Allow or block access to music and the media library.”</i>
     * 
     * @param mediaLibrary
     *            new value of {@code mediaLibrary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mediaLibrary} field changed
     */
    public MacOSPrivacyAccessControlItem withMediaLibrary(Enablement mediaLibrary) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.mediaLibrary = mediaLibrary;
        return _x;
    }

    /**
     * <i>“Allow the app or process to access files managed by another app’s file provider
     * extension. Requires macOS 10.15 or later.”</i>
     * 
     * @return property fileProviderPresence
     */
    @Property(name="fileProviderPresence")
    @JsonIgnore
    public Optional<Enablement> getFileProviderPresence() {
        return Optional.ofNullable(fileProviderPresence);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * fileProviderPresence} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Allow the app or process to access files managed by another app’s file provider
     * extension. Requires macOS 10.15 or later.”</i>
     * 
     * @param fileProviderPresence
     *            new value of {@code fileProviderPresence} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fileProviderPresence} field changed
     */
    public MacOSPrivacyAccessControlItem withFileProviderPresence(Enablement fileProviderPresence) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.fileProviderPresence = fileProviderPresence;
        return _x;
    }

    /**
     * <i>“Control access to all protected files on a device. Files might be in locations
     * such as emails, messages, apps, and administrative settings. Apply this setting
     * with caution.”</i>
     * 
     * @return property systemPolicyAllFiles
     */
    @Property(name="systemPolicyAllFiles")
    @JsonIgnore
    public Optional<Enablement> getSystemPolicyAllFiles() {
        return Optional.ofNullable(systemPolicyAllFiles);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemPolicyAllFiles} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Control access to all protected files on a device. Files might be in locations
     * such as emails, messages, apps, and administrative settings. Apply this setting
     * with caution.”</i>
     * 
     * @param systemPolicyAllFiles
     *            new value of {@code systemPolicyAllFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemPolicyAllFiles} field changed
     */
    public MacOSPrivacyAccessControlItem withSystemPolicyAllFiles(Enablement systemPolicyAllFiles) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.systemPolicyAllFiles = systemPolicyAllFiles;
        return _x;
    }

    /**
     * <i>“Allow app or process to access files used in system administration.”</i>
     * 
     * @return property systemPolicySystemAdminFiles
     */
    @Property(name="systemPolicySystemAdminFiles")
    @JsonIgnore
    public Optional<Enablement> getSystemPolicySystemAdminFiles() {
        return Optional.ofNullable(systemPolicySystemAdminFiles);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemPolicySystemAdminFiles} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allow app or process to access files used in system administration.”</i>
     * 
     * @param systemPolicySystemAdminFiles
     *            new value of {@code systemPolicySystemAdminFiles} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemPolicySystemAdminFiles} field changed
     */
    public MacOSPrivacyAccessControlItem withSystemPolicySystemAdminFiles(Enablement systemPolicySystemAdminFiles) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.systemPolicySystemAdminFiles = systemPolicySystemAdminFiles;
        return _x;
    }

    /**
     * <i>“Allow or block access to Desktop folder.”</i>
     * 
     * @return property systemPolicyDesktopFolder
     */
    @Property(name="systemPolicyDesktopFolder")
    @JsonIgnore
    public Optional<Enablement> getSystemPolicyDesktopFolder() {
        return Optional.ofNullable(systemPolicyDesktopFolder);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemPolicyDesktopFolder} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allow or block access to Desktop folder.”</i>
     * 
     * @param systemPolicyDesktopFolder
     *            new value of {@code systemPolicyDesktopFolder} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemPolicyDesktopFolder} field changed
     */
    public MacOSPrivacyAccessControlItem withSystemPolicyDesktopFolder(Enablement systemPolicyDesktopFolder) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.systemPolicyDesktopFolder = systemPolicyDesktopFolder;
        return _x;
    }

    /**
     * <i>“Allow or block access to Documents folder.”</i>
     * 
     * @return property systemPolicyDocumentsFolder
     */
    @Property(name="systemPolicyDocumentsFolder")
    @JsonIgnore
    public Optional<Enablement> getSystemPolicyDocumentsFolder() {
        return Optional.ofNullable(systemPolicyDocumentsFolder);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemPolicyDocumentsFolder} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allow or block access to Documents folder.”</i>
     * 
     * @param systemPolicyDocumentsFolder
     *            new value of {@code systemPolicyDocumentsFolder} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemPolicyDocumentsFolder} field changed
     */
    public MacOSPrivacyAccessControlItem withSystemPolicyDocumentsFolder(Enablement systemPolicyDocumentsFolder) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.systemPolicyDocumentsFolder = systemPolicyDocumentsFolder;
        return _x;
    }

    /**
     * <i>“Allow or block access to Downloads folder.”</i>
     * 
     * @return property systemPolicyDownloadsFolder
     */
    @Property(name="systemPolicyDownloadsFolder")
    @JsonIgnore
    public Optional<Enablement> getSystemPolicyDownloadsFolder() {
        return Optional.ofNullable(systemPolicyDownloadsFolder);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemPolicyDownloadsFolder} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allow or block access to Downloads folder.”</i>
     * 
     * @param systemPolicyDownloadsFolder
     *            new value of {@code systemPolicyDownloadsFolder} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemPolicyDownloadsFolder} field changed
     */
    public MacOSPrivacyAccessControlItem withSystemPolicyDownloadsFolder(Enablement systemPolicyDownloadsFolder) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.systemPolicyDownloadsFolder = systemPolicyDownloadsFolder;
        return _x;
    }

    /**
     * <i>“Allow or block access to network volumes. Requires macOS 10.15 or later.”</i>
     * 
     * @return property systemPolicyNetworkVolumes
     */
    @Property(name="systemPolicyNetworkVolumes")
    @JsonIgnore
    public Optional<Enablement> getSystemPolicyNetworkVolumes() {
        return Optional.ofNullable(systemPolicyNetworkVolumes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemPolicyNetworkVolumes} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Allow or block access to network volumes. Requires macOS 10.15 or later.”</i>
     * 
     * @param systemPolicyNetworkVolumes
     *            new value of {@code systemPolicyNetworkVolumes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemPolicyNetworkVolumes} field changed
     */
    public MacOSPrivacyAccessControlItem withSystemPolicyNetworkVolumes(Enablement systemPolicyNetworkVolumes) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.systemPolicyNetworkVolumes = systemPolicyNetworkVolumes;
        return _x;
    }

    /**
     * <i>“Control access to removable  volumes on the device, such as an external hard
     * drive. Requires macOS 10.15 or later.”</i>
     * 
     * @return property systemPolicyRemovableVolumes
     */
    @Property(name="systemPolicyRemovableVolumes")
    @JsonIgnore
    public Optional<Enablement> getSystemPolicyRemovableVolumes() {
        return Optional.ofNullable(systemPolicyRemovableVolumes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemPolicyRemovableVolumes} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Control access to removable  volumes on the device, such as an external hard
     * drive. Requires macOS 10.15 or later.”</i>
     * 
     * @param systemPolicyRemovableVolumes
     *            new value of {@code systemPolicyRemovableVolumes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemPolicyRemovableVolumes} field changed
     */
    public MacOSPrivacyAccessControlItem withSystemPolicyRemovableVolumes(Enablement systemPolicyRemovableVolumes) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.systemPolicyRemovableVolumes = systemPolicyRemovableVolumes;
        return _x;
    }

    /**
     * <i>“Control access to CoreGraphics APIs, which are used to send CGEvents to the
     * system event stream.”</i>
     * 
     * @return property postEvent
     */
    @Property(name="postEvent")
    @JsonIgnore
    public Optional<Enablement> getPostEvent() {
        return Optional.ofNullable(postEvent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code postEvent} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Control access to CoreGraphics APIs, which are used to send CGEvents to the
     * system event stream.”</i>
     * 
     * @param postEvent
     *            new value of {@code postEvent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code postEvent} field changed
     */
    public MacOSPrivacyAccessControlItem withPostEvent(Enablement postEvent) {
        MacOSPrivacyAccessControlItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSPrivacyAccessControlItem");
        _x.postEvent = postEvent;
        return _x;
    }

    /**
     * <i>“Allow or deny the app or process to send a restricted Apple event to another app
     * or process. You will need to know the identifier, identifier type, and code
     * requirement of the receiving app or process. This collection can contain a
     * maximum of 500 elements.”</i>
     * 
     * @return property appleEventsAllowedReceivers
     */
    @Property(name="appleEventsAllowedReceivers")
    @JsonIgnore
    public CollectionPage<MacOSAppleEventReceiver> getAppleEventsAllowedReceivers() {
        return new CollectionPage<MacOSAppleEventReceiver>(contextPath, MacOSAppleEventReceiver.class, appleEventsAllowedReceivers, Optional.ofNullable(appleEventsAllowedReceiversNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Allow or deny the app or process to send a restricted Apple event to another app
     * or process. You will need to know the identifier, identifier type, and code
     * requirement of the receiving app or process. This collection can contain a
     * maximum of 500 elements.”</i>
     * 
     * @return property appleEventsAllowedReceivers
     */
    @Property(name="appleEventsAllowedReceivers")
    @JsonIgnore
    public CollectionPage<MacOSAppleEventReceiver> getAppleEventsAllowedReceivers(HttpRequestOptions options) {
        return new CollectionPage<MacOSAppleEventReceiver>(contextPath, MacOSAppleEventReceiver.class, appleEventsAllowedReceivers, Optional.ofNullable(appleEventsAllowedReceiversNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String identifier;
        private MacOSProcessIdentifierType identifierType;
        private String codeRequirement;
        private Boolean staticCodeValidation;
        private Boolean blockCamera;
        private Boolean blockMicrophone;
        private Boolean blockScreenCapture;
        private Boolean blockListenEvent;
        private Enablement speechRecognition;
        private Enablement accessibility;
        private Enablement addressBook;
        private Enablement calendar;
        private Enablement reminders;
        private Enablement photos;
        private Enablement mediaLibrary;
        private Enablement fileProviderPresence;
        private Enablement systemPolicyAllFiles;
        private Enablement systemPolicySystemAdminFiles;
        private Enablement systemPolicyDesktopFolder;
        private Enablement systemPolicyDocumentsFolder;
        private Enablement systemPolicyDownloadsFolder;
        private Enablement systemPolicyNetworkVolumes;
        private Enablement systemPolicyRemovableVolumes;
        private Enablement postEvent;
        private List<MacOSAppleEventReceiver> appleEventsAllowedReceivers;
        private String appleEventsAllowedReceiversNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The display name of the app, process, or executable.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The bundle ID or path of the app, process, or executable.”</i>
         * 
         * @param identifier
         *            value of {@code identifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("identifier");
            return this;
        }

        /**
         * <i>“A bundle ID is used to identify an app. A path is used to identify a process or
         * executable.”</i>
         * 
         * @param identifierType
         *            value of {@code identifierType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder identifierType(MacOSProcessIdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("identifierType");
            return this;
        }

        /**
         * <i>“Enter the code requirement, which can be obtained with the command 'codesign
         * –display -r –' in the Terminal app. Include everything after '=&amp;gt;'.”</i>
         * 
         * @param codeRequirement
         *            value of {@code codeRequirement} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder codeRequirement(String codeRequirement) {
            this.codeRequirement = codeRequirement;
            this.changedFields = changedFields.add("codeRequirement");
            return this;
        }

        /**
         * <i>“Statically validates the code requirement. Use this setting if the process
         * invalidates its dynamic code signature.”</i>
         * 
         * @param staticCodeValidation
         *            value of {@code staticCodeValidation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder staticCodeValidation(Boolean staticCodeValidation) {
            this.staticCodeValidation = staticCodeValidation;
            this.changedFields = changedFields.add("staticCodeValidation");
            return this;
        }

        /**
         * <i>“Block access to camera app.”</i>
         * 
         * @param blockCamera
         *            value of {@code blockCamera} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockCamera(Boolean blockCamera) {
            this.blockCamera = blockCamera;
            this.changedFields = changedFields.add("blockCamera");
            return this;
        }

        /**
         * <i>“Block access to microphone.”</i>
         * 
         * @param blockMicrophone
         *            value of {@code blockMicrophone} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockMicrophone(Boolean blockMicrophone) {
            this.blockMicrophone = blockMicrophone;
            this.changedFields = changedFields.add("blockMicrophone");
            return this;
        }

        /**
         * <i>“Block app from capturing contents of system display. Requires macOS 10.15 or
         * later.”</i>
         * 
         * @param blockScreenCapture
         *            value of {@code blockScreenCapture} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockScreenCapture(Boolean blockScreenCapture) {
            this.blockScreenCapture = blockScreenCapture;
            this.changedFields = changedFields.add("blockScreenCapture");
            return this;
        }

        /**
         * <i>“Block the app or process from listening to events from input devices such as
         * mouse, keyboard, and trackpad.Requires macOS 10.15 or later.”</i>
         * 
         * @param blockListenEvent
         *            value of {@code blockListenEvent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockListenEvent(Boolean blockListenEvent) {
            this.blockListenEvent = blockListenEvent;
            this.changedFields = changedFields.add("blockListenEvent");
            return this;
        }

        /**
         * <i>“Allow or block access to system speech recognition facility.”</i>
         * 
         * @param speechRecognition
         *            value of {@code speechRecognition} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder speechRecognition(Enablement speechRecognition) {
            this.speechRecognition = speechRecognition;
            this.changedFields = changedFields.add("speechRecognition");
            return this;
        }

        /**
         * <i>“Allow the app or process to control the Mac via the Accessibility subsystem.”</i>
         * 
         * @param accessibility
         *            value of {@code accessibility} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accessibility(Enablement accessibility) {
            this.accessibility = accessibility;
            this.changedFields = changedFields.add("accessibility");
            return this;
        }

        /**
         * <i>“Allow or block access to contact information managed by Contacts.”</i>
         * 
         * @param addressBook
         *            value of {@code addressBook} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder addressBook(Enablement addressBook) {
            this.addressBook = addressBook;
            this.changedFields = changedFields.add("addressBook");
            return this;
        }

        /**
         * <i>“Allow or block access to event information managed by Calendar.”</i>
         * 
         * @param calendar
         *            value of {@code calendar} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder calendar(Enablement calendar) {
            this.calendar = calendar;
            this.changedFields = changedFields.add("calendar");
            return this;
        }

        /**
         * <i>“Allow or block access to information managed by Reminders.”</i>
         * 
         * @param reminders
         *            value of {@code reminders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder reminders(Enablement reminders) {
            this.reminders = reminders;
            this.changedFields = changedFields.add("reminders");
            return this;
        }

        /**
         * <i>“Allow or block access to images managed by Photos.”</i>
         * 
         * @param photos
         *            value of {@code photos} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder photos(Enablement photos) {
            this.photos = photos;
            this.changedFields = changedFields.add("photos");
            return this;
        }

        /**
         * <i>“Allow or block access to music and the media library.”</i>
         * 
         * @param mediaLibrary
         *            value of {@code mediaLibrary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mediaLibrary(Enablement mediaLibrary) {
            this.mediaLibrary = mediaLibrary;
            this.changedFields = changedFields.add("mediaLibrary");
            return this;
        }

        /**
         * <i>“Allow the app or process to access files managed by another app’s file provider
         * extension. Requires macOS 10.15 or later.”</i>
         * 
         * @param fileProviderPresence
         *            value of {@code fileProviderPresence} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fileProviderPresence(Enablement fileProviderPresence) {
            this.fileProviderPresence = fileProviderPresence;
            this.changedFields = changedFields.add("fileProviderPresence");
            return this;
        }

        /**
         * <i>“Control access to all protected files on a device. Files might be in locations
         * such as emails, messages, apps, and administrative settings. Apply this setting
         * with caution.”</i>
         * 
         * @param systemPolicyAllFiles
         *            value of {@code systemPolicyAllFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemPolicyAllFiles(Enablement systemPolicyAllFiles) {
            this.systemPolicyAllFiles = systemPolicyAllFiles;
            this.changedFields = changedFields.add("systemPolicyAllFiles");
            return this;
        }

        /**
         * <i>“Allow app or process to access files used in system administration.”</i>
         * 
         * @param systemPolicySystemAdminFiles
         *            value of {@code systemPolicySystemAdminFiles} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemPolicySystemAdminFiles(Enablement systemPolicySystemAdminFiles) {
            this.systemPolicySystemAdminFiles = systemPolicySystemAdminFiles;
            this.changedFields = changedFields.add("systemPolicySystemAdminFiles");
            return this;
        }

        /**
         * <i>“Allow or block access to Desktop folder.”</i>
         * 
         * @param systemPolicyDesktopFolder
         *            value of {@code systemPolicyDesktopFolder} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemPolicyDesktopFolder(Enablement systemPolicyDesktopFolder) {
            this.systemPolicyDesktopFolder = systemPolicyDesktopFolder;
            this.changedFields = changedFields.add("systemPolicyDesktopFolder");
            return this;
        }

        /**
         * <i>“Allow or block access to Documents folder.”</i>
         * 
         * @param systemPolicyDocumentsFolder
         *            value of {@code systemPolicyDocumentsFolder} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemPolicyDocumentsFolder(Enablement systemPolicyDocumentsFolder) {
            this.systemPolicyDocumentsFolder = systemPolicyDocumentsFolder;
            this.changedFields = changedFields.add("systemPolicyDocumentsFolder");
            return this;
        }

        /**
         * <i>“Allow or block access to Downloads folder.”</i>
         * 
         * @param systemPolicyDownloadsFolder
         *            value of {@code systemPolicyDownloadsFolder} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemPolicyDownloadsFolder(Enablement systemPolicyDownloadsFolder) {
            this.systemPolicyDownloadsFolder = systemPolicyDownloadsFolder;
            this.changedFields = changedFields.add("systemPolicyDownloadsFolder");
            return this;
        }

        /**
         * <i>“Allow or block access to network volumes. Requires macOS 10.15 or later.”</i>
         * 
         * @param systemPolicyNetworkVolumes
         *            value of {@code systemPolicyNetworkVolumes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemPolicyNetworkVolumes(Enablement systemPolicyNetworkVolumes) {
            this.systemPolicyNetworkVolumes = systemPolicyNetworkVolumes;
            this.changedFields = changedFields.add("systemPolicyNetworkVolumes");
            return this;
        }

        /**
         * <i>“Control access to removable  volumes on the device, such as an external hard
         * drive. Requires macOS 10.15 or later.”</i>
         * 
         * @param systemPolicyRemovableVolumes
         *            value of {@code systemPolicyRemovableVolumes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemPolicyRemovableVolumes(Enablement systemPolicyRemovableVolumes) {
            this.systemPolicyRemovableVolumes = systemPolicyRemovableVolumes;
            this.changedFields = changedFields.add("systemPolicyRemovableVolumes");
            return this;
        }

        /**
         * <i>“Control access to CoreGraphics APIs, which are used to send CGEvents to the
         * system event stream.”</i>
         * 
         * @param postEvent
         *            value of {@code postEvent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder postEvent(Enablement postEvent) {
            this.postEvent = postEvent;
            this.changedFields = changedFields.add("postEvent");
            return this;
        }

        /**
         * <i>“Allow or deny the app or process to send a restricted Apple event to another app
         * or process. You will need to know the identifier, identifier type, and code
         * requirement of the receiving app or process. This collection can contain a
         * maximum of 500 elements.”</i>
         * 
         * @param appleEventsAllowedReceivers
         *            value of {@code appleEventsAllowedReceivers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleEventsAllowedReceivers(List<MacOSAppleEventReceiver> appleEventsAllowedReceivers) {
            this.appleEventsAllowedReceivers = appleEventsAllowedReceivers;
            this.changedFields = changedFields.add("appleEventsAllowedReceivers");
            return this;
        }

        /**
         * <i>“Allow or deny the app or process to send a restricted Apple event to another app
         * or process. You will need to know the identifier, identifier type, and code
         * requirement of the receiving app or process. This collection can contain a
         * maximum of 500 elements.”</i>
         * 
         * @param appleEventsAllowedReceivers
         *            value of {@code appleEventsAllowedReceivers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleEventsAllowedReceivers(MacOSAppleEventReceiver... appleEventsAllowedReceivers) {
            return appleEventsAllowedReceivers(Arrays.asList(appleEventsAllowedReceivers));
        }

        /**
         * <i>“Allow or deny the app or process to send a restricted Apple event to another app
         * or process. You will need to know the identifier, identifier type, and code
         * requirement of the receiving app or process. This collection can contain a
         * maximum of 500 elements.”</i>
         * 
         * @param appleEventsAllowedReceiversNextLink
         *            value of {@code appleEventsAllowedReceivers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleEventsAllowedReceiversNextLink(String appleEventsAllowedReceiversNextLink) {
            this.appleEventsAllowedReceiversNextLink = appleEventsAllowedReceiversNextLink;
            this.changedFields = changedFields.add("appleEventsAllowedReceivers");
            return this;
        }

        public MacOSPrivacyAccessControlItem build() {
            MacOSPrivacyAccessControlItem _x = new MacOSPrivacyAccessControlItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.macOSPrivacyAccessControlItem";
            _x.displayName = displayName;
            _x.identifier = identifier;
            _x.identifierType = identifierType;
            _x.codeRequirement = codeRequirement;
            _x.staticCodeValidation = staticCodeValidation;
            _x.blockCamera = blockCamera;
            _x.blockMicrophone = blockMicrophone;
            _x.blockScreenCapture = blockScreenCapture;
            _x.blockListenEvent = blockListenEvent;
            _x.speechRecognition = speechRecognition;
            _x.accessibility = accessibility;
            _x.addressBook = addressBook;
            _x.calendar = calendar;
            _x.reminders = reminders;
            _x.photos = photos;
            _x.mediaLibrary = mediaLibrary;
            _x.fileProviderPresence = fileProviderPresence;
            _x.systemPolicyAllFiles = systemPolicyAllFiles;
            _x.systemPolicySystemAdminFiles = systemPolicySystemAdminFiles;
            _x.systemPolicyDesktopFolder = systemPolicyDesktopFolder;
            _x.systemPolicyDocumentsFolder = systemPolicyDocumentsFolder;
            _x.systemPolicyDownloadsFolder = systemPolicyDownloadsFolder;
            _x.systemPolicyNetworkVolumes = systemPolicyNetworkVolumes;
            _x.systemPolicyRemovableVolumes = systemPolicyRemovableVolumes;
            _x.postEvent = postEvent;
            _x.appleEventsAllowedReceivers = appleEventsAllowedReceivers;
            _x.appleEventsAllowedReceiversNextLink = appleEventsAllowedReceiversNextLink;
            return _x;
        }
    }

    private MacOSPrivacyAccessControlItem _copy() {
        MacOSPrivacyAccessControlItem _x = new MacOSPrivacyAccessControlItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.identifier = identifier;
        _x.identifierType = identifierType;
        _x.codeRequirement = codeRequirement;
        _x.staticCodeValidation = staticCodeValidation;
        _x.blockCamera = blockCamera;
        _x.blockMicrophone = blockMicrophone;
        _x.blockScreenCapture = blockScreenCapture;
        _x.blockListenEvent = blockListenEvent;
        _x.speechRecognition = speechRecognition;
        _x.accessibility = accessibility;
        _x.addressBook = addressBook;
        _x.calendar = calendar;
        _x.reminders = reminders;
        _x.photos = photos;
        _x.mediaLibrary = mediaLibrary;
        _x.fileProviderPresence = fileProviderPresence;
        _x.systemPolicyAllFiles = systemPolicyAllFiles;
        _x.systemPolicySystemAdminFiles = systemPolicySystemAdminFiles;
        _x.systemPolicyDesktopFolder = systemPolicyDesktopFolder;
        _x.systemPolicyDocumentsFolder = systemPolicyDocumentsFolder;
        _x.systemPolicyDownloadsFolder = systemPolicyDownloadsFolder;
        _x.systemPolicyNetworkVolumes = systemPolicyNetworkVolumes;
        _x.systemPolicyRemovableVolumes = systemPolicyRemovableVolumes;
        _x.postEvent = postEvent;
        _x.appleEventsAllowedReceivers = appleEventsAllowedReceivers;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSPrivacyAccessControlItem[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("identifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("codeRequirement=");
        b.append(this.codeRequirement);
        b.append(", ");
        b.append("staticCodeValidation=");
        b.append(this.staticCodeValidation);
        b.append(", ");
        b.append("blockCamera=");
        b.append(this.blockCamera);
        b.append(", ");
        b.append("blockMicrophone=");
        b.append(this.blockMicrophone);
        b.append(", ");
        b.append("blockScreenCapture=");
        b.append(this.blockScreenCapture);
        b.append(", ");
        b.append("blockListenEvent=");
        b.append(this.blockListenEvent);
        b.append(", ");
        b.append("speechRecognition=");
        b.append(this.speechRecognition);
        b.append(", ");
        b.append("accessibility=");
        b.append(this.accessibility);
        b.append(", ");
        b.append("addressBook=");
        b.append(this.addressBook);
        b.append(", ");
        b.append("calendar=");
        b.append(this.calendar);
        b.append(", ");
        b.append("reminders=");
        b.append(this.reminders);
        b.append(", ");
        b.append("photos=");
        b.append(this.photos);
        b.append(", ");
        b.append("mediaLibrary=");
        b.append(this.mediaLibrary);
        b.append(", ");
        b.append("fileProviderPresence=");
        b.append(this.fileProviderPresence);
        b.append(", ");
        b.append("systemPolicyAllFiles=");
        b.append(this.systemPolicyAllFiles);
        b.append(", ");
        b.append("systemPolicySystemAdminFiles=");
        b.append(this.systemPolicySystemAdminFiles);
        b.append(", ");
        b.append("systemPolicyDesktopFolder=");
        b.append(this.systemPolicyDesktopFolder);
        b.append(", ");
        b.append("systemPolicyDocumentsFolder=");
        b.append(this.systemPolicyDocumentsFolder);
        b.append(", ");
        b.append("systemPolicyDownloadsFolder=");
        b.append(this.systemPolicyDownloadsFolder);
        b.append(", ");
        b.append("systemPolicyNetworkVolumes=");
        b.append(this.systemPolicyNetworkVolumes);
        b.append(", ");
        b.append("systemPolicyRemovableVolumes=");
        b.append(this.systemPolicyRemovableVolumes);
        b.append(", ");
        b.append("postEvent=");
        b.append(this.postEvent);
        b.append(", ");
        b.append("appleEventsAllowedReceivers=");
        b.append(this.appleEventsAllowedReceivers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
