package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Represents a specific macOS kernel extension. A macOS kernel extension can be
 * described by its team identifier plus its bundle identifier.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "teamIdentifier", 
    "bundleId"})
@JsonInclude(Include.NON_NULL)
public class MacOSKernelExtension implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("teamIdentifier")
    protected String teamIdentifier;

    @JsonProperty("bundleId")
    protected String bundleId;

    protected MacOSKernelExtension() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSKernelExtension";
    }

    /**
     * <i>“The team identifier that was used to sign the kernel extension.”</i>
     * 
     * @return property teamIdentifier
     */
    @Property(name="teamIdentifier")
    @JsonIgnore
    public Optional<String> getTeamIdentifier() {
        return Optional.ofNullable(teamIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code teamIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The team identifier that was used to sign the kernel extension.”</i>
     * 
     * @param teamIdentifier
     *            new value of {@code teamIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code teamIdentifier} field changed
     */
    public MacOSKernelExtension withTeamIdentifier(String teamIdentifier) {
        MacOSKernelExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSKernelExtension");
        _x.teamIdentifier = teamIdentifier;
        return _x;
    }

    /**
     * <i>“Bundle ID of the kernel extension.”</i>
     * 
     * @return property bundleId
     */
    @Property(name="bundleId")
    @JsonIgnore
    public Optional<String> getBundleId() {
        return Optional.ofNullable(bundleId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bundleId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Bundle ID of the kernel extension.”</i>
     * 
     * @param bundleId
     *            new value of {@code bundleId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bundleId} field changed
     */
    public MacOSKernelExtension withBundleId(String bundleId) {
        MacOSKernelExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSKernelExtension");
        _x.bundleId = bundleId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String teamIdentifier;
        private String bundleId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The team identifier that was used to sign the kernel extension.”</i>
         * 
         * @param teamIdentifier
         *            value of {@code teamIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder teamIdentifier(String teamIdentifier) {
            this.teamIdentifier = teamIdentifier;
            this.changedFields = changedFields.add("teamIdentifier");
            return this;
        }

        /**
         * <i>“Bundle ID of the kernel extension.”</i>
         * 
         * @param bundleId
         *            value of {@code bundleId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            this.changedFields = changedFields.add("bundleId");
            return this;
        }

        public MacOSKernelExtension build() {
            MacOSKernelExtension _x = new MacOSKernelExtension();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.macOSKernelExtension";
            _x.teamIdentifier = teamIdentifier;
            _x.bundleId = bundleId;
            return _x;
        }
    }

    private MacOSKernelExtension _copy() {
        MacOSKernelExtension _x = new MacOSKernelExtension();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.teamIdentifier = teamIdentifier;
        _x.bundleId = bundleId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSKernelExtension[");
        b.append("teamIdentifier=");
        b.append(this.teamIdentifier);
        b.append(", ");
        b.append("bundleId=");
        b.append(this.bundleId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
