package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Represents an app in the list of macOS firewall applications”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "bundleId", 
    "allowsIncomingConnections"})
@JsonInclude(Include.NON_NULL)
public class MacOSFirewallApplication implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("bundleId")
    protected String bundleId;

    @JsonProperty("allowsIncomingConnections")
    protected Boolean allowsIncomingConnections;

    protected MacOSFirewallApplication() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSFirewallApplication";
    }

    /**
     * <i>“BundleId of the application.”</i>
     * 
     * @return property bundleId
     */
    @Property(name="bundleId")
    @JsonIgnore
    public Optional<String> getBundleId() {
        return Optional.ofNullable(bundleId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bundleId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“BundleId of the application.”</i>
     * 
     * @param bundleId
     *            new value of {@code bundleId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bundleId} field changed
     */
    public MacOSFirewallApplication withBundleId(String bundleId) {
        MacOSFirewallApplication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSFirewallApplication");
        _x.bundleId = bundleId;
        return _x;
    }

    /**
     * <i>“Whether or not incoming connections are allowed.”</i>
     * 
     * @return property allowsIncomingConnections
     */
    @Property(name="allowsIncomingConnections")
    @JsonIgnore
    public Optional<Boolean> getAllowsIncomingConnections() {
        return Optional.ofNullable(allowsIncomingConnections);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowsIncomingConnections} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether or not incoming connections are allowed.”</i>
     * 
     * @param allowsIncomingConnections
     *            new value of {@code allowsIncomingConnections} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowsIncomingConnections} field changed
     */
    public MacOSFirewallApplication withAllowsIncomingConnections(Boolean allowsIncomingConnections) {
        MacOSFirewallApplication _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSFirewallApplication");
        _x.allowsIncomingConnections = allowsIncomingConnections;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String bundleId;
        private Boolean allowsIncomingConnections;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“BundleId of the application.”</i>
         * 
         * @param bundleId
         *            value of {@code bundleId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            this.changedFields = changedFields.add("bundleId");
            return this;
        }

        /**
         * <i>“Whether or not incoming connections are allowed.”</i>
         * 
         * @param allowsIncomingConnections
         *            value of {@code allowsIncomingConnections} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowsIncomingConnections(Boolean allowsIncomingConnections) {
            this.allowsIncomingConnections = allowsIncomingConnections;
            this.changedFields = changedFields.add("allowsIncomingConnections");
            return this;
        }

        public MacOSFirewallApplication build() {
            MacOSFirewallApplication _x = new MacOSFirewallApplication();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.macOSFirewallApplication";
            _x.bundleId = bundleId;
            _x.allowsIncomingConnections = allowsIncomingConnections;
            return _x;
        }
    }

    private MacOSFirewallApplication _copy() {
        MacOSFirewallApplication _x = new MacOSFirewallApplication();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.bundleId = bundleId;
        _x.allowsIncomingConnections = allowsIncomingConnections;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSFirewallApplication[");
        b.append("bundleId=");
        b.append(this.bundleId);
        b.append(", ");
        b.append("allowsIncomingConnections=");
        b.append(this.allowsIncomingConnections);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
