package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.LocationType;
import odata.msgraph.client.beta.enums.LocationUniqueIdType;

@JsonPropertyOrder({
    "@odata.type", 
    "resolveAvailability"})
@JsonInclude(Include.NON_NULL)
public class LocationConstraintItem extends Location implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("resolveAvailability")
    protected Boolean resolveAvailability;

    protected LocationConstraintItem() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.locationConstraintItem";
    }

    @Property(name="resolveAvailability")
    @JsonIgnore
    public Optional<Boolean> getResolveAvailability() {
        return Optional.ofNullable(resolveAvailability);
    }

    public LocationConstraintItem withResolveAvailability(Boolean resolveAvailability) {
        LocationConstraintItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.locationConstraintItem");
        _x.resolveAvailability = resolveAvailability;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderLocationConstraintItem() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String locationEmailAddress;
        private PhysicalAddress address;
        private OutlookGeoCoordinates coordinates;
        private String locationUri;
        private LocationType locationType;
        private String uniqueId;
        private LocationUniqueIdType uniqueIdType;
        private Boolean resolveAvailability;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder locationEmailAddress(String locationEmailAddress) {
            this.locationEmailAddress = locationEmailAddress;
            this.changedFields = changedFields.add("locationEmailAddress");
            return this;
        }

        public Builder address(PhysicalAddress address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder coordinates(OutlookGeoCoordinates coordinates) {
            this.coordinates = coordinates;
            this.changedFields = changedFields.add("coordinates");
            return this;
        }

        public Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            this.changedFields = changedFields.add("locationUri");
            return this;
        }

        public Builder locationType(LocationType locationType) {
            this.locationType = locationType;
            this.changedFields = changedFields.add("locationType");
            return this;
        }

        public Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            this.changedFields = changedFields.add("uniqueId");
            return this;
        }

        public Builder uniqueIdType(LocationUniqueIdType uniqueIdType) {
            this.uniqueIdType = uniqueIdType;
            this.changedFields = changedFields.add("uniqueIdType");
            return this;
        }

        public Builder resolveAvailability(Boolean resolveAvailability) {
            this.resolveAvailability = resolveAvailability;
            this.changedFields = changedFields.add("resolveAvailability");
            return this;
        }

        public LocationConstraintItem build() {
            LocationConstraintItem _x = new LocationConstraintItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.locationConstraintItem";
            _x.displayName = displayName;
            _x.locationEmailAddress = locationEmailAddress;
            _x.address = address;
            _x.coordinates = coordinates;
            _x.locationUri = locationUri;
            _x.locationType = locationType;
            _x.uniqueId = uniqueId;
            _x.uniqueIdType = uniqueIdType;
            _x.resolveAvailability = resolveAvailability;
            return _x;
        }
    }

    private LocationConstraintItem _copy() {
        LocationConstraintItem _x = new LocationConstraintItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.locationEmailAddress = locationEmailAddress;
        _x.address = address;
        _x.coordinates = coordinates;
        _x.locationUri = locationUri;
        _x.locationType = locationType;
        _x.uniqueId = uniqueId;
        _x.uniqueIdType = uniqueIdType;
        _x.resolveAvailability = resolveAvailability;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LocationConstraintItem[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("locationEmailAddress=");
        b.append(this.locationEmailAddress);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("coordinates=");
        b.append(this.coordinates);
        b.append(", ");
        b.append("locationUri=");
        b.append(this.locationUri);
        b.append(", ");
        b.append("locationType=");
        b.append(this.locationType);
        b.append(", ");
        b.append("uniqueId=");
        b.append(this.uniqueId);
        b.append(", ");
        b.append("uniqueIdType=");
        b.append(this.uniqueIdType);
        b.append(", ");
        b.append("resolveAvailability=");
        b.append(this.resolveAvailability);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
