package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "locations", 
    "isRequired", 
    "suggestLocation"})
@JsonInclude(Include.NON_NULL)
public class LocationConstraint implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("locations")
    protected List<LocationConstraintItem> locations;

    @JsonProperty("locations@nextLink")
    protected String locationsNextLink;

    @JsonProperty("isRequired")
    protected Boolean isRequired;

    @JsonProperty("suggestLocation")
    protected Boolean suggestLocation;

    protected LocationConstraint() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.locationConstraint";
    }

    @Property(name="locations")
    @JsonIgnore
    public CollectionPage<LocationConstraintItem> getLocations() {
        return new CollectionPage<LocationConstraintItem>(contextPath, LocationConstraintItem.class, locations, Optional.ofNullable(locationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="locations")
    @JsonIgnore
    public CollectionPage<LocationConstraintItem> getLocations(HttpRequestOptions options) {
        return new CollectionPage<LocationConstraintItem>(contextPath, LocationConstraintItem.class, locations, Optional.ofNullable(locationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="isRequired")
    @JsonIgnore
    public Optional<Boolean> getIsRequired() {
        return Optional.ofNullable(isRequired);
    }

    public LocationConstraint withIsRequired(Boolean isRequired) {
        LocationConstraint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.locationConstraint");
        _x.isRequired = isRequired;
        return _x;
    }

    @Property(name="suggestLocation")
    @JsonIgnore
    public Optional<Boolean> getSuggestLocation() {
        return Optional.ofNullable(suggestLocation);
    }

    public LocationConstraint withSuggestLocation(Boolean suggestLocation) {
        LocationConstraint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.locationConstraint");
        _x.suggestLocation = suggestLocation;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<LocationConstraintItem> locations;
        private String locationsNextLink;
        private Boolean isRequired;
        private Boolean suggestLocation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder locations(List<LocationConstraintItem> locations) {
            this.locations = locations;
            this.changedFields = changedFields.add("locations");
            return this;
        }

        public Builder locations(LocationConstraintItem... locations) {
            return locations(Arrays.asList(locations));
        }

        public Builder locationsNextLink(String locationsNextLink) {
            this.locationsNextLink = locationsNextLink;
            this.changedFields = changedFields.add("locations");
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.changedFields = changedFields.add("isRequired");
            return this;
        }

        public Builder suggestLocation(Boolean suggestLocation) {
            this.suggestLocation = suggestLocation;
            this.changedFields = changedFields.add("suggestLocation");
            return this;
        }

        public LocationConstraint build() {
            LocationConstraint _x = new LocationConstraint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.locationConstraint";
            _x.locations = locations;
            _x.locationsNextLink = locationsNextLink;
            _x.isRequired = isRequired;
            _x.suggestLocation = suggestLocation;
            return _x;
        }
    }

    private LocationConstraint _copy() {
        LocationConstraint _x = new LocationConstraint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.locations = locations;
        _x.isRequired = isRequired;
        _x.suggestLocation = suggestLocation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LocationConstraint[");
        b.append("locations=");
        b.append(this.locations);
        b.append(", ");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("suggestLocation=");
        b.append(this.suggestLocation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
