package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "locale", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class LocaleInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("locale")
    protected String locale;

    @JsonProperty("displayName")
    protected String displayName;

    protected LocaleInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.localeInfo";
    }

    @Property(name="locale")
    @JsonIgnore
    public Optional<String> getLocale() {
        return Optional.ofNullable(locale);
    }

    public LocaleInfo withLocale(String locale) {
        LocaleInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.localeInfo");
        _x.locale = locale;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public LocaleInfo withDisplayName(String displayName) {
        LocaleInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.localeInfo");
        _x.displayName = displayName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String locale;
        private String displayName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder locale(String locale) {
            this.locale = locale;
            this.changedFields = changedFields.add("locale");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public LocaleInfo build() {
            LocaleInfo _x = new LocaleInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.localeInfo";
            _x.locale = locale;
            _x.displayName = displayName;
            return _x;
        }
    }

    private LocaleInfo _copy() {
        LocaleInfo _x = new LocaleInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.locale = locale;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LocaleInfo[");
        b.append("locale=");
        b.append(this.locale);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
