package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "enabled", 
    "suspended", 
    "warning"})
@JsonInclude(Include.NON_NULL)
public class LicenseUnitsDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("enabled")
    protected Integer enabled;

    @JsonProperty("suspended")
    protected Integer suspended;

    @JsonProperty("warning")
    protected Integer warning;

    protected LicenseUnitsDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.licenseUnitsDetail";
    }

    @Property(name="enabled")
    @JsonIgnore
    public Optional<Integer> getEnabled() {
        return Optional.ofNullable(enabled);
    }

    public LicenseUnitsDetail withEnabled(Integer enabled) {
        LicenseUnitsDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseUnitsDetail");
        _x.enabled = enabled;
        return _x;
    }

    @Property(name="suspended")
    @JsonIgnore
    public Optional<Integer> getSuspended() {
        return Optional.ofNullable(suspended);
    }

    public LicenseUnitsDetail withSuspended(Integer suspended) {
        LicenseUnitsDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseUnitsDetail");
        _x.suspended = suspended;
        return _x;
    }

    @Property(name="warning")
    @JsonIgnore
    public Optional<Integer> getWarning() {
        return Optional.ofNullable(warning);
    }

    public LicenseUnitsDetail withWarning(Integer warning) {
        LicenseUnitsDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseUnitsDetail");
        _x.warning = warning;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer enabled;
        private Integer suspended;
        private Integer warning;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder enabled(Integer enabled) {
            this.enabled = enabled;
            this.changedFields = changedFields.add("enabled");
            return this;
        }

        public Builder suspended(Integer suspended) {
            this.suspended = suspended;
            this.changedFields = changedFields.add("suspended");
            return this;
        }

        public Builder warning(Integer warning) {
            this.warning = warning;
            this.changedFields = changedFields.add("warning");
            return this;
        }

        public LicenseUnitsDetail build() {
            LicenseUnitsDetail _x = new LicenseUnitsDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.licenseUnitsDetail";
            _x.enabled = enabled;
            _x.suspended = suspended;
            _x.warning = warning;
            return _x;
        }
    }

    private LicenseUnitsDetail _copy() {
        LicenseUnitsDetail _x = new LicenseUnitsDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.enabled = enabled;
        _x.suspended = suspended;
        _x.warning = warning;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LicenseUnitsDetail[");
        b.append("enabled=");
        b.append(this.enabled);
        b.append(", ");
        b.append("suspended=");
        b.append(this.suspended);
        b.append(", ");
        b.append("warning=");
        b.append(this.warning);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
