package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "skuId", 
    "disabledPlans", 
    "assignedByGroup", 
    "state", 
    "error"})
@JsonInclude(Include.NON_NULL)
public class LicenseAssignmentState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("skuId")
    protected String skuId;

    @JsonProperty("disabledPlans")
    protected List<String> disabledPlans;

    @JsonProperty("disabledPlans@nextLink")
    protected String disabledPlansNextLink;

    @JsonProperty("assignedByGroup")
    protected String assignedByGroup;

    @JsonProperty("state")
    protected String state;

    @JsonProperty("error")
    protected String error;

    protected LicenseAssignmentState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.licenseAssignmentState";
    }

    @Property(name="skuId")
    @JsonIgnore
    public Optional<String> getSkuId() {
        return Optional.ofNullable(skuId);
    }

    public LicenseAssignmentState withSkuId(String skuId) {
        LicenseAssignmentState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseAssignmentState");
        _x.skuId = skuId;
        return _x;
    }

    @Property(name="disabledPlans")
    @JsonIgnore
    public CollectionPage<String> getDisabledPlans() {
        return new CollectionPage<String>(contextPath, String.class, disabledPlans, Optional.ofNullable(disabledPlansNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="disabledPlans")
    @JsonIgnore
    public CollectionPage<String> getDisabledPlans(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, disabledPlans, Optional.ofNullable(disabledPlansNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="assignedByGroup")
    @JsonIgnore
    public Optional<String> getAssignedByGroup() {
        return Optional.ofNullable(assignedByGroup);
    }

    public LicenseAssignmentState withAssignedByGroup(String assignedByGroup) {
        LicenseAssignmentState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseAssignmentState");
        _x.assignedByGroup = assignedByGroup;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public LicenseAssignmentState withState(String state) {
        LicenseAssignmentState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseAssignmentState");
        _x.state = state;
        return _x;
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<String> getError() {
        return Optional.ofNullable(error);
    }

    public LicenseAssignmentState withError(String error) {
        LicenseAssignmentState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.licenseAssignmentState");
        _x.error = error;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String skuId;
        private List<String> disabledPlans;
        private String disabledPlansNextLink;
        private String assignedByGroup;
        private String state;
        private String error;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder skuId(String skuId) {
            this.skuId = skuId;
            this.changedFields = changedFields.add("skuId");
            return this;
        }

        public Builder disabledPlans(List<String> disabledPlans) {
            this.disabledPlans = disabledPlans;
            this.changedFields = changedFields.add("disabledPlans");
            return this;
        }

        public Builder disabledPlans(String... disabledPlans) {
            return disabledPlans(Arrays.asList(disabledPlans));
        }

        public Builder disabledPlansNextLink(String disabledPlansNextLink) {
            this.disabledPlansNextLink = disabledPlansNextLink;
            this.changedFields = changedFields.add("disabledPlans");
            return this;
        }

        public Builder assignedByGroup(String assignedByGroup) {
            this.assignedByGroup = assignedByGroup;
            this.changedFields = changedFields.add("assignedByGroup");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder error(String error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public LicenseAssignmentState build() {
            LicenseAssignmentState _x = new LicenseAssignmentState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.licenseAssignmentState";
            _x.skuId = skuId;
            _x.disabledPlans = disabledPlans;
            _x.disabledPlansNextLink = disabledPlansNextLink;
            _x.assignedByGroup = assignedByGroup;
            _x.state = state;
            _x.error = error;
            return _x;
        }
    }

    private LicenseAssignmentState _copy() {
        LicenseAssignmentState _x = new LicenseAssignmentState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.skuId = skuId;
        _x.disabledPlans = disabledPlans;
        _x.assignedByGroup = assignedByGroup;
        _x.state = state;
        _x.error = error;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LicenseAssignmentState[");
        b.append("skuId=");
        b.append(this.skuId);
        b.append(", ");
        b.append("disabledPlans=");
        b.append(this.disabledPlans);
        b.append(", ");
        b.append("assignedByGroup=");
        b.append(this.assignedByGroup);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
