package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AssignmentMethod;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "labelId", 
    "assignmentMethod", 
    "downgradeJustification", 
    "extendedProperties"})
@JsonInclude(Include.NON_NULL)
public class LabelingOptions implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("labelId")
    protected String labelId;

    @JsonProperty("assignmentMethod")
    protected AssignmentMethod assignmentMethod;

    @JsonProperty("downgradeJustification")
    protected DowngradeJustification downgradeJustification;

    @JsonProperty("extendedProperties")
    protected List<KeyValuePair> extendedProperties;

    @JsonProperty("extendedProperties@nextLink")
    protected String extendedPropertiesNextLink;

    protected LabelingOptions() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.labelingOptions";
    }

    @Property(name="labelId")
    @JsonIgnore
    public Optional<String> getLabelId() {
        return Optional.ofNullable(labelId);
    }

    public LabelingOptions withLabelId(String labelId) {
        LabelingOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.labelingOptions");
        _x.labelId = labelId;
        return _x;
    }

    @Property(name="assignmentMethod")
    @JsonIgnore
    public Optional<AssignmentMethod> getAssignmentMethod() {
        return Optional.ofNullable(assignmentMethod);
    }

    public LabelingOptions withAssignmentMethod(AssignmentMethod assignmentMethod) {
        LabelingOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.labelingOptions");
        _x.assignmentMethod = assignmentMethod;
        return _x;
    }

    @Property(name="downgradeJustification")
    @JsonIgnore
    public Optional<DowngradeJustification> getDowngradeJustification() {
        return Optional.ofNullable(downgradeJustification);
    }

    public LabelingOptions withDowngradeJustification(DowngradeJustification downgradeJustification) {
        LabelingOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.labelingOptions");
        _x.downgradeJustification = downgradeJustification;
        return _x;
    }

    @Property(name="extendedProperties")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getExtendedProperties() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, extendedProperties, Optional.ofNullable(extendedPropertiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="extendedProperties")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getExtendedProperties(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, extendedProperties, Optional.ofNullable(extendedPropertiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String labelId;
        private AssignmentMethod assignmentMethod;
        private DowngradeJustification downgradeJustification;
        private List<KeyValuePair> extendedProperties;
        private String extendedPropertiesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder labelId(String labelId) {
            this.labelId = labelId;
            this.changedFields = changedFields.add("labelId");
            return this;
        }

        public Builder assignmentMethod(AssignmentMethod assignmentMethod) {
            this.assignmentMethod = assignmentMethod;
            this.changedFields = changedFields.add("assignmentMethod");
            return this;
        }

        public Builder downgradeJustification(DowngradeJustification downgradeJustification) {
            this.downgradeJustification = downgradeJustification;
            this.changedFields = changedFields.add("downgradeJustification");
            return this;
        }

        public Builder extendedProperties(List<KeyValuePair> extendedProperties) {
            this.extendedProperties = extendedProperties;
            this.changedFields = changedFields.add("extendedProperties");
            return this;
        }

        public Builder extendedProperties(KeyValuePair... extendedProperties) {
            return extendedProperties(Arrays.asList(extendedProperties));
        }

        public Builder extendedPropertiesNextLink(String extendedPropertiesNextLink) {
            this.extendedPropertiesNextLink = extendedPropertiesNextLink;
            this.changedFields = changedFields.add("extendedProperties");
            return this;
        }

        public LabelingOptions build() {
            LabelingOptions _x = new LabelingOptions();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.labelingOptions";
            _x.labelId = labelId;
            _x.assignmentMethod = assignmentMethod;
            _x.downgradeJustification = downgradeJustification;
            _x.extendedProperties = extendedProperties;
            _x.extendedPropertiesNextLink = extendedPropertiesNextLink;
            return _x;
        }
    }

    private LabelingOptions _copy() {
        LabelingOptions _x = new LabelingOptions();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.labelId = labelId;
        _x.assignmentMethod = assignmentMethod;
        _x.downgradeJustification = downgradeJustification;
        _x.extendedProperties = extendedProperties;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LabelingOptions[");
        b.append("labelId=");
        b.append(this.labelId);
        b.append(", ");
        b.append("assignmentMethod=");
        b.append(this.assignmentMethod);
        b.append(", ");
        b.append("downgradeJustification=");
        b.append(this.downgradeJustification);
        b.append(", ");
        b.append("extendedProperties=");
        b.append(this.extendedProperties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
