package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "name", 
    "description", 
    "color", 
    "sensitivity", 
    "tooltip", 
    "isActive"})
@JsonInclude(Include.NON_NULL)
public class LabelDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("color")
    protected String color;

    @JsonProperty("sensitivity")
    protected Integer sensitivity;

    @JsonProperty("tooltip")
    protected String tooltip;

    @JsonProperty("isActive")
    protected Boolean isActive;

    protected LabelDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.labelDetails";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public LabelDetails withId(String id) {
        LabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.labelDetails");
        _x.id = id;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public LabelDetails withName(String name) {
        LabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.labelDetails");
        _x.name = name;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public LabelDetails withDescription(String description) {
        LabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.labelDetails");
        _x.description = description;
        return _x;
    }

    @Property(name="color")
    @JsonIgnore
    public Optional<String> getColor() {
        return Optional.ofNullable(color);
    }

    public LabelDetails withColor(String color) {
        LabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.labelDetails");
        _x.color = color;
        return _x;
    }

    @Property(name="sensitivity")
    @JsonIgnore
    public Optional<Integer> getSensitivity() {
        return Optional.ofNullable(sensitivity);
    }

    public LabelDetails withSensitivity(Integer sensitivity) {
        LabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.labelDetails");
        _x.sensitivity = sensitivity;
        return _x;
    }

    @Property(name="tooltip")
    @JsonIgnore
    public Optional<String> getTooltip() {
        return Optional.ofNullable(tooltip);
    }

    public LabelDetails withTooltip(String tooltip) {
        LabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.labelDetails");
        _x.tooltip = tooltip;
        return _x;
    }

    @Property(name="isActive")
    @JsonIgnore
    public Optional<Boolean> getIsActive() {
        return Optional.ofNullable(isActive);
    }

    public LabelDetails withIsActive(Boolean isActive) {
        LabelDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.labelDetails");
        _x.isActive = isActive;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private String description;
        private String color;
        private Integer sensitivity;
        private String tooltip;
        private Boolean isActive;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            this.changedFields = changedFields.add("color");
            return this;
        }

        public Builder sensitivity(Integer sensitivity) {
            this.sensitivity = sensitivity;
            this.changedFields = changedFields.add("sensitivity");
            return this;
        }

        public Builder tooltip(String tooltip) {
            this.tooltip = tooltip;
            this.changedFields = changedFields.add("tooltip");
            return this;
        }

        public Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            this.changedFields = changedFields.add("isActive");
            return this;
        }

        public LabelDetails build() {
            LabelDetails _x = new LabelDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.labelDetails";
            _x.id = id;
            _x.name = name;
            _x.description = description;
            _x.color = color;
            _x.sensitivity = sensitivity;
            _x.tooltip = tooltip;
            _x.isActive = isActive;
            return _x;
        }
    }

    private LabelDetails _copy() {
        LabelDetails _x = new LabelDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.name = name;
        _x.description = description;
        _x.color = color;
        _x.sensitivity = sensitivity;
        _x.tooltip = tooltip;
        _x.isActive = isActive;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LabelDetails[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("color=");
        b.append(this.color);
        b.append(", ");
        b.append("sensitivity=");
        b.append(this.sensitivity);
        b.append(", ");
        b.append("tooltip=");
        b.append(this.tooltip);
        b.append(", ");
        b.append("isActive=");
        b.append(this.isActive);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
