package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“A key-value pair with a string key and an integer value.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class KeyIntegerValuePair extends KeyTypedValuePair implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("value")
    protected Integer value;

    protected KeyIntegerValuePair() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.keyIntegerValuePair";
    }

    /**
     * <i>“The integer value of the key-value pair.”</i>
     * 
     * @return property value
     */
    @Property(name="value")
    @JsonIgnore
    public Optional<Integer> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code value} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The integer value of the key-value pair.”</i>
     * 
     * @param value
     *            new value of {@code value} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code value} field changed
     */
    public KeyIntegerValuePair withValue(Integer value) {
        KeyIntegerValuePair _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.keyIntegerValuePair");
        _x.value = value;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderKeyIntegerValuePair() {
        return new Builder();
    }

    public static final class Builder {
        private String key;
        private Integer value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder key(String key) {
            this.key = key;
            this.changedFields = changedFields.add("key");
            return this;
        }

        /**
         * <i>“The integer value of the key-value pair.”</i>
         * 
         * @param value
         *            value of {@code value} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder value(Integer value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public KeyIntegerValuePair build() {
            KeyIntegerValuePair _x = new KeyIntegerValuePair();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.keyIntegerValuePair";
            _x.key = key;
            _x.value = value;
            return _x;
        }
    }

    private KeyIntegerValuePair _copy() {
        KeyIntegerValuePair _x = new KeyIntegerValuePair();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.key = key;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("KeyIntegerValuePair[");
        b.append("key=");
        b.append(this.key);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
