package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Represents a Kerberos-type Single Sign-On extension profile.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "realm", 
    "domains", 
    "blockAutomaticLogin", 
    "cacheName", 
    "credentialBundleIdAccessControlList", 
    "domainRealms", 
    "isDefaultRealm", 
    "passwordBlockModification", 
    "passwordExpirationDays", 
    "passwordExpirationNotificationDays", 
    "userPrincipalName", 
    "passwordRequireActiveDirectoryComplexity", 
    "passwordPreviousPasswordBlockCount", 
    "passwordMinimumLength", 
    "passwordMinimumAgeDays", 
    "passwordRequirementsDescription", 
    "requireUserPresence", 
    "activeDirectorySiteCode", 
    "passwordEnableLocalSync", 
    "blockActiveDirectorySiteAutoDiscovery", 
    "passwordChangeUrl"})
@JsonInclude(Include.NON_NULL)
public class KerberosSingleSignOnExtension extends SingleSignOnExtension implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("realm")
    protected String realm;

    @JsonProperty("domains")
    protected List<String> domains;

    @JsonProperty("domains@nextLink")
    protected String domainsNextLink;

    @JsonProperty("blockAutomaticLogin")
    protected Boolean blockAutomaticLogin;

    @JsonProperty("cacheName")
    protected String cacheName;

    @JsonProperty("credentialBundleIdAccessControlList")
    protected List<String> credentialBundleIdAccessControlList;

    @JsonProperty("credentialBundleIdAccessControlList@nextLink")
    protected String credentialBundleIdAccessControlListNextLink;

    @JsonProperty("domainRealms")
    protected List<String> domainRealms;

    @JsonProperty("domainRealms@nextLink")
    protected String domainRealmsNextLink;

    @JsonProperty("isDefaultRealm")
    protected Boolean isDefaultRealm;

    @JsonProperty("passwordBlockModification")
    protected Boolean passwordBlockModification;

    @JsonProperty("passwordExpirationDays")
    protected Integer passwordExpirationDays;

    @JsonProperty("passwordExpirationNotificationDays")
    protected Integer passwordExpirationNotificationDays;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("passwordRequireActiveDirectoryComplexity")
    protected Boolean passwordRequireActiveDirectoryComplexity;

    @JsonProperty("passwordPreviousPasswordBlockCount")
    protected Integer passwordPreviousPasswordBlockCount;

    @JsonProperty("passwordMinimumLength")
    protected Integer passwordMinimumLength;

    @JsonProperty("passwordMinimumAgeDays")
    protected Integer passwordMinimumAgeDays;

    @JsonProperty("passwordRequirementsDescription")
    protected String passwordRequirementsDescription;

    @JsonProperty("requireUserPresence")
    protected Boolean requireUserPresence;

    @JsonProperty("activeDirectorySiteCode")
    protected String activeDirectorySiteCode;

    @JsonProperty("passwordEnableLocalSync")
    protected Boolean passwordEnableLocalSync;

    @JsonProperty("blockActiveDirectorySiteAutoDiscovery")
    protected Boolean blockActiveDirectorySiteAutoDiscovery;

    @JsonProperty("passwordChangeUrl")
    protected String passwordChangeUrl;

    protected KerberosSingleSignOnExtension() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.kerberosSingleSignOnExtension";
    }

    /**
     * <i>“Gets or sets the case-sensitive realm name for this profile.”</i>
     * 
     * @return property realm
     */
    @Property(name="realm")
    @JsonIgnore
    public Optional<String> getRealm() {
        return Optional.ofNullable(realm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code realm} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Gets or sets the case-sensitive realm name for this profile.”</i>
     * 
     * @param realm
     *            new value of {@code realm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code realm} field changed
     */
    public KerberosSingleSignOnExtension withRealm(String realm) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.realm = realm;
        return _x;
    }

    /**
     * <i>“Gets or sets a list of hosts or domain names for which the app extension
     * performs SSO.”</i>
     * 
     * @return property domains
     */
    @Property(name="domains")
    @JsonIgnore
    public CollectionPage<String> getDomains() {
        return new CollectionPage<String>(contextPath, String.class, domains, Optional.ofNullable(domainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Gets or sets a list of hosts or domain names for which the app extension
     * performs SSO.”</i>
     * 
     * @return property domains
     */
    @Property(name="domains")
    @JsonIgnore
    public CollectionPage<String> getDomains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, domains, Optional.ofNullable(domainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Enables or disables Keychain usage.”</i>
     * 
     * @return property blockAutomaticLogin
     */
    @Property(name="blockAutomaticLogin")
    @JsonIgnore
    public Optional<Boolean> getBlockAutomaticLogin() {
        return Optional.ofNullable(blockAutomaticLogin);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockAutomaticLogin} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Enables or disables Keychain usage.”</i>
     * 
     * @param blockAutomaticLogin
     *            new value of {@code blockAutomaticLogin} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockAutomaticLogin} field changed
     */
    public KerberosSingleSignOnExtension withBlockAutomaticLogin(Boolean blockAutomaticLogin) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.blockAutomaticLogin = blockAutomaticLogin;
        return _x;
    }

    /**
     * <i>“Gets or sets the Generic Security Services name of the Kerberos cache to use for
     * this profile.”</i>
     * 
     * @return property cacheName
     */
    @Property(name="cacheName")
    @JsonIgnore
    public Optional<String> getCacheName() {
        return Optional.ofNullable(cacheName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cacheName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Gets or sets the Generic Security Services name of the Kerberos cache to use for
     * this profile.”</i>
     * 
     * @param cacheName
     *            new value of {@code cacheName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cacheName} field changed
     */
    public KerberosSingleSignOnExtension withCacheName(String cacheName) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.cacheName = cacheName;
        return _x;
    }

    /**
     * <i>“Gets or sets a list of app Bundle IDs allowed to access the Kerberos Ticket
     * Granting Ticket.”</i>
     * 
     * @return property credentialBundleIdAccessControlList
     */
    @Property(name="credentialBundleIdAccessControlList")
    @JsonIgnore
    public CollectionPage<String> getCredentialBundleIdAccessControlList() {
        return new CollectionPage<String>(contextPath, String.class, credentialBundleIdAccessControlList, Optional.ofNullable(credentialBundleIdAccessControlListNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Gets or sets a list of app Bundle IDs allowed to access the Kerberos Ticket
     * Granting Ticket.”</i>
     * 
     * @return property credentialBundleIdAccessControlList
     */
    @Property(name="credentialBundleIdAccessControlList")
    @JsonIgnore
    public CollectionPage<String> getCredentialBundleIdAccessControlList(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, credentialBundleIdAccessControlList, Optional.ofNullable(credentialBundleIdAccessControlListNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Gets or sets a list of realms for custom domain-realm mapping. Realms are case
     * sensitive.”</i>
     * 
     * @return property domainRealms
     */
    @Property(name="domainRealms")
    @JsonIgnore
    public CollectionPage<String> getDomainRealms() {
        return new CollectionPage<String>(contextPath, String.class, domainRealms, Optional.ofNullable(domainRealmsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Gets or sets a list of realms for custom domain-realm mapping. Realms are case
     * sensitive.”</i>
     * 
     * @return property domainRealms
     */
    @Property(name="domainRealms")
    @JsonIgnore
    public CollectionPage<String> getDomainRealms(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, domainRealms, Optional.ofNullable(domainRealmsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“When true, this profile's realm will be selected as the default. Necessary if
     * multiple Kerberos-type profiles are configured.”</i>
     * 
     * @return property isDefaultRealm
     */
    @Property(name="isDefaultRealm")
    @JsonIgnore
    public Optional<Boolean> getIsDefaultRealm() {
        return Optional.ofNullable(isDefaultRealm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isDefaultRealm}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“When true, this profile's realm will be selected as the default. Necessary if
     * multiple Kerberos-type profiles are configured.”</i>
     * 
     * @param isDefaultRealm
     *            new value of {@code isDefaultRealm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isDefaultRealm} field changed
     */
    public KerberosSingleSignOnExtension withIsDefaultRealm(Boolean isDefaultRealm) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.isDefaultRealm = isDefaultRealm;
        return _x;
    }

    /**
     * <i>“Enables or disables password changes.”</i>
     * 
     * @return property passwordBlockModification
     */
    @Property(name="passwordBlockModification")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockModification() {
        return Optional.ofNullable(passwordBlockModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockModification} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enables or disables password changes.”</i>
     * 
     * @param passwordBlockModification
     *            new value of {@code passwordBlockModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockModification} field changed
     */
    public KerberosSingleSignOnExtension withPasswordBlockModification(Boolean passwordBlockModification) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.passwordBlockModification = passwordBlockModification;
        return _x;
    }

    /**
     * <i>“Overrides the default password expiration in days. For most domains, this value
     * is calculated automatically.”</i>
     * 
     * @return property passwordExpirationDays
     */
    @Property(name="passwordExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPasswordExpirationDays() {
        return Optional.ofNullable(passwordExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordExpirationDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Overrides the default password expiration in days. For most domains, this value
     * is calculated automatically.”</i>
     * 
     * @param passwordExpirationDays
     *            new value of {@code passwordExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordExpirationDays} field changed
     */
    public KerberosSingleSignOnExtension withPasswordExpirationDays(Integer passwordExpirationDays) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.passwordExpirationDays = passwordExpirationDays;
        return _x;
    }

    /**
     * <i>“Gets or sets the number of days until the user is notified that their password
     * will expire (default is 15).”</i>
     * 
     * @return property passwordExpirationNotificationDays
     */
    @Property(name="passwordExpirationNotificationDays")
    @JsonIgnore
    public Optional<Integer> getPasswordExpirationNotificationDays() {
        return Optional.ofNullable(passwordExpirationNotificationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordExpirationNotificationDays} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets the number of days until the user is notified that their password
     * will expire (default is 15).”</i>
     * 
     * @param passwordExpirationNotificationDays
     *            new value of {@code passwordExpirationNotificationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordExpirationNotificationDays} field changed
     */
    public KerberosSingleSignOnExtension withPasswordExpirationNotificationDays(Integer passwordExpirationNotificationDays) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.passwordExpirationNotificationDays = passwordExpirationNotificationDays;
        return _x;
    }

    /**
     * <i>“Gets or sets the principle user name to use for this profile. The realm name
     * does not need to be included.”</i>
     * 
     * @return property userPrincipalName
     */
    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userPrincipalName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Gets or sets the principle user name to use for this profile. The realm name
     * does not need to be included.”</i>
     * 
     * @param userPrincipalName
     *            new value of {@code userPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userPrincipalName} field changed
     */
    public KerberosSingleSignOnExtension withUserPrincipalName(String userPrincipalName) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    /**
     * <i>“Enables or disables whether passwords must meet Active Directory's complexity
     * requirements.”</i>
     * 
     * @return property passwordRequireActiveDirectoryComplexity
     */
    @Property(name="passwordRequireActiveDirectoryComplexity")
    @JsonIgnore
    public Optional<Boolean> getPasswordRequireActiveDirectoryComplexity() {
        return Optional.ofNullable(passwordRequireActiveDirectoryComplexity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequireActiveDirectoryComplexity} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Enables or disables whether passwords must meet Active Directory's complexity
     * requirements.”</i>
     * 
     * @param passwordRequireActiveDirectoryComplexity
     *            new value of {@code passwordRequireActiveDirectoryComplexity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequireActiveDirectoryComplexity} field changed
     */
    public KerberosSingleSignOnExtension withPasswordRequireActiveDirectoryComplexity(Boolean passwordRequireActiveDirectoryComplexity) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.passwordRequireActiveDirectoryComplexity = passwordRequireActiveDirectoryComplexity;
        return _x;
    }

    /**
     * <i>“Gets or sets the number of previous passwords to block.”</i>
     * 
     * @return property passwordPreviousPasswordBlockCount
     */
    @Property(name="passwordPreviousPasswordBlockCount")
    @JsonIgnore
    public Optional<Integer> getPasswordPreviousPasswordBlockCount() {
        return Optional.ofNullable(passwordPreviousPasswordBlockCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordPreviousPasswordBlockCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets the number of previous passwords to block.”</i>
     * 
     * @param passwordPreviousPasswordBlockCount
     *            new value of {@code passwordPreviousPasswordBlockCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordPreviousPasswordBlockCount} field changed
     */
    public KerberosSingleSignOnExtension withPasswordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        return _x;
    }

    /**
     * <i>“Gets or sets the minimum length of a password.”</i>
     * 
     * @return property passwordMinimumLength
     */
    @Property(name="passwordMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLength() {
        return Optional.ofNullable(passwordMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Gets or sets the minimum length of a password.”</i>
     * 
     * @param passwordMinimumLength
     *            new value of {@code passwordMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLength} field changed
     */
    public KerberosSingleSignOnExtension withPasswordMinimumLength(Integer passwordMinimumLength) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.passwordMinimumLength = passwordMinimumLength;
        return _x;
    }

    /**
     * <i>“Gets or sets the minimum number of days until a user can change their password
     * again.”</i>
     * 
     * @return property passwordMinimumAgeDays
     */
    @Property(name="passwordMinimumAgeDays")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumAgeDays() {
        return Optional.ofNullable(passwordMinimumAgeDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumAgeDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets the minimum number of days until a user can change their password
     * again.”</i>
     * 
     * @param passwordMinimumAgeDays
     *            new value of {@code passwordMinimumAgeDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumAgeDays} field changed
     */
    public KerberosSingleSignOnExtension withPasswordMinimumAgeDays(Integer passwordMinimumAgeDays) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.passwordMinimumAgeDays = passwordMinimumAgeDays;
        return _x;
    }

    /**
     * <i>“Gets or sets a description of the password complexity requirements.”</i>
     * 
     * @return property passwordRequirementsDescription
     */
    @Property(name="passwordRequirementsDescription")
    @JsonIgnore
    public Optional<String> getPasswordRequirementsDescription() {
        return Optional.ofNullable(passwordRequirementsDescription);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequirementsDescription} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets a description of the password complexity requirements.”</i>
     * 
     * @param passwordRequirementsDescription
     *            new value of {@code passwordRequirementsDescription} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequirementsDescription} field changed
     */
    public KerberosSingleSignOnExtension withPasswordRequirementsDescription(String passwordRequirementsDescription) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.passwordRequirementsDescription = passwordRequirementsDescription;
        return _x;
    }

    /**
     * <i>“Gets or sets whether to require authentication via Touch ID, Face ID, or a
     * passcode to access the keychain entry.”</i>
     * 
     * @return property requireUserPresence
     */
    @Property(name="requireUserPresence")
    @JsonIgnore
    public Optional<Boolean> getRequireUserPresence() {
        return Optional.ofNullable(requireUserPresence);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requireUserPresence} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Gets or sets whether to require authentication via Touch ID, Face ID, or a
     * passcode to access the keychain entry.”</i>
     * 
     * @param requireUserPresence
     *            new value of {@code requireUserPresence} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requireUserPresence} field changed
     */
    public KerberosSingleSignOnExtension withRequireUserPresence(Boolean requireUserPresence) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.requireUserPresence = requireUserPresence;
        return _x;
    }

    /**
     * <i>“Gets or sets the Active Directory site.”</i>
     * 
     * @return property activeDirectorySiteCode
     */
    @Property(name="activeDirectorySiteCode")
    @JsonIgnore
    public Optional<String> getActiveDirectorySiteCode() {
        return Optional.ofNullable(activeDirectorySiteCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * activeDirectorySiteCode} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets the Active Directory site.”</i>
     * 
     * @param activeDirectorySiteCode
     *            new value of {@code activeDirectorySiteCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activeDirectorySiteCode} field changed
     */
    public KerberosSingleSignOnExtension withActiveDirectorySiteCode(String activeDirectorySiteCode) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.activeDirectorySiteCode = activeDirectorySiteCode;
        return _x;
    }

    /**
     * <i>“Enables or disables password syncing. This won't affect users logged in with a
     * mobile account on macOS.”</i>
     * 
     * @return property passwordEnableLocalSync
     */
    @Property(name="passwordEnableLocalSync")
    @JsonIgnore
    public Optional<Boolean> getPasswordEnableLocalSync() {
        return Optional.ofNullable(passwordEnableLocalSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordEnableLocalSync} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enables or disables password syncing. This won't affect users logged in with a
     * mobile account on macOS.”</i>
     * 
     * @param passwordEnableLocalSync
     *            new value of {@code passwordEnableLocalSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordEnableLocalSync} field changed
     */
    public KerberosSingleSignOnExtension withPasswordEnableLocalSync(Boolean passwordEnableLocalSync) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.passwordEnableLocalSync = passwordEnableLocalSync;
        return _x;
    }

    /**
     * <i>“Enables or disables whether the Kerberos extension can automatically determine
     * its site name.”</i>
     * 
     * @return property blockActiveDirectorySiteAutoDiscovery
     */
    @Property(name="blockActiveDirectorySiteAutoDiscovery")
    @JsonIgnore
    public Optional<Boolean> getBlockActiveDirectorySiteAutoDiscovery() {
        return Optional.ofNullable(blockActiveDirectorySiteAutoDiscovery);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockActiveDirectorySiteAutoDiscovery} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Enables or disables whether the Kerberos extension can automatically determine
     * its site name.”</i>
     * 
     * @param blockActiveDirectorySiteAutoDiscovery
     *            new value of {@code blockActiveDirectorySiteAutoDiscovery} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockActiveDirectorySiteAutoDiscovery} field changed
     */
    public KerberosSingleSignOnExtension withBlockActiveDirectorySiteAutoDiscovery(Boolean blockActiveDirectorySiteAutoDiscovery) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.blockActiveDirectorySiteAutoDiscovery = blockActiveDirectorySiteAutoDiscovery;
        return _x;
    }

    /**
     * <i>“Gets or sets the URL that the user will be sent to when they initiate a password
     * change.”</i>
     * 
     * @return property passwordChangeUrl
     */
    @Property(name="passwordChangeUrl")
    @JsonIgnore
    public Optional<String> getPasswordChangeUrl() {
        return Optional.ofNullable(passwordChangeUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passwordChangeUrl
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Gets or sets the URL that the user will be sent to when they initiate a password
     * change.”</i>
     * 
     * @param passwordChangeUrl
     *            new value of {@code passwordChangeUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordChangeUrl} field changed
     */
    public KerberosSingleSignOnExtension withPasswordChangeUrl(String passwordChangeUrl) {
        KerberosSingleSignOnExtension _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSingleSignOnExtension");
        _x.passwordChangeUrl = passwordChangeUrl;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private KerberosSingleSignOnExtension _copy() {
        KerberosSingleSignOnExtension _x = new KerberosSingleSignOnExtension();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.realm = realm;
        _x.domains = domains;
        _x.blockAutomaticLogin = blockAutomaticLogin;
        _x.cacheName = cacheName;
        _x.credentialBundleIdAccessControlList = credentialBundleIdAccessControlList;
        _x.domainRealms = domainRealms;
        _x.isDefaultRealm = isDefaultRealm;
        _x.passwordBlockModification = passwordBlockModification;
        _x.passwordExpirationDays = passwordExpirationDays;
        _x.passwordExpirationNotificationDays = passwordExpirationNotificationDays;
        _x.userPrincipalName = userPrincipalName;
        _x.passwordRequireActiveDirectoryComplexity = passwordRequireActiveDirectoryComplexity;
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        _x.passwordMinimumLength = passwordMinimumLength;
        _x.passwordMinimumAgeDays = passwordMinimumAgeDays;
        _x.passwordRequirementsDescription = passwordRequirementsDescription;
        _x.requireUserPresence = requireUserPresence;
        _x.activeDirectorySiteCode = activeDirectorySiteCode;
        _x.passwordEnableLocalSync = passwordEnableLocalSync;
        _x.blockActiveDirectorySiteAutoDiscovery = blockActiveDirectorySiteAutoDiscovery;
        _x.passwordChangeUrl = passwordChangeUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("KerberosSingleSignOnExtension[");
        b.append("realm=");
        b.append(this.realm);
        b.append(", ");
        b.append("domains=");
        b.append(this.domains);
        b.append(", ");
        b.append("blockAutomaticLogin=");
        b.append(this.blockAutomaticLogin);
        b.append(", ");
        b.append("cacheName=");
        b.append(this.cacheName);
        b.append(", ");
        b.append("credentialBundleIdAccessControlList=");
        b.append(this.credentialBundleIdAccessControlList);
        b.append(", ");
        b.append("domainRealms=");
        b.append(this.domainRealms);
        b.append(", ");
        b.append("isDefaultRealm=");
        b.append(this.isDefaultRealm);
        b.append(", ");
        b.append("passwordBlockModification=");
        b.append(this.passwordBlockModification);
        b.append(", ");
        b.append("passwordExpirationDays=");
        b.append(this.passwordExpirationDays);
        b.append(", ");
        b.append("passwordExpirationNotificationDays=");
        b.append(this.passwordExpirationNotificationDays);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("passwordRequireActiveDirectoryComplexity=");
        b.append(this.passwordRequireActiveDirectoryComplexity);
        b.append(", ");
        b.append("passwordPreviousPasswordBlockCount=");
        b.append(this.passwordPreviousPasswordBlockCount);
        b.append(", ");
        b.append("passwordMinimumLength=");
        b.append(this.passwordMinimumLength);
        b.append(", ");
        b.append("passwordMinimumAgeDays=");
        b.append(this.passwordMinimumAgeDays);
        b.append(", ");
        b.append("passwordRequirementsDescription=");
        b.append(this.passwordRequirementsDescription);
        b.append(", ");
        b.append("requireUserPresence=");
        b.append(this.requireUserPresence);
        b.append(", ");
        b.append("activeDirectorySiteCode=");
        b.append(this.activeDirectorySiteCode);
        b.append(", ");
        b.append("passwordEnableLocalSync=");
        b.append(this.passwordEnableLocalSync);
        b.append(", ");
        b.append("blockActiveDirectorySiteAutoDiscovery=");
        b.append(this.blockActiveDirectorySiteAutoDiscovery);
        b.append(", ");
        b.append("passwordChangeUrl=");
        b.append(this.passwordChangeUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
