package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.KerberosSignOnMappingAttributeType;

@JsonPropertyOrder({
    "@odata.type", 
    "KerberosServicePrincipalName", 
    "KerberosSignOnMappingAttributeType"})
@JsonInclude(Include.NON_NULL)
public class KerberosSignOnSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("KerberosServicePrincipalName")
    protected String kerberosServicePrincipalName;

    @JsonProperty("KerberosSignOnMappingAttributeType")
    protected KerberosSignOnMappingAttributeType kerberosSignOnMappingAttributeType;

    protected KerberosSignOnSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.kerberosSignOnSettings";
    }

    @Property(name="KerberosServicePrincipalName")
    @JsonIgnore
    public Optional<String> getKerberosServicePrincipalName() {
        return Optional.ofNullable(kerberosServicePrincipalName);
    }

    public KerberosSignOnSettings withKerberosServicePrincipalName(String kerberosServicePrincipalName) {
        KerberosSignOnSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSignOnSettings");
        _x.kerberosServicePrincipalName = kerberosServicePrincipalName;
        return _x;
    }

    @Property(name="KerberosSignOnMappingAttributeType")
    @JsonIgnore
    public Optional<KerberosSignOnMappingAttributeType> getKerberosSignOnMappingAttributeType() {
        return Optional.ofNullable(kerberosSignOnMappingAttributeType);
    }

    public KerberosSignOnSettings withKerberosSignOnMappingAttributeType(KerberosSignOnMappingAttributeType kerberosSignOnMappingAttributeType) {
        KerberosSignOnSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.kerberosSignOnSettings");
        _x.kerberosSignOnMappingAttributeType = kerberosSignOnMappingAttributeType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String kerberosServicePrincipalName;
        private KerberosSignOnMappingAttributeType kerberosSignOnMappingAttributeType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder kerberosServicePrincipalName(String kerberosServicePrincipalName) {
            this.kerberosServicePrincipalName = kerberosServicePrincipalName;
            this.changedFields = changedFields.add("KerberosServicePrincipalName");
            return this;
        }

        public Builder kerberosSignOnMappingAttributeType(KerberosSignOnMappingAttributeType kerberosSignOnMappingAttributeType) {
            this.kerberosSignOnMappingAttributeType = kerberosSignOnMappingAttributeType;
            this.changedFields = changedFields.add("KerberosSignOnMappingAttributeType");
            return this;
        }

        public KerberosSignOnSettings build() {
            KerberosSignOnSettings _x = new KerberosSignOnSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.kerberosSignOnSettings";
            _x.kerberosServicePrincipalName = kerberosServicePrincipalName;
            _x.kerberosSignOnMappingAttributeType = kerberosSignOnMappingAttributeType;
            return _x;
        }
    }

    private KerberosSignOnSettings _copy() {
        KerberosSignOnSettings _x = new KerberosSignOnSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.kerberosServicePrincipalName = kerberosServicePrincipalName;
        _x.kerberosSignOnMappingAttributeType = kerberosSignOnMappingAttributeType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("KerberosSignOnSettings[");
        b.append("KerberosServicePrincipalName=");
        b.append(this.kerberosServicePrincipalName);
        b.append(", ");
        b.append("KerberosSignOnMappingAttributeType=");
        b.append(this.kerberosSignOnMappingAttributeType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
