package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.BodyType;

@JsonPropertyOrder({
    "@odata.type", 
    "contentType", 
    "content"})
@JsonInclude(Include.NON_NULL)
public class ItemBody implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("contentType")
    protected BodyType contentType;

    @JsonProperty("content")
    protected String content;

    protected ItemBody() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.itemBody";
    }

    @Property(name="contentType")
    @JsonIgnore
    public Optional<BodyType> getContentType() {
        return Optional.ofNullable(contentType);
    }

    public ItemBody withContentType(BodyType contentType) {
        ItemBody _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemBody");
        _x.contentType = contentType;
        return _x;
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<String> getContent() {
        return Optional.ofNullable(content);
    }

    public ItemBody withContent(String content) {
        ItemBody _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemBody");
        _x.content = content;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BodyType contentType;
        private String content;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder contentType(BodyType contentType) {
            this.contentType = contentType;
            this.changedFields = changedFields.add("contentType");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public ItemBody build() {
            ItemBody _x = new ItemBody();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.itemBody";
            _x.contentType = contentType;
            _x.content = content;
            return _x;
        }
    }

    private ItemBody _copy() {
        ItemBody _x = new ItemBody();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.contentType = contentType;
        _x.content = content;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ItemBody[");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
