package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "lastRecordedDateTime", 
    "observedDateTime", 
    "recordedDateTime"})
@JsonInclude(Include.NON_NULL)
public class ItemActivityTimeSet implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("lastRecordedDateTime")
    protected OffsetDateTime lastRecordedDateTime;

    @JsonProperty("observedDateTime")
    protected OffsetDateTime observedDateTime;

    @JsonProperty("recordedDateTime")
    protected OffsetDateTime recordedDateTime;

    protected ItemActivityTimeSet() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.itemActivityTimeSet";
    }

    @Property(name="lastRecordedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRecordedDateTime() {
        return Optional.ofNullable(lastRecordedDateTime);
    }

    public ItemActivityTimeSet withLastRecordedDateTime(OffsetDateTime lastRecordedDateTime) {
        ItemActivityTimeSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityTimeSet");
        _x.lastRecordedDateTime = lastRecordedDateTime;
        return _x;
    }

    @Property(name="observedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getObservedDateTime() {
        return Optional.ofNullable(observedDateTime);
    }

    public ItemActivityTimeSet withObservedDateTime(OffsetDateTime observedDateTime) {
        ItemActivityTimeSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityTimeSet");
        _x.observedDateTime = observedDateTime;
        return _x;
    }

    @Property(name="recordedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRecordedDateTime() {
        return Optional.ofNullable(recordedDateTime);
    }

    public ItemActivityTimeSet withRecordedDateTime(OffsetDateTime recordedDateTime) {
        ItemActivityTimeSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivityTimeSet");
        _x.recordedDateTime = recordedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime lastRecordedDateTime;
        private OffsetDateTime observedDateTime;
        private OffsetDateTime recordedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder lastRecordedDateTime(OffsetDateTime lastRecordedDateTime) {
            this.lastRecordedDateTime = lastRecordedDateTime;
            this.changedFields = changedFields.add("lastRecordedDateTime");
            return this;
        }

        public Builder observedDateTime(OffsetDateTime observedDateTime) {
            this.observedDateTime = observedDateTime;
            this.changedFields = changedFields.add("observedDateTime");
            return this;
        }

        public Builder recordedDateTime(OffsetDateTime recordedDateTime) {
            this.recordedDateTime = recordedDateTime;
            this.changedFields = changedFields.add("recordedDateTime");
            return this;
        }

        public ItemActivityTimeSet build() {
            ItemActivityTimeSet _x = new ItemActivityTimeSet();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.itemActivityTimeSet";
            _x.lastRecordedDateTime = lastRecordedDateTime;
            _x.observedDateTime = observedDateTime;
            _x.recordedDateTime = recordedDateTime;
            return _x;
        }
    }

    private ItemActivityTimeSet _copy() {
        ItemActivityTimeSet _x = new ItemActivityTimeSet();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.lastRecordedDateTime = lastRecordedDateTime;
        _x.observedDateTime = observedDateTime;
        _x.recordedDateTime = recordedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ItemActivityTimeSet[");
        b.append("lastRecordedDateTime=");
        b.append(this.lastRecordedDateTime);
        b.append(", ");
        b.append("observedDateTime=");
        b.append(this.observedDateTime);
        b.append(", ");
        b.append("recordedDateTime=");
        b.append(this.recordedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
