package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "asn", 
    "city", 
    "countryOrRegionCode", 
    "organization", 
    "state", 
    "vendor"})
@JsonInclude(Include.NON_NULL)
public class IpReferenceData implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("asn")
    protected Integer asn;

    @JsonProperty("city")
    protected String city;

    @JsonProperty("countryOrRegionCode")
    protected String countryOrRegionCode;

    @JsonProperty("organization")
    protected String organization;

    @JsonProperty("state")
    protected String state;

    @JsonProperty("vendor")
    protected String vendor;

    protected IpReferenceData() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ipReferenceData";
    }

    @Property(name="asn")
    @JsonIgnore
    public Optional<Integer> getAsn() {
        return Optional.ofNullable(asn);
    }

    public IpReferenceData withAsn(Integer asn) {
        IpReferenceData _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipReferenceData");
        _x.asn = asn;
        return _x;
    }

    @Property(name="city")
    @JsonIgnore
    public Optional<String> getCity() {
        return Optional.ofNullable(city);
    }

    public IpReferenceData withCity(String city) {
        IpReferenceData _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipReferenceData");
        _x.city = city;
        return _x;
    }

    @Property(name="countryOrRegionCode")
    @JsonIgnore
    public Optional<String> getCountryOrRegionCode() {
        return Optional.ofNullable(countryOrRegionCode);
    }

    public IpReferenceData withCountryOrRegionCode(String countryOrRegionCode) {
        IpReferenceData _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipReferenceData");
        _x.countryOrRegionCode = countryOrRegionCode;
        return _x;
    }

    @Property(name="organization")
    @JsonIgnore
    public Optional<String> getOrganization() {
        return Optional.ofNullable(organization);
    }

    public IpReferenceData withOrganization(String organization) {
        IpReferenceData _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipReferenceData");
        _x.organization = organization;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public IpReferenceData withState(String state) {
        IpReferenceData _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipReferenceData");
        _x.state = state;
        return _x;
    }

    @Property(name="vendor")
    @JsonIgnore
    public Optional<String> getVendor() {
        return Optional.ofNullable(vendor);
    }

    public IpReferenceData withVendor(String vendor) {
        IpReferenceData _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ipReferenceData");
        _x.vendor = vendor;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer asn;
        private String city;
        private String countryOrRegionCode;
        private String organization;
        private String state;
        private String vendor;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder asn(Integer asn) {
            this.asn = asn;
            this.changedFields = changedFields.add("asn");
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            this.changedFields = changedFields.add("city");
            return this;
        }

        public Builder countryOrRegionCode(String countryOrRegionCode) {
            this.countryOrRegionCode = countryOrRegionCode;
            this.changedFields = changedFields.add("countryOrRegionCode");
            return this;
        }

        public Builder organization(String organization) {
            this.organization = organization;
            this.changedFields = changedFields.add("organization");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder vendor(String vendor) {
            this.vendor = vendor;
            this.changedFields = changedFields.add("vendor");
            return this;
        }

        public IpReferenceData build() {
            IpReferenceData _x = new IpReferenceData();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.ipReferenceData";
            _x.asn = asn;
            _x.city = city;
            _x.countryOrRegionCode = countryOrRegionCode;
            _x.organization = organization;
            _x.state = state;
            _x.vendor = vendor;
            return _x;
        }
    }

    private IpReferenceData _copy() {
        IpReferenceData _x = new IpReferenceData();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.asn = asn;
        _x.city = city;
        _x.countryOrRegionCode = countryOrRegionCode;
        _x.organization = organization;
        _x.state = state;
        _x.vendor = vendor;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IpReferenceData[");
        b.append("asn=");
        b.append(this.asn);
        b.append(", ");
        b.append("city=");
        b.append(this.city);
        b.append(", ");
        b.append("countryOrRegionCode=");
        b.append(this.countryOrRegionCode);
        b.append(", ");
        b.append("organization=");
        b.append(this.organization);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("vendor=");
        b.append(this.vendor);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
