package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Represents an iOS Web Content Filter setting type, which enables iOS automatic
 * filter feature and allows for additional URL access control. When constructed
 * with no property values, the iOS device will enable the automatic filter
 * regardless.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowedUrls", 
    "blockedUrls"})
@JsonInclude(Include.NON_NULL)
public class IosWebContentFilterAutoFilter extends IosWebContentFilterBase implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("allowedUrls")
    protected List<String> allowedUrls;

    @JsonProperty("allowedUrls@nextLink")
    protected String allowedUrlsNextLink;

    @JsonProperty("blockedUrls")
    protected List<String> blockedUrls;

    @JsonProperty("blockedUrls@nextLink")
    protected String blockedUrlsNextLink;

    protected IosWebContentFilterAutoFilter() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosWebContentFilterAutoFilter";
    }

    /**
     * <i>“Additional URLs allowed for access”</i>
     * 
     * @return property allowedUrls
     */
    @Property(name="allowedUrls")
    @JsonIgnore
    public CollectionPage<String> getAllowedUrls() {
        return new CollectionPage<String>(contextPath, String.class, allowedUrls, Optional.ofNullable(allowedUrlsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Additional URLs allowed for access”</i>
     * 
     * @return property allowedUrls
     */
    @Property(name="allowedUrls")
    @JsonIgnore
    public CollectionPage<String> getAllowedUrls(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, allowedUrls, Optional.ofNullable(allowedUrlsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Additional URLs blocked for access”</i>
     * 
     * @return property blockedUrls
     */
    @Property(name="blockedUrls")
    @JsonIgnore
    public CollectionPage<String> getBlockedUrls() {
        return new CollectionPage<String>(contextPath, String.class, blockedUrls, Optional.ofNullable(blockedUrlsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Additional URLs blocked for access”</i>
     * 
     * @return property blockedUrls
     */
    @Property(name="blockedUrls")
    @JsonIgnore
    public CollectionPage<String> getBlockedUrls(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, blockedUrls, Optional.ofNullable(blockedUrlsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosWebContentFilterAutoFilter() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> allowedUrls;
        private String allowedUrlsNextLink;
        private List<String> blockedUrls;
        private String blockedUrlsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Additional URLs allowed for access”</i>
         * 
         * @param allowedUrls
         *            value of {@code allowedUrls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedUrls(List<String> allowedUrls) {
            this.allowedUrls = allowedUrls;
            this.changedFields = changedFields.add("allowedUrls");
            return this;
        }

        /**
         * <i>“Additional URLs allowed for access”</i>
         * 
         * @param allowedUrls
         *            value of {@code allowedUrls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedUrls(String... allowedUrls) {
            return allowedUrls(Arrays.asList(allowedUrls));
        }

        /**
         * <i>“Additional URLs allowed for access”</i>
         * 
         * @param allowedUrlsNextLink
         *            value of {@code allowedUrls@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedUrlsNextLink(String allowedUrlsNextLink) {
            this.allowedUrlsNextLink = allowedUrlsNextLink;
            this.changedFields = changedFields.add("allowedUrls");
            return this;
        }

        /**
         * <i>“Additional URLs blocked for access”</i>
         * 
         * @param blockedUrls
         *            value of {@code blockedUrls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockedUrls(List<String> blockedUrls) {
            this.blockedUrls = blockedUrls;
            this.changedFields = changedFields.add("blockedUrls");
            return this;
        }

        /**
         * <i>“Additional URLs blocked for access”</i>
         * 
         * @param blockedUrls
         *            value of {@code blockedUrls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockedUrls(String... blockedUrls) {
            return blockedUrls(Arrays.asList(blockedUrls));
        }

        /**
         * <i>“Additional URLs blocked for access”</i>
         * 
         * @param blockedUrlsNextLink
         *            value of {@code blockedUrls@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockedUrlsNextLink(String blockedUrlsNextLink) {
            this.blockedUrlsNextLink = blockedUrlsNextLink;
            this.changedFields = changedFields.add("blockedUrls");
            return this;
        }

        public IosWebContentFilterAutoFilter build() {
            IosWebContentFilterAutoFilter _x = new IosWebContentFilterAutoFilter();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosWebContentFilterAutoFilter";
            _x.allowedUrls = allowedUrls;
            _x.allowedUrlsNextLink = allowedUrlsNextLink;
            _x.blockedUrls = blockedUrls;
            _x.blockedUrlsNextLink = blockedUrlsNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosWebContentFilterAutoFilter[");
        b.append("allowedUrls=");
        b.append(this.allowedUrls);
        b.append(", ");
        b.append("blockedUrls=");
        b.append(this.blockedUrls);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
