package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActionState;
import odata.msgraph.client.beta.enums.VppTokenActionFailureReason;


/**
 * <i>“Defines results for actions on iOS Vpp Apps, contains inherited properties for
 * ActionResult.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "userId", 
    "managedDeviceId", 
    "totalLicensesCount", 
    "failedLicensesCount", 
    "actionFailureReason", 
    "actionName", 
    "actionState", 
    "startDateTime", 
    "lastUpdatedDateTime"})
@JsonInclude(Include.NON_NULL)
public class IosVppAppRevokeLicensesActionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    @JsonProperty("totalLicensesCount")
    protected Integer totalLicensesCount;

    @JsonProperty("failedLicensesCount")
    protected Integer failedLicensesCount;

    @JsonProperty("actionFailureReason")
    protected VppTokenActionFailureReason actionFailureReason;

    @JsonProperty("actionName")
    protected String actionName;

    @JsonProperty("actionState")
    protected ActionState actionState;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("lastUpdatedDateTime")
    protected OffsetDateTime lastUpdatedDateTime;

    protected IosVppAppRevokeLicensesActionResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosVppAppRevokeLicensesActionResult";
    }

    /**
     * <i>“UserId associated with the action.”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“UserId associated with the action.”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public IosVppAppRevokeLicensesActionResult withUserId(String userId) {
        IosVppAppRevokeLicensesActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppRevokeLicensesActionResult");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“DeviceId associated with the action.”</i>
     * 
     * @return property managedDeviceId
     */
    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DeviceId associated with the action.”</i>
     * 
     * @param managedDeviceId
     *            new value of {@code managedDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceId} field changed
     */
    public IosVppAppRevokeLicensesActionResult withManagedDeviceId(String managedDeviceId) {
        IosVppAppRevokeLicensesActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppRevokeLicensesActionResult");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    /**
     * <i>“A count of the number of licenses for which revoke was attempted.”</i>
     * 
     * @return property totalLicensesCount
     */
    @Property(name="totalLicensesCount")
    @JsonIgnore
    public Optional<Integer> getTotalLicensesCount() {
        return Optional.ofNullable(totalLicensesCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * totalLicensesCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A count of the number of licenses for which revoke was attempted.”</i>
     * 
     * @param totalLicensesCount
     *            new value of {@code totalLicensesCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalLicensesCount} field changed
     */
    public IosVppAppRevokeLicensesActionResult withTotalLicensesCount(Integer totalLicensesCount) {
        IosVppAppRevokeLicensesActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppRevokeLicensesActionResult");
        _x.totalLicensesCount = totalLicensesCount;
        return _x;
    }

    /**
     * <i>“A count of the number of licenses for which revoke failed.”</i>
     * 
     * @return property failedLicensesCount
     */
    @Property(name="failedLicensesCount")
    @JsonIgnore
    public Optional<Integer> getFailedLicensesCount() {
        return Optional.ofNullable(failedLicensesCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * failedLicensesCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A count of the number of licenses for which revoke failed.”</i>
     * 
     * @param failedLicensesCount
     *            new value of {@code failedLicensesCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedLicensesCount} field changed
     */
    public IosVppAppRevokeLicensesActionResult withFailedLicensesCount(Integer failedLicensesCount) {
        IosVppAppRevokeLicensesActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppRevokeLicensesActionResult");
        _x.failedLicensesCount = failedLicensesCount;
        return _x;
    }

    /**
     * <i>“The reason for the revoke licenses action failure.”</i>
     * 
     * @return property actionFailureReason
     */
    @Property(name="actionFailureReason")
    @JsonIgnore
    public Optional<VppTokenActionFailureReason> getActionFailureReason() {
        return Optional.ofNullable(actionFailureReason);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * actionFailureReason} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The reason for the revoke licenses action failure.”</i>
     * 
     * @param actionFailureReason
     *            new value of {@code actionFailureReason} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code actionFailureReason} field changed
     */
    public IosVppAppRevokeLicensesActionResult withActionFailureReason(VppTokenActionFailureReason actionFailureReason) {
        IosVppAppRevokeLicensesActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppRevokeLicensesActionResult");
        _x.actionFailureReason = actionFailureReason;
        return _x;
    }

    /**
     * <i>“Action name”</i>
     * 
     * @return property actionName
     */
    @Property(name="actionName")
    @JsonIgnore
    public Optional<String> getActionName() {
        return Optional.ofNullable(actionName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code actionName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Action name”</i>
     * 
     * @param actionName
     *            new value of {@code actionName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code actionName} field changed
     */
    public IosVppAppRevokeLicensesActionResult withActionName(String actionName) {
        IosVppAppRevokeLicensesActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppRevokeLicensesActionResult");
        _x.actionName = actionName;
        return _x;
    }

    /**
     * <i>“State of the action”</i>
     * 
     * @return property actionState
     */
    @Property(name="actionState")
    @JsonIgnore
    public Optional<ActionState> getActionState() {
        return Optional.ofNullable(actionState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code actionState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“State of the action”</i>
     * 
     * @param actionState
     *            new value of {@code actionState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code actionState} field changed
     */
    public IosVppAppRevokeLicensesActionResult withActionState(ActionState actionState) {
        IosVppAppRevokeLicensesActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppRevokeLicensesActionResult");
        _x.actionState = actionState;
        return _x;
    }

    /**
     * <i>“Time the action was initiated”</i>
     * 
     * @return property startDateTime
     */
    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Time the action was initiated”</i>
     * 
     * @param startDateTime
     *            new value of {@code startDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startDateTime} field changed
     */
    public IosVppAppRevokeLicensesActionResult withStartDateTime(OffsetDateTime startDateTime) {
        IosVppAppRevokeLicensesActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppRevokeLicensesActionResult");
        _x.startDateTime = startDateTime;
        return _x;
    }

    /**
     * <i>“Time the action state was last updated”</i>
     * 
     * @return property lastUpdatedDateTime
     */
    @Property(name="lastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdatedDateTime() {
        return Optional.ofNullable(lastUpdatedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastUpdatedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Time the action state was last updated”</i>
     * 
     * @param lastUpdatedDateTime
     *            new value of {@code lastUpdatedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUpdatedDateTime} field changed
     */
    public IosVppAppRevokeLicensesActionResult withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        IosVppAppRevokeLicensesActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosVppAppRevokeLicensesActionResult");
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String userId;
        private String managedDeviceId;
        private Integer totalLicensesCount;
        private Integer failedLicensesCount;
        private VppTokenActionFailureReason actionFailureReason;
        private String actionName;
        private ActionState actionState;
        private OffsetDateTime startDateTime;
        private OffsetDateTime lastUpdatedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“UserId associated with the action.”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“DeviceId associated with the action.”</i>
         * 
         * @param managedDeviceId
         *            value of {@code managedDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        /**
         * <i>“A count of the number of licenses for which revoke was attempted.”</i>
         * 
         * @param totalLicensesCount
         *            value of {@code totalLicensesCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalLicensesCount(Integer totalLicensesCount) {
            this.totalLicensesCount = totalLicensesCount;
            this.changedFields = changedFields.add("totalLicensesCount");
            return this;
        }

        /**
         * <i>“A count of the number of licenses for which revoke failed.”</i>
         * 
         * @param failedLicensesCount
         *            value of {@code failedLicensesCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedLicensesCount(Integer failedLicensesCount) {
            this.failedLicensesCount = failedLicensesCount;
            this.changedFields = changedFields.add("failedLicensesCount");
            return this;
        }

        /**
         * <i>“The reason for the revoke licenses action failure.”</i>
         * 
         * @param actionFailureReason
         *            value of {@code actionFailureReason} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder actionFailureReason(VppTokenActionFailureReason actionFailureReason) {
            this.actionFailureReason = actionFailureReason;
            this.changedFields = changedFields.add("actionFailureReason");
            return this;
        }

        /**
         * <i>“Action name”</i>
         * 
         * @param actionName
         *            value of {@code actionName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.changedFields = changedFields.add("actionName");
            return this;
        }

        /**
         * <i>“State of the action”</i>
         * 
         * @param actionState
         *            value of {@code actionState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder actionState(ActionState actionState) {
            this.actionState = actionState;
            this.changedFields = changedFields.add("actionState");
            return this;
        }

        /**
         * <i>“Time the action was initiated”</i>
         * 
         * @param startDateTime
         *            value of {@code startDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        /**
         * <i>“Time the action state was last updated”</i>
         * 
         * @param lastUpdatedDateTime
         *            value of {@code lastUpdatedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public IosVppAppRevokeLicensesActionResult build() {
            IosVppAppRevokeLicensesActionResult _x = new IosVppAppRevokeLicensesActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosVppAppRevokeLicensesActionResult";
            _x.userId = userId;
            _x.managedDeviceId = managedDeviceId;
            _x.totalLicensesCount = totalLicensesCount;
            _x.failedLicensesCount = failedLicensesCount;
            _x.actionFailureReason = actionFailureReason;
            _x.actionName = actionName;
            _x.actionState = actionState;
            _x.startDateTime = startDateTime;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            return _x;
        }
    }

    private IosVppAppRevokeLicensesActionResult _copy() {
        IosVppAppRevokeLicensesActionResult _x = new IosVppAppRevokeLicensesActionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.userId = userId;
        _x.managedDeviceId = managedDeviceId;
        _x.totalLicensesCount = totalLicensesCount;
        _x.failedLicensesCount = failedLicensesCount;
        _x.actionFailureReason = actionFailureReason;
        _x.actionName = actionName;
        _x.actionState = actionState;
        _x.startDateTime = startDateTime;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosVppAppRevokeLicensesActionResult[");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("totalLicensesCount=");
        b.append(this.totalLicensesCount);
        b.append(", ");
        b.append("failedLicensesCount=");
        b.append(this.failedLicensesCount);
        b.append(", ");
        b.append("actionFailureReason=");
        b.append(this.actionFailureReason);
        b.append(", ");
        b.append("actionName=");
        b.append(this.actionName);
        b.append(", ");
        b.append("actionState=");
        b.append(this.actionState);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
